/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private static final long serialVersionUID = -1931571557597830536L;
    private boolean complete;

    /*
     * WARNING - void declaration
     */
    public BasicScheme(Charset credentialsCharset) {
        super((Charset)var1_1);
        void var1_1;
        this.complete = false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public BasicScheme(ChallengeState challengeState) {
        super((ChallengeState)var1_1);
        void var1_1;
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    @Override
    public String getSchemeName() {
        return "basic";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        void var1_1;
        super.processChallenge((Header)var1_1);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        void var2_2;
        void var1_1;
        return ((AuthSchemeBase)this).authenticate((Credentials)var1_1, (HttpRequest)var2_2, (HttpContext)new BasicHttpContext());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        void var2_2;
        void var1_1;
        void var3_3;
        Args.notNull((Object)credentials, (String)"Credentials");
        Args.notNull((Object)request, (String)"HTTP request");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        credentials = new Base64(0);
        byte[] base64password = credentials.encode(EncodingUtils.getBytes((String)var3_3.toString(), (String)this.getCredentialsCharset(request)));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, ((void)var1_1).length);
        return new BufferedHeader((CharArrayBuffer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Header authenticate(Credentials credentials, String charset, boolean proxy) {
        void var1_1;
        Object object;
        void var2_2;
        void var3_3;
        Args.notNull((Object)credentials, (String)"Credentials");
        Args.notNull((Object)charset, (String)"charset");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        Object base64password = Base64.encodeBase64((byte[])EncodingUtils.getBytes((String)var3_3.toString(), (String)charset), (boolean)false);
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (var2_2 != false) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append((byte[])base64password, 0, ((Object)object).length);
        return new BufferedHeader((CharArrayBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("BASIC [complete=").append(this.complete).append("]");
        return var1_1.toString();
    }
}

