/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.util.Locale;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    protected ChallengeState challengeState;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        void var1_1;
        this.challengeState = var1_1;
    }

    public AuthSchemeBase() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        void var2_3;
        void var1_2;
        int pos22;
        CharArrayBuffer buffer;
        Args.notNull((Object)header, (String)"Header");
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos22 = ((FormattedHeader)header).getValuePos();
        } else {
            void pos22;
            String s = pos22.getValue();
            if (s == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos22 = 0;
        }
        while (pos22 < buffer.length() && HTTP.isWhitespace((char)buffer.charAt(pos22))) {
            ++pos22;
        }
        int beginIndex = pos22;
        while (pos22 < buffer.length() && !HTTP.isWhitespace((char)buffer.charAt(pos22))) {
            ++pos22;
        }
        int endIndex = pos22;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            void var3_6;
            throw new MalformedChallengeException("Invalid scheme identifier: " + (String)var3_6);
        }
        this.parseChallenge(buffer, (int)var1_2, var2_3.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        void var2_2;
        void var1_1;
        return this.authenticate((Credentials)var1_1, (HttpRequest)var2_2);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        String name = this.getSchemeName();
        if (name != null) {
            void var1_1;
            return var1_1.toUpperCase(Locale.ROOT);
        }
        return super.toString();
    }
}

