/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    /*
     * WARNING - void declaration
     */
    public CookieOrigin(String host, int port, String path, boolean secure) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notBlank((CharSequence)host, (String)"Host");
        Args.notNegative((int)port, (String)"Port");
        Args.notNull((Object)path, (String)"Path");
        this.host = var1_1.toLowerCase(Locale.ROOT);
        this.port = var2_2;
        this.path = !TextUtils.isBlank((CharSequence)path) ? var3_3 : "/";
        this.secure = secure;
    }

    public final String getHost() {
        return this.host;
    }

    public final String getPath() {
        return this.path;
    }

    public final int getPort() {
        return this.port;
    }

    public final boolean isSecure() {
        return this.secure;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.secure) {
            buffer.append("(secure)");
        }
        buffer.append(this.host);
        buffer.append(':');
        buffer.append(Integer.toString(this.port));
        buffer.append(this.path);
        buffer.append(']');
        return var1_1.toString();
    }
}

