/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.net.IDN;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.util.Args;

@ThreadSafe
public final class PublicSuffixMatcher {
    private final Map<String, DomainType> rules;
    private final Map<String, DomainType> exceptions;

    /*
     * WARNING - void declaration
     */
    public PublicSuffixMatcher(Collection<String> rules, Collection<String> exceptions) {
        this(DomainType.UNKNOWN, (Collection<String>)var1_1, (Collection<String>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PublicSuffixMatcher(DomainType domainType, Collection<String> rules, Collection<String> exceptions) {
        Args.notNull((Object)((Object)domainType), (String)"Domain type");
        Args.notNull(rules, (String)"Domain suffix rules");
        this.rules = new ConcurrentHashMap<String, DomainType>(rules.size());
        for (String rule : rules) {
            this.rules.put(rule, domainType);
        }
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        if (exceptions != null) {
            void var3_3;
            for (String exception : var3_3) {
                this.exceptions.put(exception, domainType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public PublicSuffixMatcher(Collection<PublicSuffixList> lists) {
        Args.notNull(lists, (String)"Domain suffix lists");
        this.rules = new ConcurrentHashMap<String, DomainType>();
        this.exceptions = new ConcurrentHashMap<String, DomainType>();
        for (PublicSuffixList list : lists) {
            DomainType domainType = list.getType();
            List<String> list2 = list.getRules();
            for (String rule : list2) {
                this.rules.put(rule, domainType);
            }
            List<String> exceptions = list.getExceptions();
            if (exceptions == null) continue;
            for (String exception : exceptions) {
                void var2_2;
                this.exceptions.put((String)var2_2, domainType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasEntry(Map<String, DomainType> map, String rule, DomainType expectedType) {
        void var2_2;
        Object object;
        void var1_1;
        if (map == null) {
            return false;
        }
        Object domainType = map.get(var1_1);
        if (domainType == null) {
            return false;
        }
        return expectedType == null || ((Enum)object).equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasRule(String rule, DomainType expectedType) {
        void var2_2;
        void var1_1;
        return PublicSuffixMatcher.hasEntry(this.rules, (String)var1_1, (DomainType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasException(String exception, DomainType expectedType) {
        void var2_2;
        void var1_1;
        return PublicSuffixMatcher.hasEntry(this.exceptions, (String)var1_1, (DomainType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final String getDomainRoot(String domain) {
        void var1_1;
        return this.getDomainRoot((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final String getDomainRoot(String domain, DomainType expectedType) {
        void var3_3;
        if (domain == null) {
            return null;
        }
        if (domain.startsWith(".")) {
            return null;
        }
        String domainName = null;
        String segment = domain.toLowerCase(Locale.ROOT);
        while (segment != null) {
            int nextdot;
            String nextSegment;
            if (this.hasException(IDN.toUnicode(segment), expectedType)) {
                return segment;
            }
            if (this.hasRule(IDN.toUnicode(segment), expectedType) || (nextSegment = (nextdot = segment.indexOf(46)) != -1 ? segment.substring(nextdot + 1) : null) != null && this.hasRule("*." + IDN.toUnicode(nextSegment), expectedType)) break;
            if (nextdot != -1) {
                domainName = segment;
            }
            segment = nextSegment;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(String domain) {
        void var1_1;
        return this.matches((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(String domain, DomainType expectedType) {
        void var2_2;
        String string;
        if (domain == null) {
            return false;
        }
        string = this.getDomainRoot(domain.startsWith(".") ? domain.substring(1) : string, (DomainType)var2_2);
        return string == null;
    }
}

