/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.TextUtils;

@Deprecated
@ThreadSafe
public class SSLSocketFactory
implements LayeredSchemeSocketFactory,
LayeredSocketFactory,
SchemeLayeredSocketFactory,
LayeredConnectionSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public static SSLSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLSocketFactory(SSLContexts.createDefault(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    private static String[] split(String s) {
        String string;
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return string.split(" *, *");
    }

    public static SSLSocketFactory getSystemSocketFactory() throws SSLInitializationException {
        return new SSLSocketFactory((javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault(), SSLSocketFactory.split(System.getProperty("https.protocols")), SSLSocketFactory.split(System.getProperty("https.cipherSuites")), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(String algorithm, KeyStore keystore, String keyPassword, KeyStore truststore, SecureRandom random, HostNameResolver nameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().useProtocol((String)var1_1).setSecureRandom(random).loadKeyMaterial((KeyStore)var2_2, keyPassword != null ? var3_3.toCharArray() : null).loadTrustMaterial(truststore).build(), nameResolver);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(String algorithm, KeyStore keystore, String keyPassword, KeyStore truststore, SecureRandom random, TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().useProtocol((String)var1_1).setSecureRandom(random).loadKeyMaterial((KeyStore)var2_2, keyPassword != null ? var3_3.toCharArray() : null).loadTrustMaterial(truststore, trustStrategy).build(), hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(String algorithm, KeyStore keystore, String keyPassword, KeyStore truststore, SecureRandom random, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().useProtocol((String)var1_1).setSecureRandom(random).loadKeyMaterial((KeyStore)var2_2, keyPassword != null ? var3_3.toCharArray() : null).loadTrustMaterial(truststore).build(), hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(KeyStore keystore, String keystorePassword, KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().loadKeyMaterial((KeyStore)var1_1, keystorePassword != null ? var2_2.toCharArray() : null).loadTrustMaterial((KeyStore)var3_3).build(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(KeyStore keystore, String keystorePassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().loadKeyMaterial((KeyStore)var1_1, keystorePassword != null ? var2_2.toCharArray() : null).build(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().loadTrustMaterial((KeyStore)var1_1).build(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)var1_1).build(), (X509HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)var1_1).build(), BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(SSLContext sslContext) {
        this((SSLContext)var1_1, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(SSLContext sslContext, HostNameResolver nameResolver) {
        void var2_2;
        void var1_1;
        this.socketfactory = var1_1.getSocketFactory();
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.nameResolver = var2_2;
        this.supportedProtocols = null;
        this.supportedCipherSuites = null;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), null, null, (X509HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), (String[])var2_2, (String[])var3_3, hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(javax.net.ssl.SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
        this((javax.net.ssl.SSLSocketFactory)var1_1, null, null, (X509HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory(javax.net.ssl.SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.socketfactory = (javax.net.ssl.SSLSocketFactory)Args.notNull((Object)var1_1, (String)"SSL socket factory");
        this.supportedProtocols = var2_2;
        this.supportedCipherSuites = var3_3;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.nameResolver = null;
    }

    @Override
    public Socket createSocket(HttpParams params) throws IOException {
        return this.createSocket((HttpContext)null);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.createSocket((HttpContext)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Args.notNull((Object)params, (String)"HTTP parameters");
        HttpHost host = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost() : new HttpHost(remoteAddress.getHostName(), remoteAddress.getPort(), "https");
        int socketTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        int connectTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        socket.setSoTimeout(socketTimeout);
        return this.connectSocket(connectTimeout, (Socket)var1_1, host, (InetSocketAddress)var2_2, (InetSocketAddress)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        void var1_1;
        Args.notNull((Object)sock, (String)"Socket");
        Asserts.check((boolean)(sock instanceof SSLSocket), (String)"Socket not created by this factory");
        Asserts.check((!var1_1.isClosed() ? 1 : 0) != 0, (String)"Socket is closed");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createLayeredSocket((Socket)var1_1, (String)var2_2, (int)var3_3, (HttpContext)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createLayeredSocket((Socket)var1_1, (String)var2_2, (int)var3_3, (HttpContext)null);
    }

    /*
     * WARNING - void declaration
     */
    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        void var1_1;
        Args.notNull((Object)hostnameVerifier, (String)"Hostname verifier");
        this.hostnameVerifier = var1_1;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket connectSocket(Socket socket, String host, int port, InetAddress local, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        void var2_2;
        void var1_1;
        void var3_3;
        InetAddress remote = this.nameResolver != null ? this.nameResolver.resolve(host) : InetAddress.getByName(host);
        InetSocketAddress localAddress = null;
        if (local != null || localPort > 0) {
            localAddress = new InetSocketAddress(local, localPort > 0 ? localPort : 0);
        }
        HttpInetSocketAddress remoteAddress = new HttpInetSocketAddress(new HttpHost(host, port), remote, (int)var3_3);
        return this.connectSocket((Socket)var1_1, (InetSocketAddress)var2_2, localAddress, params);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createLayeredSocket((Socket)var1_1, (String)var2_2, (int)var3_3, autoClose);
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    private void internalPrepareSocket(SSLSocket socket) throws IOException {
        void var1_1;
        if (this.supportedProtocols != null) {
            socket.setEnabledProtocols(this.supportedProtocols);
        }
        if (this.supportedCipherSuites != null) {
            socket.setEnabledCipherSuites(this.supportedCipherSuites);
        }
        this.prepareSocket((SSLSocket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        void var1_1;
        SSLSocket sock = (SSLSocket)this.socketfactory.createSocket();
        this.internalPrepareSocket(sock);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        void var3_5;
        void var2_4;
        Socket sock;
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {}
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            void var1_3;
            SSLSocket sslsock = (SSLSocket)sock;
            sslsock.startHandshake();
            this.verifyHostname((SSLSocket)var1_3, host.getHostName());
            return sock;
        }
        return this.createLayeredSocket((Socket)var2_4, var3_5.getHostName(), remoteAddress.getPort(), context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        SSLSocket sslsock = (SSLSocket)this.socketfactory.createSocket(socket, target, (int)var3_3, true);
        this.internalPrepareSocket(sslsock);
        sslsock.startHandshake();
        this.verifyHostname(sslsock, (String)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        try {
            this.hostnameVerifier.verify(hostname, sslsock);
            return;
        }
        catch (IOException iox) {
            void var2_3;
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Exception exception) {}
            throw var2_3;
        }
    }
}

