/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ssl.PrivateKeyDetails;
import org.apache.http.conn.ssl.PrivateKeyStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

@Deprecated
@NotThreadSafe
public class SSLContextBuilder {
    static final String TLS = "TLS";
    static final String SSL = "SSL";
    private String protocol;
    private Set<KeyManager> keymanagers = new LinkedHashSet<KeyManager>();
    private Set<TrustManager> trustmanagers = new LinkedHashSet<TrustManager>();
    private SecureRandom secureRandom;

    public SSLContextBuilder useTLS() {
        this.protocol = TLS;
        return this;
    }

    public SSLContextBuilder useSSL() {
        this.protocol = SSL;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder useProtocol(String protocol) {
        void var1_1;
        this.protocol = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        void var1_1;
        this.secureRandom = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(KeyStore truststore, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] tms = tmfactory.getTrustManagers();
        if (tms != null) {
            if (trustStrategy != null) {
                for (int i = 0; i < tms.length; ++i) {
                    TrustManager tm = tms[i];
                    if (!(tm instanceof X509TrustManager)) continue;
                    tms[i] = new TrustManagerDelegate((X509TrustManager)tm, trustStrategy);
                }
            }
            TrustManager[] arr$ = tms;
            int len$ = tms.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                void var2_3;
                TrustManager tm = arr$[i$];
                this.trustmanagers.add((TrustManager)var2_3);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadTrustMaterial(KeyStore truststore) throws NoSuchAlgorithmException, KeyStoreException {
        void var1_1;
        return this.loadTrustMaterial((KeyStore)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        void var2_2;
        void var1_1;
        this.loadKeyMaterial((KeyStore)var1_1, (char[])var2_2, null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContextBuilder loadKeyMaterial(KeyStore keystore, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keyPassword);
        KeyManager[] kms = kmfactory.getKeyManagers();
        if (kms != null) {
            if (aliasStrategy != null) {
                for (int i = 0; i < kms.length; ++i) {
                    KeyManager km = kms[i];
                    if (!(km instanceof X509KeyManager)) continue;
                    kms[i] = new KeyManagerDelegate((X509KeyManager)km, aliasStrategy);
                }
            }
            KeyManager[] arr$ = kms;
            int len$ = kms.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                void var3_5;
                KeyManager km = arr$[i$];
                this.keymanagers.add((KeyManager)var3_5);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        void var1_1;
        SSLContext sslcontext = SSLContext.getInstance(this.protocol != null ? this.protocol : TLS);
        sslcontext.init(!this.keymanagers.isEmpty() ? this.keymanagers.toArray(new KeyManager[this.keymanagers.size()]) : null, !this.trustmanagers.isEmpty() ? this.trustmanagers.toArray(new TrustManager[this.trustmanagers.size()]) : null, this.secureRandom);
        return var1_1;
    }

    static class KeyManagerDelegate
    implements X509KeyManager {
        private final X509KeyManager keyManager;
        private final PrivateKeyStrategy aliasStrategy;

        /*
         * WARNING - void declaration
         */
        KeyManagerDelegate(X509KeyManager keyManager, PrivateKeyStrategy aliasStrategy) {
            void var2_2;
            void var1_1;
            this.keyManager = var1_1;
            this.aliasStrategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            return this.keyManager.getClientAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            void var3_3;
            HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
            String[] arr$ = keyTypes;
            int len$ = keyTypes.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String keyType = arr$[i$];
                String[] aliases = this.keyManager.getClientAliases(keyType, issuers);
                if (aliases == null) continue;
                String[] arr$2 = aliases;
                int len$2 = aliases.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    String alias = arr$2[i$2];
                    validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
                }
            }
            return this.aliasStrategy.chooseAlias(validAliases, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            void var2_2;
            void var1_1;
            return this.keyManager.getServerAliases((String)var1_1, (Principal[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            void var3_3;
            HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
            String[] aliases = this.keyManager.getServerAliases(keyType, issuers);
            if (aliases != null) {
                String[] arr$ = aliases;
                int len$ = aliases.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String alias = arr$[i$];
                    validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
                }
            }
            return this.aliasStrategy.chooseAlias(validAliases, (Socket)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            void var1_1;
            return this.keyManager.getCertificateChain((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PrivateKey getPrivateKey(String alias) {
            void var1_1;
            return this.keyManager.getPrivateKey((String)var1_1);
        }
    }

    static class TrustManagerDelegate
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private final TrustStrategy trustStrategy;

        /*
         * WARNING - void declaration
         */
        TrustManagerDelegate(X509TrustManager trustManager, TrustStrategy trustStrategy) {
            void var2_2;
            void var1_1;
            this.trustManager = var1_1;
            this.trustStrategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            void var2_2;
            void var1_1;
            this.trustManager.checkClientTrusted((X509Certificate[])var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.trustStrategy.isTrusted(chain, authType)) {
                void var2_2;
                void var1_1;
                this.trustManager.checkServerTrusted((X509Certificate[])var1_1, (String)var2_2);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

