/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@ThreadSafe
public class SSLConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    @Deprecated
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = AllowAllHostnameVerifier.INSTANCE;
    @Deprecated
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = BrowserCompatHostnameVerifier.INSTANCE;
    @Deprecated
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = StrictHostnameVerifier.INSTANCE;
    private final Log log = LogFactory.getLog(this.getClass());
    private final SSLSocketFactory socketfactory;
    private final HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    public static SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    private static String[] split(String s) {
        String string;
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return string.split(" *, *");
    }

    public static SSLConnectionSocketFactory getSystemSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), SSLConnectionSocketFactory.split(System.getProperty("https.protocols")), SSLConnectionSocketFactory.split(System.getProperty("https.cipherSuites")), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    /*
     * WARNING - void declaration
     */
    public SSLConnectionSocketFactory(SSLContext sslContext) {
        this((SSLContext)var1_1, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SSLConnectionSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), null, null, (X509HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), (String[])var2_2, (String[])var3_3, hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
        this((SSLSocketFactory)var1_1, null, null, (X509HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this((SSLSocketFactory)var1_1, (String[])var2_2, (String[])var3_3, (HostnameVerifier)hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), null, null, (HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
        this(((SSLContext)Args.notNull((Object)var1_1, (String)"SSL context")).getSocketFactory(), (String[])var2_2, (String[])var3_3, hostnameVerifier);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, HostnameVerifier hostnameVerifier) {
        this((SSLSocketFactory)var1_1, null, null, (HostnameVerifier)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.socketfactory = (SSLSocketFactory)Args.notNull((Object)var1_1, (String)"SSL socket factory");
        this.supportedProtocols = var2_2;
        this.supportedCipherSuites = var3_3;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return SocketFactory.getDefault().createSocket();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        void var3_5;
        void var2_4;
        Socket sock;
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            if (connectTimeout > 0 && sock.getSoTimeout() == 0) {
                sock.setSoTimeout(connectTimeout);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connecting socket to " + remoteAddress + " with timeout " + connectTimeout));
            }
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException iOException) {}
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            void var1_3;
            SSLSocket sslsock = (SSLSocket)sock;
            this.log.debug((Object)"Starting handshake");
            sslsock.startHandshake();
            this.verifyHostname((SSLSocket)var1_3, host.getHostName());
            return sock;
        }
        return this.createLayeredSocket((Socket)var2_4, var3_5.getHostName(), remoteAddress.getPort(), context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        void var1_1;
        void var2_2;
        SSLSocket sslsock = (SSLSocket)this.socketfactory.createSocket(socket, target, port, true);
        if (this.supportedProtocols != null) {
            sslsock.setEnabledProtocols(this.supportedProtocols);
        } else {
            String[] allProtocols = sslsock.getEnabledProtocols();
            ArrayList<String> enabledProtocols = new ArrayList<String>(allProtocols.length);
            String[] arr$ = allProtocols;
            int len$ = allProtocols.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String protocol = arr$[i$];
                if (protocol.startsWith(SSL)) continue;
                enabledProtocols.add(protocol);
            }
            if (!enabledProtocols.isEmpty()) {
                ArrayList<String> arrayList = enabledProtocols;
                sslsock.setEnabledProtocols(arrayList.toArray(new String[arrayList.size()]));
            }
        }
        if (this.supportedCipherSuites != null) {
            sslsock.setEnabledCipherSuites(this.supportedCipherSuites);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Enabled protocols: " + Arrays.asList(sslsock.getEnabledProtocols())));
            this.log.debug((Object)("Enabled cipher suites:" + Arrays.asList(sslsock.getEnabledCipherSuites())));
        }
        this.prepareSocket(sslsock);
        this.log.debug((Object)"Starting handshake");
        sslsock.startHandshake();
        this.verifyHostname(sslsock, (String)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        try {
            Object object;
            SSLSession session = sslsock.getSession();
            if (session == null) {
                object = sslsock.getInputStream();
                object.available();
                session = sslsock.getSession();
                if (session == null) {
                    sslsock.startHandshake();
                    session = sslsock.getSession();
                }
            }
            if (session == null) {
                throw new SSLHandshakeException("SSL session not available");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Secure session established");
                this.log.debug((Object)(" negotiated protocol: " + session.getProtocol()));
                this.log.debug((Object)(" negotiated cipher suite: " + session.getCipherSuite()));
                try {
                    object = session.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)object[0];
                    X500Principal peer = x509.getSubjectX500Principal();
                    this.log.debug((Object)(" peer principal: " + peer.toString()));
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        this.log.debug((Object)(" peer alternative names: " + altNames));
                    }
                    X500Principal issuer = x509.getIssuerX500Principal();
                    this.log.debug((Object)(" issuer principal: " + issuer.toString()));
                    Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                    if (altNames2 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames2) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        this.log.debug((Object)(" issuer alternative names: " + altNames));
                    }
                }
                catch (Exception exception) {}
            }
            if (!this.hostnameVerifier.verify(hostname, session)) {
                void var2_2;
                object = session.getPeerCertificates();
                object = (X509Certificate)object[0];
                X500Principal x500Principal = object.getSubjectX500Principal();
                throw new SSLPeerUnverifiedException("Host name '" + (String)var2_2 + "' does not match the certificate subject provided by the peer (" + x500Principal.toString() + ")");
            }
            return;
        }
        catch (IOException iox) {
            void var3_4;
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Exception exception) {}
            throw var3_4;
        }
    }
}

