/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.Immutable;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.conn.util.PublicSuffixMatcher;

@Immutable
public final class DefaultHostnameVerifier
implements HostnameVerifier {
    static final int DNS_NAME_TYPE = 2;
    static final int IP_ADDRESS_TYPE = 7;
    private final Log log = LogFactory.getLog(this.getClass());
    private final PublicSuffixMatcher publicSuffixMatcher;

    /*
     * WARNING - void declaration
     */
    public DefaultHostnameVerifier(PublicSuffixMatcher publicSuffixMatcher) {
        void var1_1;
        this.publicSuffixMatcher = var1_1;
    }

    public DefaultHostnameVerifier() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean verify(String host, SSLSession session) {
        try {
            void var1_1;
            session = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)session[0];
            this.verify((String)var1_1, x509);
            return true;
        }
        catch (SSLException ex) {
            if (this.log.isDebugEnabled()) {
                void var2_3;
                this.log.debug((Object)ex.getMessage(), (Throwable)var2_3);
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void verify(String host, X509Certificate cert) throws SSLException {
        void var2_2;
        void var1_1;
        boolean ipv4 = InetAddressUtils.isIPv4Address(host);
        boolean ipv6 = InetAddressUtils.isIPv6Address(host);
        int subjectType = ipv4 || ipv6 ? 7 : 2;
        List<String> subjectAlts = DefaultHostnameVerifier.extractSubjectAlts(cert, subjectType);
        if (subjectAlts != null && !subjectAlts.isEmpty()) {
            void var3_3;
            if (var3_3 != false) {
                DefaultHostnameVerifier.matchIPAddress(host, subjectAlts);
                return;
            }
            if (ipv6) {
                DefaultHostnameVerifier.matchIPv6Address(host, subjectAlts);
                return;
            }
            DefaultHostnameVerifier.matchDNSName(host, subjectAlts, this.publicSuffixMatcher);
            return;
        }
        String cn = DefaultHostnameVerifier.extractCN(((X500Principal)(cert = cert.getSubjectX500Principal())).getName("RFC2253"));
        if (cn == null) {
            throw new SSLException("Certificate subject for <" + host + "> doesn't contain a common name and does not have alternative names");
        }
        DefaultHostnameVerifier.matchCN((String)var1_1, (String)var2_2, this.publicSuffixMatcher);
    }

    /*
     * WARNING - void declaration
     */
    static void matchIPAddress(String host, List<String> subjectAlts) throws SSLException {
        void var1_1;
        String string;
        for (int i = 0; i < subjectAlts.size(); ++i) {
            void var3_3;
            String subjectAlt = subjectAlts.get(i);
            if (!host.equals(var3_3)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void matchIPv6Address(String host, List<String> subjectAlts) throws SSLException {
        void var1_1;
        String string;
        String normalisedHost = DefaultHostnameVerifier.normaliseAddress(host);
        for (int i = 0; i < subjectAlts.size(); ++i) {
            String string2 = subjectAlts.get(i);
            String normalizedSubjectAlt = DefaultHostnameVerifier.normaliseAddress(string2);
            if (!normalisedHost.equals(normalizedSubjectAlt)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void matchDNSName(String host, List<String> subjectAlts, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        void var1_1;
        String string;
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        for (int i = 0; i < subjectAlts.size(); ++i) {
            String string2 = subjectAlts.get(i);
            String normalizedSubjectAlt = string2.toLowerCase(Locale.ROOT);
            if (!DefaultHostnameVerifier.matchIdentityStrict(normalizedHost, normalizedSubjectAlt, publicSuffixMatcher)) continue;
            return;
        }
        throw new SSLException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static void matchCN(String host, String cn, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        void var2_2;
        if (!DefaultHostnameVerifier.matchIdentityStrict(host, cn, (PublicSuffixMatcher)var2_2)) {
            void var1_1;
            String string;
            throw new SSLException("Certificate for <" + string + "> doesn't match common name of the certificate subject: " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchDomainRoot(String host, String domainRoot) {
        block4: {
            block5: {
                void var1_1;
                String string;
                if (domainRoot == null) {
                    return false;
                }
                if (!host.endsWith(domainRoot)) break block4;
                if (host.length() == domainRoot.length()) break block5;
                String string2 = string;
                if (string2.charAt(string2.length() - var1_1.length() - 1) != '.') break block4;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchIdentity(String host, String identity, PublicSuffixMatcher publicSuffixMatcher, boolean strict) {
        String string;
        void var1_1;
        if (publicSuffixMatcher != null && host.contains(".") && !DefaultHostnameVerifier.matchDomainRoot(host, publicSuffixMatcher.getDomainRoot(identity, DomainType.ICANN))) {
            return false;
        }
        int asteriskIdx = identity.indexOf(42);
        if (asteriskIdx != -1) {
            void var3_4;
            void var2_3;
            String prefix = identity.substring(0, asteriskIdx);
            String suffix = identity.substring((int)(var2_3 + true));
            if (!prefix.isEmpty() && !host.startsWith(prefix)) {
                return false;
            }
            if (!suffix.isEmpty() && !host.endsWith(suffix)) {
                return false;
            }
            return var3_4 == false || !(host = host.substring(prefix.length(), host.length() - var1_1.length())).contains(".");
        }
        return string.equalsIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIdentity(String host, String identity, PublicSuffixMatcher publicSuffixMatcher) {
        void var2_2;
        void var1_1;
        return DefaultHostnameVerifier.matchIdentity(host, (String)var1_1, (PublicSuffixMatcher)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIdentity(String host, String identity) {
        void var1_1;
        return DefaultHostnameVerifier.matchIdentity(host, (String)var1_1, null, false);
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIdentityStrict(String host, String identity, PublicSuffixMatcher publicSuffixMatcher) {
        void var2_2;
        void var1_1;
        return DefaultHostnameVerifier.matchIdentity(host, (String)var1_1, (PublicSuffixMatcher)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    static boolean matchIdentityStrict(String host, String identity) {
        void var1_1;
        return DefaultHostnameVerifier.matchIdentity(host, (String)var1_1, null, true);
    }

    static String extractCN(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(subjectPrincipal);
            List<Rdn> rdns = ldapName.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Serializable serializable = rdns.get(i);
                Attribute cn = (serializable = ((Rdn)serializable).toAttributes()).get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    return serializable.toString();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                catch (NamingException namingException) {}
            }
            return null;
        }
        catch (InvalidNameException invalidNameException) {
            String string;
            throw new SSLException(string + " is not a valid X500 distinguished name");
        }
    }

    static List<String> extractSubjectAlts(X509Certificate cert, int subjectType) {
        Serializable serializable;
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {}
        Serializable subjectAltList = null;
        if (c != null) {
            Iterator<List<?>> i$ = c.iterator();
            while (i$.hasNext()) {
                List<?> list;
                List<?> list2 = list = i$.next();
                int n = (Integer)list.get(0);
                if (n != subjectType) continue;
                String s = (String)list2.get(1);
                if (subjectAltList == null) {
                    subjectAltList = new ArrayList();
                }
                subjectAltList.add(list);
            }
        }
        return serializable;
    }

    static String normaliseAddress(String hostname) {
        if (hostname == null) {
            return hostname;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            String string;
            return string;
        }
    }
}

