/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.util.Args;

@Deprecated
public abstract class AbstractVerifier
implements X509HostnameVerifier {
    private final Log log = LogFactory.getLog(this.getClass());
    static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};

    /*
     * WARNING - void declaration
     */
    @Override
    public final void verify(String host, SSLSocket ssl) throws IOException {
        void var2_2;
        void var1_1;
        Certificate[] certificateArray;
        Args.notNull((Object)host, (String)"Host");
        Object session = ssl.getSession();
        if (session == null) {
            session = ssl.getInputStream();
            ((InputStream)session).available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        certificateArray = certificateArray.getPeerCertificates();
        X509Certificate x509 = (X509Certificate)certificateArray[0];
        this.verify((String)var1_1, (X509Certificate)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean verify(String host, SSLSession session) {
        try {
            void var1_1;
            session = session.getPeerCertificates();
            X509Certificate x509 = (X509Certificate)session[0];
            this.verify((String)var1_1, x509);
            return true;
        }
        catch (SSLException ex) {
            if (this.log.isDebugEnabled()) {
                void var2_3;
                this.log.debug((Object)ex.getMessage(), (Throwable)var2_3);
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void verify(String host, X509Certificate cert) throws SSLException {
        void var1_1;
        String[] stringArray;
        String[] stringArray2;
        boolean ipv4 = InetAddressUtils.isIPv4Address(host);
        boolean ipv6 = InetAddressUtils.isIPv6Address(host);
        int subjectType = ipv4 || ipv6 ? 7 : 2;
        List<String> subjectAlts = DefaultHostnameVerifier.extractSubjectAlts(cert, subjectType);
        String cn = DefaultHostnameVerifier.extractCN(((X500Principal)(cert = cert.getSubjectX500Principal())).getName("RFC2253"));
        if (cn != null) {
            void var2_2;
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = var2_2;
        } else {
            stringArray2 = null;
        }
        if (subjectAlts != null && !subjectAlts.isEmpty()) {
            void var3_4;
            void v2 = var3_4;
            stringArray = v2.toArray(new String[v2.size()]);
        } else {
            stringArray = null;
        }
        this.verify((String)var1_1, stringArray2, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void verify(String host, String[] cns, String[] subjectAlts, boolean strictWithSubDomains) throws SSLException {
        void var1_1;
        void var2_2;
        String normalizedHost;
        String cn = cns != null && cns.length > 0 ? cns[0] : null;
        List<String> subjectAltList = subjectAlts != null && subjectAlts.length > 0 ? Arrays.asList(subjectAlts) : null;
        String string = normalizedHost = InetAddressUtils.isIPv6Address(host) ? DefaultHostnameVerifier.normaliseAddress(host.toLowerCase(Locale.ROOT)) : host;
        if (subjectAltList != null) {
            void var3_3;
            for (String subjectAlt : subjectAltList) {
                String normalizedAltSubject;
                String string2 = normalizedAltSubject = InetAddressUtils.isIPv6Address(subjectAlt) ? DefaultHostnameVerifier.normaliseAddress(subjectAlt) : normalizedAltSubject;
                if (!AbstractVerifier.matchIdentity(normalizedHost, (String)var2_2, strictWithSubDomains)) continue;
                return;
            }
            throw new SSLException("Certificate for <" + host + "> doesn't match any of the subject alternative names: " + var3_3);
        }
        if (var2_2 != null) {
            String normalizedCN;
            Object object = normalizedCN = InetAddressUtils.isIPv6Address((String)var2_2) ? DefaultHostnameVerifier.normaliseAddress((String)var2_2) : var2_2;
            if (AbstractVerifier.matchIdentity(normalizedHost, normalizedCN, strictWithSubDomains)) {
                return;
            }
            throw new SSLException("Certificate for <" + host + "> doesn't match common name of the certificate subject: " + (String)var2_2);
        }
        throw new SSLException("Certificate subject for <" + (String)var1_1 + "> doesn't contain a common name and does not have alternative names");
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchIdentity(String host, String identity, boolean strict) {
        void var1_1;
        String string;
        if (host == null) {
            return false;
        }
        String normalizedHost = host.toLowerCase(Locale.ROOT);
        String normalizedIdentity = identity.toLowerCase(Locale.ROOT);
        String[] parts = normalizedIdentity.split("\\.");
        boolean bl = parts.length >= 3 && parts[0].endsWith("*") && (!strict || AbstractVerifier.validCountryWildcard(parts));
        if (bl) {
            void var2_2;
            void var3_4;
            boolean match;
            String firstpart = parts[0];
            if (firstpart.length() > 1) {
                String prefix = firstpart.substring(0, firstpart.length() - 1);
                String suffix = normalizedIdentity.substring(firstpart.length());
                String hostSuffix = normalizedHost.substring(prefix.length());
                match = normalizedHost.startsWith(prefix) && hostSuffix.endsWith(suffix);
            } else {
                match = normalizedHost.endsWith(normalizedIdentity.substring(1));
            }
            return var3_4 != false && (var2_2 == false || AbstractVerifier.countDots(normalizedHost) == AbstractVerifier.countDots(normalizedIdentity));
        }
        return string.equals(var1_1);
    }

    private static boolean validCountryWildcard(String[] parts) {
        String[] stringArray;
        if (parts.length != 3 || parts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, stringArray[1]) < 0;
    }

    public static boolean acceptableCountryWildcard(String cn) {
        return AbstractVerifier.validCountryWildcard(cn.split("\\."));
    }

    public static String[] getCNs(X509Certificate cert) {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        try {
            String cn = DefaultHostnameVerifier.extractCN(subjectPrincipal);
            if (cn != null) {
                String string;
                return new String[]{string};
            }
            return null;
        }
        catch (SSLException sSLException) {
            return null;
        }
    }

    public static String[] getDNSSubjectAlts(X509Certificate cert) {
        List<String> subjectAlts = DefaultHostnameVerifier.extractSubjectAlts(cert, 2);
        if (subjectAlts != null && !subjectAlts.isEmpty()) {
            List<String> list;
            List<String> list2 = list;
            return list2.toArray(new String[list2.size()]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static int countDots(String s) {
        void var1_1;
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '.') continue;
            ++count;
        }
        return (int)var1_1;
    }

    static {
        Arrays.sort(BAD_COUNTRY_2LDS);
    }
}

