/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.LangUtils;

@NotThreadSafe
public final class RouteTracker
implements Cloneable,
RouteInfo {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private boolean connected;
    private HttpHost[] proxyChain;
    private RouteInfo.TunnelType tunnelled;
    private RouteInfo.LayerType layered;
    private boolean secure;

    /*
     * WARNING - void declaration
     */
    public RouteTracker(HttpHost target, InetAddress local) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)target, (String)"Target host");
        this.targetHost = var1_1;
        this.localAddress = var2_2;
        this.tunnelled = RouteInfo.TunnelType.PLAIN;
        this.layered = RouteInfo.LayerType.PLAIN;
    }

    public final void reset() {
        this.connected = false;
        this.proxyChain = null;
        this.tunnelled = RouteInfo.TunnelType.PLAIN;
        this.layered = RouteInfo.LayerType.PLAIN;
        this.secure = false;
    }

    /*
     * WARNING - void declaration
     */
    public RouteTracker(HttpRoute route) {
        this(route.getTargetHost(), var1_1.getLocalAddress());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void connectTarget(boolean secure) {
        void var1_1;
        Asserts.check((!this.connected ? 1 : 0) != 0, (String)"Already connected");
        this.connected = true;
        this.secure = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void connectProxy(HttpHost proxy, boolean secure) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)proxy, (String)"Proxy host");
        Asserts.check((!this.connected ? 1 : 0) != 0, (String)"Already connected");
        this.connected = true;
        this.proxyChain = new HttpHost[]{var1_1};
        this.secure = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void tunnelTarget(boolean secure) {
        void var1_1;
        Asserts.check((boolean)this.connected, (String)"No tunnel unless connected");
        Asserts.notNull((Object)this.proxyChain, (String)"No tunnel without proxy");
        this.tunnelled = RouteInfo.TunnelType.TUNNELLED;
        this.secure = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void tunnelProxy(HttpHost proxy, boolean secure) {
        void var2_2;
        void var3_3;
        void var1_1;
        Args.notNull((Object)proxy, (String)"Proxy host");
        Asserts.check((boolean)this.connected, (String)"No tunnel unless connected");
        Asserts.notNull((Object)this.proxyChain, (String)"No tunnel without proxy");
        HttpHost[] proxies = new HttpHost[this.proxyChain.length + 1];
        System.arraycopy(this.proxyChain, 0, proxies, 0, this.proxyChain.length);
        proxies[proxies.length - 1] = var1_1;
        this.proxyChain = var3_3;
        this.secure = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void layerProtocol(boolean secure) {
        void var1_1;
        Asserts.check((boolean)this.connected, (String)"No layered protocol unless connected");
        this.layered = RouteInfo.LayerType.LAYERED;
        this.secure = var1_1;
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getHopCount() {
        void var1_1;
        int hops = 0;
        if (this.connected) {
            hops = this.proxyChain == null ? 1 : this.proxyChain.length + 1;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HttpHost getHopTarget(int hop) {
        void var1_2;
        void var2_3;
        Args.notNegative((int)hop, (String)"Hop index");
        int hopcount = this.getHopCount();
        Args.check((hop < hopcount ? 1 : 0) != 0, (String)"Hop index exceeds tracked route length");
        HttpHost result = hop < var2_3 - true ? this.proxyChain[hop] : this.targetHost;
        return var1_2;
    }

    @Override
    public final HttpHost getProxyHost() {
        if (this.proxyChain == null) {
            return null;
        }
        return this.proxyChain[0];
    }

    public final boolean isConnected() {
        return this.connected;
    }

    @Override
    public final RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    public final HttpRoute toRoute() {
        if (!this.connected) {
            return null;
        }
        return new HttpRoute(this.targetHost, this.localAddress, this.proxyChain, this.secure, this.tunnelled, this.layered);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof RouteTracker)) {
            return false;
        }
        RouteTracker that = (RouteTracker)o;
        return this.connected == that.connected && this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered && LangUtils.equals((Object)this.targetHost, (Object)that.targetHost) && LangUtils.equals((Object)this.localAddress, (Object)that.localAddress) && LangUtils.equals((Object[])this.proxyChain, (Object[])var1_1.proxyChain);
    }

    public final int hashCode() {
        int n = LangUtils.hashCode((int)17, (Object)this.targetHost);
        int hash = LangUtils.hashCode((int)n, (Object)this.localAddress);
        if (this.proxyChain != null) {
            HttpHost[] arr$ = this.proxyChain;
            int len$ = this.proxyChain.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                HttpHost element = arr$[i$];
                hash = LangUtils.hashCode((int)hash, (Object)element);
            }
        }
        n = LangUtils.hashCode((int)n, (boolean)this.connected);
        n = LangUtils.hashCode((int)n, (boolean)this.secure);
        n = LangUtils.hashCode((int)n, (Object)((Object)this.tunnelled));
        n = LangUtils.hashCode((int)n, (Object)((Object)this.layered));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder cab = new StringBuilder(50 + this.getHopCount() * 30);
        cab.append("RouteTracker[");
        if (this.localAddress != null) {
            cab.append(this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.connected) {
            cab.append('c');
        }
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            cab.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            HttpHost[] arr$ = this.proxyChain;
            int len$ = this.proxyChain.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                HttpHost element = arr$[i$];
                cab.append(element);
                cab.append("->");
            }
        }
        cab.append(this.targetHost);
        cab.append(']');
        return var1_1.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

