/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Immutable
public final class HttpRoute
implements Cloneable,
RouteInfo {
    private final HttpHost targetHost;
    private final InetAddress localAddress;
    private final List<HttpHost> proxyChain;
    private final RouteInfo.TunnelType tunnelled;
    private final RouteInfo.LayerType layered;
    private final boolean secure;

    /*
     * WARNING - void declaration
     */
    private HttpRoute(HttpHost target, InetAddress local, List<HttpHost> proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)target, (String)"Target host");
        this.targetHost = HttpRoute.normalize((HttpHost)var1_1);
        this.localAddress = var2_2;
        this.proxyChain = proxies != null && !proxies.isEmpty() ? new ArrayList<HttpHost>((Collection<HttpHost>)var3_3) : null;
        if (tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            Args.check((this.proxyChain != null ? 1 : 0) != 0, (String)"Proxy required if tunnelled");
        }
        this.secure = secure;
        this.tunnelled = tunnelled != null ? tunnelled : RouteInfo.TunnelType.PLAIN;
        this.layered = layered != null ? layered : RouteInfo.LayerType.PLAIN;
    }

    private static int getDefaultPort(String schemeName) {
        String string;
        if ("http".equalsIgnoreCase(schemeName)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static HttpHost normalize(HttpHost target) {
        void var2_2;
        Object object;
        if (target.getPort() >= 0) {
            return target;
        }
        InetAddress address = target.getAddress();
        String schemeName = target.getSchemeName();
        if (address != null) {
            void var1_1;
            return new HttpHost((InetAddress)var1_1, HttpRoute.getDefaultPort(schemeName), schemeName);
        }
        Object hostName = target.getHostName();
        return new HttpHost((String)object, HttpRoute.getDefaultPort(schemeName), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target, InetAddress local, HttpHost[] proxies, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        this((HttpHost)var1_1, (InetAddress)var2_2, proxies != null ? Arrays.asList(var3_3) : null, secure, tunnelled, layered);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure, RouteInfo.TunnelType tunnelled, RouteInfo.LayerType layered) {
        this((HttpHost)var1_1, (InetAddress)var2_2, proxy != null ? Collections.singletonList(var3_3) : null, secure, tunnelled, layered);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target, InetAddress local, boolean secure) {
        this((HttpHost)var1_1, (InetAddress)var2_2, Collections.emptyList(), (boolean)var3_3, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target) {
        this((HttpHost)var1_1, null, Collections.emptyList(), false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target, InetAddress local, HttpHost proxy, boolean secure) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl = secure;
        this((HttpHost)var1_1, (InetAddress)var2_2, Collections.singletonList(Args.notNull((Object)var3_3, (String)"Proxy host")), bl, bl ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN, secure ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN);
    }

    /*
     * WARNING - void declaration
     */
    public HttpRoute(HttpHost target, HttpHost proxy) {
        this((HttpHost)var1_1, null, (HttpHost)var2_2, false);
        void var2_2;
        void var1_1;
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public final InetSocketAddress getLocalSocketAddress() {
        if (this.localAddress != null) {
            return new InetSocketAddress(this.localAddress, 0);
        }
        return null;
    }

    @Override
    public final int getHopCount() {
        if (this.proxyChain != null) {
            return this.proxyChain.size() + 1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HttpHost getHopTarget(int hop) {
        void var2_2;
        Args.notNegative((int)hop, (String)"Hop index");
        int hopcount = this.getHopCount();
        Args.check((hop < hopcount ? 1 : 0) != 0, (String)"Hop index exceeds tracked route length");
        if (hop < var2_2 - true) {
            void var1_1;
            return this.proxyChain.get((int)var1_1);
        }
        return this.targetHost;
    }

    @Override
    public final HttpHost getProxyHost() {
        if (this.proxyChain != null && !this.proxyChain.isEmpty()) {
            return this.proxyChain.get(0);
        }
        return null;
    }

    @Override
    public final RouteInfo.TunnelType getTunnelType() {
        return this.tunnelled;
    }

    @Override
    public final boolean isTunnelled() {
        return this.tunnelled == RouteInfo.TunnelType.TUNNELLED;
    }

    @Override
    public final RouteInfo.LayerType getLayerType() {
        return this.layered;
    }

    @Override
    public final boolean isLayered() {
        return this.layered == RouteInfo.LayerType.LAYERED;
    }

    @Override
    public final boolean isSecure() {
        return this.secure;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpRoute) {
            void var1_1;
            HttpRoute that = (HttpRoute)obj;
            return this.secure == that.secure && this.tunnelled == that.tunnelled && this.layered == that.layered && LangUtils.equals((Object)this.targetHost, (Object)that.targetHost) && LangUtils.equals((Object)this.localAddress, (Object)that.localAddress) && LangUtils.equals(this.proxyChain, var1_1.proxyChain);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        int n = LangUtils.hashCode((int)17, (Object)this.targetHost);
        int hash = LangUtils.hashCode((int)n, (Object)this.localAddress);
        if (this.proxyChain != null) {
            for (HttpHost element : this.proxyChain) {
                void var3_3;
                hash = LangUtils.hashCode((int)hash, (Object)var3_3);
            }
        }
        n = LangUtils.hashCode((int)n, (boolean)this.secure);
        n = LangUtils.hashCode((int)n, (Object)((Object)this.tunnelled));
        n = LangUtils.hashCode((int)n, (Object)((Object)this.layered));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder cab = new StringBuilder(50 + this.getHopCount() * 30);
        if (this.localAddress != null) {
            cab.append(this.localAddress);
            cab.append("->");
        }
        cab.append('{');
        if (this.tunnelled == RouteInfo.TunnelType.TUNNELLED) {
            cab.append('t');
        }
        if (this.layered == RouteInfo.LayerType.LAYERED) {
            cab.append('l');
        }
        if (this.secure) {
            cab.append('s');
        }
        cab.append("}->");
        if (this.proxyChain != null) {
            for (HttpHost aProxyChain : this.proxyChain) {
                void var3_3;
                cab.append(var3_3);
                cab.append("->");
            }
        }
        cab.append(this.targetHost);
        return var1_1.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

