/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.util.Args;

@NotThreadSafe
public class EofSensorInputStream
extends InputStream
implements ConnectionReleaseTrigger {
    protected InputStream wrappedStream;
    private boolean selfClosed;
    private final EofSensorWatcher eofWatcher;

    /*
     * WARNING - void declaration
     */
    public EofSensorInputStream(InputStream in, EofSensorWatcher watcher) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)in, (String)"Wrapped stream");
        this.wrappedStream = var1_1;
        this.selfClosed = false;
        this.eofWatcher = var2_2;
    }

    boolean isSelfClosed() {
        return this.selfClosed;
    }

    InputStream getWrappedStream() {
        return this.wrappedStream;
    }

    protected boolean isReadAllowed() throws IOException {
        if (this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.wrappedStream != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        void var1_1;
        int l = -1;
        if (this.isReadAllowed()) {
            try {
                l = this.wrappedStream.read();
                this.checkEOF(l);
            }
            catch (IOException ex) {
                void var1_2;
                this.checkAbort();
                throw var1_2;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        if (this.isReadAllowed()) {
            try {
                void var3_4;
                void var2_3;
                l = this.wrappedStream.read(b, (int)var2_3, (int)var3_4);
                this.checkEOF(l);
            }
            catch (IOException ex) {
                void var1_2;
                this.checkAbort();
                throw var1_2;
            }
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        void var1_1;
        return this.read(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int available() throws IOException {
        void var1_1;
        int a = 0;
        if (this.isReadAllowed()) {
            try {
                a = this.wrappedStream.available();
            }
            catch (IOException ex) {
                void var1_2;
                this.checkAbort();
                throw var1_2;
            }
        }
        return (int)var1_1;
    }

    @Override
    public void close() throws IOException {
        this.selfClosed = true;
        this.checkClose();
    }

    /*
     * WARNING - void declaration
     */
    protected void checkEOF(int eof) throws IOException {
        if (this.wrappedStream != null && eof < 0) {
            try {
                void var1_1;
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.eofDetected(this.wrappedStream);
                }
                if (var1_1 != false) {
                    this.wrappedStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkClose() throws IOException {
        if (this.wrappedStream != null) {
            try {
                void var1_1;
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.streamClosed(this.wrappedStream);
                }
                if (var1_1 != false) {
                    this.wrappedStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkAbort() throws IOException {
        if (this.wrappedStream != null) {
            try {
                void var1_1;
                boolean scws = true;
                if (this.eofWatcher != null) {
                    scws = this.eofWatcher.streamAbort(this.wrappedStream);
                }
                if (var1_1 != false) {
                    this.wrappedStream.close();
                }
                return;
            }
            finally {
                this.wrappedStream = null;
            }
        }
    }

    @Override
    public void releaseConnection() throws IOException {
        this.close();
    }

    @Override
    public void abortConnection() throws IOException {
        this.selfClosed = true;
        this.checkAbort();
    }
}

