/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class URLEncodedUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final char QP_SEP_A = '&';
    private static final char QP_SEP_S = ';';
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;
    private static final int RADIX = 16;

    /*
     * WARNING - void declaration
     */
    public static List<NameValuePair> parse(URI uri, String charset) {
        String query = uri.getRawQuery();
        if (query != null && !query.isEmpty()) {
            void var1_1;
            String string;
            return URLEncodedUtils.parse(string, Charset.forName((String)var1_1));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        void var1_1;
        void var2_4;
        CharArrayBuffer buf;
        ContentType contentType = ContentType.get((HttpEntity)entity);
        if (contentType == null || !contentType.getMimeType().equalsIgnoreCase(CONTENT_TYPE)) {
            return Collections.emptyList();
        }
        long len = entity.getContentLength();
        Args.check((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity is too large");
        Charset charset22 = contentType.getCharset() != null ? contentType.getCharset() : HTTP.DEF_CONTENT_CHARSET;
        InputStream instream = entity.getContent();
        if (instream == null) {
            return Collections.emptyList();
        }
        try {
            int l;
            buf = new CharArrayBuffer(len > 0L ? (int)len : 1024);
            InputStreamReader reader = new InputStreamReader(instream, charset22);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buf.append(tmp, 0, l);
            }
        }
        catch (Throwable charset22) {
            InputStream inputStream;
            inputStream.close();
            throw charset22;
        }
        instream.close();
        if (buf.length() == 0) {
            return Collections.emptyList();
        }
        return URLEncodedUtils.parse((CharArrayBuffer)var2_4, (Charset)var1_1, '&');
    }

    public static boolean isEncoded(HttpEntity entity) {
        Object elems;
        Object h = entity.getContentType();
        if (h != null && ((HeaderElement[])(elems = h.getElements())).length > 0) {
            Object object;
            object = object[0].getName();
            return object.equalsIgnoreCase(CONTENT_TYPE);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void parse(List<NameValuePair> parameters, Scanner scanner, String charset) {
        void var2_2;
        void var1_1;
        URLEncodedUtils.parse(parameters, (Scanner)var1_1, "[&;]", (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void parse(List<NameValuePair> parameters, Scanner scanner, String parameterSepartorPattern, String charset) {
        scanner.useDelimiter(parameterSepartorPattern);
        while (scanner.hasNext()) {
            void var2_2;
            String value;
            String name;
            String token = scanner.next();
            int i = token.indexOf(NAME_VALUE_SEPARATOR);
            if (i != -1) {
                name = URLEncodedUtils.decodeFormFields(token.substring(0, i).trim(), charset);
                value = URLEncodedUtils.decodeFormFields(token.substring(i + 1).trim(), charset);
            } else {
                name = URLEncodedUtils.decodeFormFields(value.trim(), charset);
                value = null;
            }
            parameters.add((NameValuePair)new BasicNameValuePair((String)var2_2, value));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<NameValuePair> parse(String s, Charset charset) {
        void var1_1;
        void var2_2;
        String string;
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(string);
        return URLEncodedUtils.parse((CharArrayBuffer)var2_2, (Charset)var1_1, '&', ';');
    }

    /*
     * WARNING - void declaration
     */
    public static List<NameValuePair> parse(String s, Charset charset, char ... separators) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string;
        if (s == null) {
            return Collections.emptyList();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(string);
        return URLEncodedUtils.parse((CharArrayBuffer)var3_3, (Charset)var1_1, (char[])var2_2);
    }

    public static List<NameValuePair> parse(CharArrayBuffer buf, Charset charset, char ... separators) {
        Args.notNull((Object)buf, (String)"Char array buffer");
        TokenParser tokenParser = TokenParser.INSTANCE;
        BitSet delimSet = new BitSet();
        char[] arr$ = separators;
        int len$ = separators.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char separator = arr$[i$];
            delimSet.set(separator);
        }
        ParserCursor cursor = new ParserCursor(0, buf.length());
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            delimSet.set(61);
            String name = tokenParser.parseToken(buf, cursor, delimSet);
            String value = null;
            if (!cursor.atEnd()) {
                char delim = buf.charAt(cursor.getPos());
                ParserCursor parserCursor = cursor;
                parserCursor.updatePos(parserCursor.getPos() + 1);
                if (delim == '=') {
                    delimSet.clear(61);
                    value = tokenParser.parseValue(buf, cursor, delimSet);
                    if (!cursor.atEnd()) {
                        ParserCursor parserCursor2 = cursor;
                        parserCursor2.updatePos(parserCursor2.getPos() + 1);
                    }
                }
            }
            if (name.isEmpty()) continue;
            list.add((NameValuePair)new BasicNameValuePair(URLEncodedUtils.decodeFormFields(name, charset), URLEncodedUtils.decodeFormFields(value, charset)));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static String format(List<? extends NameValuePair> parameters, String charset) {
        void var1_1;
        return URLEncodedUtils.format(parameters, '&', (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(List<? extends NameValuePair> parameters, char parameterSeparator, String charset) {
        void var3_3;
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encodeFormFields(nameValuePair.getName(), charset);
            String string = URLEncodedUtils.encodeFormFields(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            result.append(encodedName);
            if (string == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(string);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Iterable<? extends NameValuePair> parameters, Charset charset) {
        void var1_1;
        return URLEncodedUtils.format(parameters, '&', (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(Iterable<? extends NameValuePair> parameters, char parameterSeparator, Charset charset) {
        void var3_3;
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedName = URLEncodedUtils.encodeFormFields(nameValuePair.getName(), charset);
            String string = URLEncodedUtils.encodeFormFields(nameValuePair.getValue(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            result.append(encodedName);
            if (string == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(string);
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String urlEncode(String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            void var1_2;
            int b = bb.get() & 0xFF;
            if (safechars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append('+');
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append((char)var1_2);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
        void var3_3;
        void var1_1;
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharSequence cb = CharBuffer.wrap(content);
        while (((Buffer)((Object)cb)).hasRemaining()) {
            void var4_4;
            char c = ((CharBuffer)cb).get();
            if (c == '%' && ((Buffer)((Object)cb)).remaining() >= 2) {
                char uc = ((CharBuffer)cb).get();
                char lc = ((CharBuffer)cb).get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && var4_4 == 43) {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)var4_4);
        }
        bb.flip();
        return var1_1.decode((ByteBuffer)var3_3).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeFormFields(String content, String charset) {
        void var1_1;
        String string;
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.urlDecode(string, charset != null ? Charset.forName((String)var1_1) : Consts.UTF_8, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String decodeFormFields(String content, Charset charset) {
        void var1_1;
        String string;
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.urlDecode(string, (Charset)(charset != null ? var1_1 : Consts.UTF_8), true);
    }

    /*
     * WARNING - void declaration
     */
    private static String encodeFormFields(String content, String charset) {
        void var1_1;
        String string;
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.urlEncode(string, charset != null ? Charset.forName((String)var1_1) : Consts.UTF_8, URLENCODER, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String encodeFormFields(String content, Charset charset) {
        void var1_1;
        String string;
        if (content == null) {
            return null;
        }
        return URLEncodedUtils.urlEncode(string, (Charset)(charset != null ? var1_1 : Consts.UTF_8), URLENCODER, true);
    }

    /*
     * WARNING - void declaration
     */
    static String encUserInfo(String content, Charset charset) {
        void var1_1;
        return URLEncodedUtils.urlEncode(content, (Charset)var1_1, USERINFO, false);
    }

    /*
     * WARNING - void declaration
     */
    static String encUric(String content, Charset charset) {
        void var1_1;
        return URLEncodedUtils.urlEncode(content, (Charset)var1_1, URIC, false);
    }

    /*
     * WARNING - void declaration
     */
    static String encPath(String content, Charset charset) {
        void var1_1;
        return URLEncodedUtils.urlEncode(content, (Charset)var1_1, PATHSAFE, false);
    }

    static {
        int i;
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(47);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }
}

