/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public class URIUtils {
    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static URI createURI(String scheme, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer = new StringBuilder();
        if (host != null) {
            void var1_1;
            if (scheme != null) {
                String string;
                buffer.append(string);
                buffer.append("://");
            }
            buffer.append((String)var1_1);
            if (port > 0) {
                void var2_2;
                buffer.append(':');
                buffer.append((int)var2_2);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append('/');
        }
        if (path != null) {
            void var3_3;
            buffer.append((String)var3_3);
        }
        if (query != null) {
            buffer.append('?');
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append('#');
            buffer.append(fragment);
        }
        return new URI(buffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static URI rewriteURI(URI uri, HttpHost target, boolean dropFragment) throws URISyntaxException {
        URIBuilder uRIBuilder;
        void var2_2;
        Args.notNull((Object)uri, (String)"URI");
        if (uri.isOpaque()) {
            return uri;
        }
        URIBuilder uribuilder = new URIBuilder(uri);
        if (target != null) {
            void var1_1;
            uribuilder.setScheme(target.getSchemeName());
            uribuilder.setHost(target.getHostName());
            uribuilder.setPort(var1_1.getPort());
        } else {
            uribuilder.setScheme(null);
            uribuilder.setHost(null);
            uribuilder.setPort(-1);
        }
        if (var2_2 != false) {
            uribuilder.setFragment(null);
        }
        if (TextUtils.isEmpty((CharSequence)uribuilder.getPath())) {
            uribuilder.setPath("/");
        }
        return uRIBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static URI rewriteURI(URI uri, HttpHost target) throws URISyntaxException {
        void var1_1;
        return URIUtils.rewriteURI(uri, (HttpHost)var1_1, false);
    }

    public static URI rewriteURI(URI uri) throws URISyntaxException {
        URIBuilder uRIBuilder;
        Args.notNull((Object)uri, (String)"URI");
        if (uri.isOpaque()) {
            return uri;
        }
        URIBuilder uribuilder = new URIBuilder(uri);
        if (uribuilder.getUserInfo() != null) {
            uribuilder.setUserInfo(null);
        }
        if (TextUtils.isEmpty((CharSequence)uribuilder.getPath())) {
            uribuilder.setPath("/");
        }
        if (uribuilder.getHost() != null) {
            URIBuilder uRIBuilder2 = uribuilder;
            uRIBuilder2.setHost(uRIBuilder2.getHost().toLowerCase(Locale.ROOT));
        }
        uribuilder.setFragment(null);
        return uRIBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static URI rewriteURIForRoute(URI uri, RouteInfo route) throws URISyntaxException {
        URI uRI;
        if (uri == null) {
            return null;
        }
        if (route.getProxyHost() != null && !route.isTunnelled()) {
            if (!uri.isAbsolute()) {
                void var1_1;
                HttpHost target = route.getTargetHost();
                return URIUtils.rewriteURI(uri, (HttpHost)var1_1, true);
            }
            return URIUtils.rewriteURI(uri);
        }
        if (uri.isAbsolute()) {
            return URIUtils.rewriteURI(uri, null, true);
        }
        return URIUtils.rewriteURI(uRI);
    }

    /*
     * WARNING - void declaration
     */
    public static URI resolve(URI baseURI, String reference) {
        void var1_1;
        return URIUtils.resolve(baseURI, URI.create((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static URI resolve(URI baseURI, URI reference) {
        String resolved;
        void var2_4;
        Args.notNull((Object)baseURI, (String)"Base URI");
        Args.notNull((Object)reference, (String)"Reference URI");
        String s = reference.toASCIIString();
        if (s.startsWith("?")) {
            void var3_5;
            String baseUri = baseURI.toASCIIString();
            int i = baseUri.indexOf(63);
            baseUri = i >= 0 ? baseUri.substring(0, i) : baseUri;
            return URI.create((String)var3_5 + s);
        }
        boolean bl = var2_4.isEmpty();
        if (bl) {
            String i;
            i = ((URI)((Object)i)).resolve(URI.create("#"));
            String resolvedString = ((URI)((Object)i)).toASCIIString();
            resolved = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        } else {
            void var1_3;
            resolved = ((URI)((Object)resolved)).resolve((URI)var1_3);
        }
        try {
            return URIUtils.normalizeSyntax((URI)((Object)resolved));
        }
        catch (URISyntaxException ex) {
            void var0_2;
            throw new IllegalArgumentException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static URI normalizeSyntax(URI uri) throws URISyntaxException {
        URIBuilder uRIBuilder;
        if (uri.isOpaque() || uri.getAuthority() == null) {
            return uri;
        }
        Args.check((boolean)uri.isAbsolute(), (String)"Base URI must be absolute");
        URIBuilder builder = new URIBuilder(uri);
        String path = builder.getPath();
        if (path != null && !path.equals("/")) {
            void var2_2;
            void var1_1;
            void var3_3;
            String[] inputSegments = path.split("/");
            Stack<String> outputSegments = new Stack<String>();
            String[] arr$ = inputSegments;
            int len$ = inputSegments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String inputSegment = arr$[i$];
                if (inputSegment.isEmpty() || ".".equals(inputSegment)) continue;
                if ("..".equals(inputSegment)) {
                    if (outputSegments.isEmpty()) continue;
                    outputSegments.pop();
                    continue;
                }
                outputSegments.push(inputSegment);
            }
            StringBuilder outputBuffer = new StringBuilder();
            for (String outputSegment : var3_3) {
                outputBuffer.append('/').append(outputSegment);
            }
            if (path.lastIndexOf(47) == var1_1.length() - 1) {
                outputBuffer.append('/');
            }
            builder.setPath(var2_2.toString());
        }
        if (builder.getScheme() != null) {
            Object object = builder;
            ((URIBuilder)object).setScheme(((URIBuilder)object).getScheme().toLowerCase(Locale.ROOT));
        }
        if (builder.getHost() != null) {
            Object object = builder;
            ((URIBuilder)object).setHost(((URIBuilder)object).getHost().toLowerCase(Locale.ROOT));
        }
        return uRIBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static HttpHost extractHost(URI uri) {
        void var1_1;
        if (uri == null) {
            return null;
        }
        HttpHost target = null;
        if (uri.isAbsolute()) {
            URI uRI;
            int port = uri.getPort();
            String host = uri.getHost();
            if (host == null && (host = uri.getAuthority()) != null) {
                int colon;
                int at = host.indexOf(64);
                if (at >= 0) {
                    host = host.length() > at + 1 ? host.substring(at + 1) : null;
                }
                if (host != null && (colon = host.indexOf(58)) >= 0) {
                    int pos = colon + 1;
                    int len = 0;
                    for (int i = pos; i < host.length() && Character.isDigit(host.charAt(i)); ++i) {
                        ++len;
                    }
                    if (len > 0) {
                        try {
                            int n = pos;
                            port = Integer.parseInt(host.substring(n, n + len));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    host = host.substring(0, colon);
                }
            }
            String scheme = uRI.getScheme();
            if (!TextUtils.isBlank((CharSequence)host)) {
                try {
                    void var2_2;
                    void var3_3;
                    target = new HttpHost((String)var3_3, (int)var2_2, scheme);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static URI resolve(URI originalURI, HttpHost target, List<URI> redirects) throws URISyntaxException {
        void var3_3;
        URIBuilder uribuilder;
        Args.notNull((Object)originalURI, (String)"Request URI");
        if (redirects == null || redirects.isEmpty()) {
            uribuilder = new URIBuilder(originalURI);
        } else {
            List<URI> list = redirects;
            uribuilder = new URIBuilder(list.get(list.size() - 1));
            String frag = uribuilder.getFragment();
            for (int i = redirects.size() - 1; frag == null && i >= 0; --i) {
                frag = redirects.get(i).getFragment();
            }
            uribuilder.setFragment(frag);
        }
        if (uribuilder.getFragment() == null) {
            URI uRI;
            uribuilder.setFragment(uRI.getFragment());
        }
        if (target != null && !uribuilder.isAbsolute()) {
            void var1_1;
            uribuilder.setScheme(target.getSchemeName());
            uribuilder.setHost(target.getHostName());
            uribuilder.setPort(var1_1.getPort());
        }
        return var3_3.build();
    }

    private URIUtils() {
    }
}

