/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.message.BasicNameValuePair;

@NotThreadSafe
public class URIBuilder {
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String path;
    private String encodedPath;
    private String encodedQuery;
    private List<NameValuePair> queryParams;
    private String query;
    private Charset charset;
    private String fragment;
    private String encodedFragment;

    public URIBuilder() {
        this.port = -1;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder(String string) throws URISyntaxException {
        void var1_1;
        this.digestURI(new URI((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder(URI uri) {
        void var1_1;
        this.digestURI((URI)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    /*
     * WARNING - void declaration
     */
    private List<NameValuePair> parseQuery(String query, Charset charset) {
        if (query != null && !query.isEmpty()) {
            void var2_2;
            void var1_1;
            return URLEncodedUtils.parse((String)var1_1, (Charset)var2_2);
        }
        return null;
    }

    public URI build() throws URISyntaxException {
        return new URI(this.buildString());
    }

    /*
     * WARNING - void declaration
     */
    private String buildString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            sb.append(this.encodedSchemeSpecificPart);
        } else {
            if (this.encodedAuthority != null) {
                sb.append("//").append(this.encodedAuthority);
            } else if (this.host != null) {
                sb.append("//");
                if (this.encodedUserInfo != null) {
                    sb.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    URIBuilder uRIBuilder = this;
                    sb.append(uRIBuilder.encodeUserInfo(uRIBuilder.userInfo)).append("@");
                }
                if (InetAddressUtils.isIPv6Address(this.host)) {
                    sb.append("[").append(this.host).append("]");
                } else {
                    sb.append(this.host);
                }
                if (this.port >= 0) {
                    sb.append(":").append(this.port);
                }
            }
            if (this.encodedPath != null) {
                sb.append(URIBuilder.normalizePath(this.encodedPath));
            } else if (this.path != null) {
                URIBuilder uRIBuilder = this;
                sb.append(uRIBuilder.encodePath(URIBuilder.normalizePath(uRIBuilder.path)));
            }
            if (this.encodedQuery != null) {
                sb.append("?").append(this.encodedQuery);
            } else if (this.queryParams != null) {
                URIBuilder uRIBuilder = this;
                sb.append("?").append(uRIBuilder.encodeUrlForm(uRIBuilder.queryParams));
            } else if (this.query != null) {
                URIBuilder uRIBuilder = this;
                sb.append("?").append(uRIBuilder.encodeUric(uRIBuilder.query));
            }
        }
        if (this.encodedFragment != null) {
            sb.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            URIBuilder uRIBuilder = this;
            sb.append("#").append(uRIBuilder.encodeUric(uRIBuilder.fragment));
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void digestURI(URI uri) {
        void var1_1;
        this.scheme = uri.getScheme();
        this.encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        this.encodedAuthority = uri.getRawAuthority();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.encodedUserInfo = uri.getRawUserInfo();
        this.userInfo = uri.getUserInfo();
        this.encodedPath = uri.getRawPath();
        this.path = uri.getPath();
        this.encodedQuery = uri.getRawQuery();
        this.queryParams = this.parseQuery(uri.getRawQuery(), this.charset != null ? this.charset : Consts.UTF_8);
        this.encodedFragment = uri.getRawFragment();
        this.fragment = var1_1.getFragment();
    }

    private String encodeUserInfo(String userInfo) {
        return URLEncodedUtils.encUserInfo(userInfo, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodePath(String path) {
        return URLEncodedUtils.encPath(path, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodeUrlForm(List<NameValuePair> params) {
        return URLEncodedUtils.format(params, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodeUric(String fragment) {
        return URLEncodedUtils.encUric(fragment, this.charset != null ? this.charset : Consts.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setScheme(String scheme) {
        void var1_1;
        this.scheme = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setUserInfo(String userInfo) {
        void var1_1;
        this.userInfo = var1_1;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setUserInfo(String username, String password) {
        void var2_2;
        void var1_1;
        return this.setUserInfo((String)var1_1 + ':' + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setHost(String host) {
        void var1_1;
        this.host = var1_1;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setPort(int port) {
        void var1_1;
        this.port = port < 0 ? -1 : var1_1;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setPath(String path) {
        void var1_1;
        this.path = var1_1;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public URIBuilder removeQuery() {
        this.queryParams = null;
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public URIBuilder setQuery(String query) {
        void var1_1;
        this.queryParams = this.parseQuery((String)var1_1, this.charset != null ? this.charset : Consts.UTF_8);
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setParameters(List<NameValuePair> nvps) {
        void var1_1;
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        this.queryParams.addAll((Collection<NameValuePair>)var1_1);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder addParameters(List<NameValuePair> nvps) {
        void var1_1;
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        this.queryParams.addAll((Collection<NameValuePair>)var1_1);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder setParameters(NameValuePair ... nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        NameValuePair[] arr$ = nvps;
        int len$ = nvps.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair nvp = arr$[i$];
            this.queryParams.add(nvp);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder addParameter(String param, String value) {
        void var2_2;
        void var1_1;
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        this.queryParams.add((NameValuePair)new BasicNameValuePair((String)var1_1, (String)var2_2));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setParameter(String param, String value) {
        void var2_2;
        void var1_1;
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (!this.queryParams.isEmpty()) {
            Iterator<NameValuePair> it = this.queryParams.iterator();
            while (it.hasNext()) {
                NameValuePair nameValuePair = it.next();
                if (!nameValuePair.getName().equals(param)) continue;
                it.remove();
            }
        }
        this.queryParams.add((NameValuePair)new BasicNameValuePair((String)var1_1, (String)var2_2));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public URIBuilder clearParameters() {
        this.queryParams = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setCustomQuery(String query) {
        void var1_1;
        this.query = var1_1;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.queryParams = null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public URIBuilder setFragment(String fragment) {
        void var1_1;
        this.fragment = var1_1;
        this.encodedFragment = null;
        return this;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public List<NameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<NameValuePair>(this.queryParams);
        }
        return new ArrayList<NameValuePair>();
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.buildString();
    }

    /*
     * WARNING - void declaration
     */
    private static String normalizePath(String path) {
        String string;
        int n;
        String s = path;
        if (s == null) {
            return null;
        }
        for (n = 0; n < s.length() && s.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            void var1_1;
            s = s.substring((int)(var1_1 - true));
        }
        return string;
    }
}

