/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;

@Immutable
public final class DateUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String[] DEFAULT_PATTERNS;
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    public static final TimeZone GMT;

    public static Date parseDate(String dateValue) {
        return DateUtils.parseDate(dateValue, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Date parseDate(String dateValue, String[] dateFormats) {
        void var1_1;
        return DateUtils.parseDate(dateValue, (String[])var1_1, null);
    }

    public static Date parseDate(String dateValue, String[] dateFormats, Date startDate) {
        Args.notNull((Object)dateValue, (String)"Date value");
        String[] localDateFormats = dateFormats != null ? dateFormats : DEFAULT_PATTERNS;
        Date localStartDate = startDate != null ? startDate : DEFAULT_TWO_DIGIT_YEAR_START;
        String v = dateValue;
        if (v.length() > 1 && v.startsWith("'") && v.endsWith("'")) {
            v = v.substring(1, v.length() - 1);
        }
        String[] arr$ = localDateFormats;
        int len$ = localDateFormats.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String string = arr$[i$];
            SimpleDateFormat dateParser = DateFormatHolder.formatFor(string);
            dateParser.set2DigitYearStart(localStartDate);
            ParsePosition pos = new ParsePosition(0);
            Date result = dateParser.parse(v, pos);
            if (pos.getIndex() == 0) continue;
            return result;
        }
        return null;
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String pattern) {
        Date date2;
        SimpleDateFormat simpleDateFormat;
        Args.notNull((Object)date, (String)"Date");
        Args.notNull((Object)pattern, (String)"Pattern");
        simpleDateFormat = DateFormatHolder.formatFor((String)((Object)simpleDateFormat));
        return simpleDateFormat.format(date2);
    }

    public static void clearThreadLocal() {
        DateFormatHolder.clearThreadLocal();
    }

    private DateUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        DEFAULT_PATTERNS = new String[]{PATTERN_RFC1123, PATTERN_RFC1036, PATTERN_ASCTIME};
        GMT = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = var0.getTime();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected final SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
            }
        };

        DateFormatHolder() {
        }

        /*
         * WARNING - void declaration
         */
        public static SimpleDateFormat formatFor(String pattern) {
            void var2_2;
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> softReference = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = softReference.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                String string;
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                softReference.put(string, format);
            }
            return var2_2;
        }

        public static void clearThreadLocal() {
            THREADLOCAL_FORMATS.remove();
        }
    }
}

