/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.entity.DeflateInputStream;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputStream create(InputStream instream) throws IOException {
            void var1_1;
            return new GZIPInputStream((InputStream)var1_1);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputStream create(InputStream instream) throws IOException {
            void var1_1;
            return new DeflateInputStream((InputStream)var1_1);
        }
    };
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    /*
     * WARNING - void declaration
     */
    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        void var2_2;
        void var1_1;
        this.decoderRegistry = decoderRegistry != null ? var1_1 : RegistryBuilder.create().register("gzip", (Object)GZIP).register("x-gzip", (Object)GZIP).register("deflate", (Object)DEFLATE).build();
        this.ignoreUnknown = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this((Lookup<InputStreamFactory>)var1_1, true);
        void var1_1;
    }

    public ResponseContentEncoding() {
        this(null);
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] ceheader;
        HttpEntity entity = response.getEntity();
        context = HttpClientContext.adapt(context);
        if ((context = context.getRequestConfig()).isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] arr$ = ceheader = ceheader.getElements();
            int len$ = ceheader.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                HeaderElement codec = arr$[i$];
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = (InputStreamFactory)this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity((HttpEntity)new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

