/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.client.AuthCache;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Deprecated
@Immutable
public class ResponseAuthCache
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - void declaration
     */
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull((Object)response, (String)"HTTP request");
        Args.notNull((Object)context, (String)"HTTP context");
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        AuthState targetState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (target != null && targetState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Target auth state: " + (Object)((Object)targetState.getState())));
            }
            if (this.isCachable(targetState)) {
                SchemeRegistry schemeRegistry = (SchemeRegistry)context.getAttribute("http.scheme-registry");
                if (target.getPort() < 0) {
                    Scheme scheme = schemeRegistry.getScheme(target);
                    target = new HttpHost(target.getHostName(), scheme.resolvePort(target.getPort()), target.getSchemeName());
                }
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    context.setAttribute("http.auth.auth-cache", (Object)authCache);
                }
                switch (targetState.getState()) {
                    case CHALLENGED: {
                        this.cache(authCache, target, targetState.getAuthScheme());
                        break;
                    }
                    case FAILURE: {
                        void var3_3;
                        this.uncache(authCache, (HttpHost)var3_3, targetState.getAuthScheme());
                    }
                }
            }
        }
        HttpHost proxy = (HttpHost)context.getAttribute("http.proxy_host");
        AuthState proxyState = (AuthState)context.getAttribute("http.auth.proxy-scope");
        if (proxy != null && proxyState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Proxy auth state: " + (Object)((Object)proxyState.getState())));
            }
            if (this.isCachable(proxyState)) {
                if (authCache == null) {
                    void var2_2;
                    authCache = new BasicAuthCache();
                    var2_2.setAttribute("http.auth.auth-cache", (Object)authCache);
                }
                switch (proxyState.getState()) {
                    case CHALLENGED: {
                        this.cache(authCache, proxy, proxyState.getAuthScheme());
                        return;
                    }
                    case FAILURE: {
                        void var1_1;
                        this.uncache((AuthCache)var1_1, proxy, proxyState.getAuthScheme());
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCachable(AuthState authState) {
        void var1_1;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("Basic") || var1_1.equalsIgnoreCase("Digest");
    }

    /*
     * WARNING - void declaration
     */
    private void cache(AuthCache authCache, HttpHost host, AuthScheme authScheme) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + host));
        }
        var1_1.put((HttpHost)var2_2, (AuthScheme)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void uncache(AuthCache authCache, HttpHost host, AuthScheme authScheme) {
        void var2_2;
        void var1_1;
        if (this.log.isDebugEnabled()) {
            void var3_3;
            this.log.debug((Object)("Removing from cache '" + var3_3.getSchemeName() + "' auth scheme for " + host));
        }
        var1_1.remove((HttpHost)var2_2);
    }
}

