/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    /*
     * WARNING - void declaration
     */
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        void var2_2;
        Args.notNull((Object)request, (String)"HTTP request");
        String string = request.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        RouteInfo route = (context = HttpClientContext.adapt(context)).getHttpRoute();
        if (route == null) {
            this.log.debug((Object)"Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !var2_2.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            void var1_1;
            var1_1.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

