/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.net.URI;
import java.util.List;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthState;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

@NotThreadSafe
public class HttpClientContext
extends HttpCoreContext {
    public static final String HTTP_ROUTE = "http.route";
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    public static final String COOKIESPEC_REGISTRY = "http.cookiespec-registry";
    public static final String COOKIE_SPEC = "http.cookie-spec";
    public static final String COOKIE_ORIGIN = "http.cookie-origin";
    public static final String COOKIE_STORE = "http.cookie-store";
    public static final String CREDS_PROVIDER = "http.auth.credentials-provider";
    public static final String AUTH_CACHE = "http.auth.auth-cache";
    public static final String TARGET_AUTH_STATE = "http.auth.target-scope";
    public static final String PROXY_AUTH_STATE = "http.auth.proxy-scope";
    public static final String USER_TOKEN = "http.user-token";
    public static final String AUTHSCHEME_REGISTRY = "http.authscheme-registry";
    public static final String REQUEST_CONFIG = "http.request-config";

    public static HttpClientContext adapt(HttpContext context) {
        HttpContext httpContext;
        if (context instanceof HttpClientContext) {
            return (HttpClientContext)context;
        }
        return new HttpClientContext(httpContext);
    }

    public static HttpClientContext create() {
        return new HttpClientContext((HttpContext)new BasicHttpContext());
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientContext(HttpContext context) {
        super((HttpContext)var1_1);
        void var1_1;
    }

    public HttpClientContext() {
    }

    public RouteInfo getHttpRoute() {
        return (RouteInfo)this.getAttribute(HTTP_ROUTE, HttpRoute.class);
    }

    public List<URI> getRedirectLocations() {
        return (List)this.getAttribute(REDIRECT_LOCATIONS, List.class);
    }

    public CookieStore getCookieStore() {
        return (CookieStore)this.getAttribute(COOKIE_STORE, CookieStore.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setCookieStore(CookieStore cookieStore) {
        void var1_1;
        this.setAttribute(COOKIE_STORE, var1_1);
    }

    public CookieSpec getCookieSpec() {
        return (CookieSpec)this.getAttribute(COOKIE_SPEC, CookieSpec.class);
    }

    public CookieOrigin getCookieOrigin() {
        return (CookieOrigin)this.getAttribute(COOKIE_ORIGIN, CookieOrigin.class);
    }

    /*
     * WARNING - void declaration
     */
    private <T> Lookup<T> getLookup(String name, Class<T> clazz) {
        void var1_1;
        return (Lookup)this.getAttribute((String)var1_1, Lookup.class);
    }

    public Lookup<CookieSpecProvider> getCookieSpecRegistry() {
        return this.getLookup(COOKIESPEC_REGISTRY, CookieSpecProvider.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setCookieSpecRegistry(Lookup<CookieSpecProvider> lookup) {
        void var1_1;
        this.setAttribute(COOKIESPEC_REGISTRY, var1_1);
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        return this.getLookup(AUTHSCHEME_REGISTRY, AuthSchemeProvider.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthSchemeRegistry(Lookup<AuthSchemeProvider> lookup) {
        void var1_1;
        this.setAttribute(AUTHSCHEME_REGISTRY, var1_1);
    }

    public CredentialsProvider getCredentialsProvider() {
        return (CredentialsProvider)this.getAttribute(CREDS_PROVIDER, CredentialsProvider.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        void var1_1;
        this.setAttribute(CREDS_PROVIDER, var1_1);
    }

    public AuthCache getAuthCache() {
        return (AuthCache)this.getAttribute(AUTH_CACHE, AuthCache.class);
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthCache(AuthCache authCache) {
        void var1_1;
        this.setAttribute(AUTH_CACHE, var1_1);
    }

    public AuthState getTargetAuthState() {
        return (AuthState)this.getAttribute(TARGET_AUTH_STATE, AuthState.class);
    }

    public AuthState getProxyAuthState() {
        return (AuthState)this.getAttribute(PROXY_AUTH_STATE, AuthState.class);
    }

    /*
     * WARNING - void declaration
     */
    public <T> T getUserToken(Class<T> clazz) {
        void var1_1;
        return (T)this.getAttribute(USER_TOKEN, (Class)var1_1);
    }

    public Object getUserToken() {
        return this.getAttribute(USER_TOKEN);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserToken(Object obj) {
        void var1_1;
        this.setAttribute(USER_TOKEN, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public RequestConfig getRequestConfig() {
        RequestConfig config = (RequestConfig)this.getAttribute(REQUEST_CONFIG, RequestConfig.class);
        if (config != null) {
            void var1_1;
            return var1_1;
        }
        return RequestConfig.DEFAULT;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestConfig(RequestConfig config) {
        void var1_1;
        this.setAttribute(REQUEST_CONFIG, var1_1);
    }
}

