/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderGroup;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;

@NotThreadSafe
public class RequestBuilder {
    private String method;
    private Charset charset;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headergroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    /*
     * WARNING - void declaration
     */
    RequestBuilder(String method) {
        void var1_1;
        this.charset = Consts.UTF_8;
        this.method = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RequestBuilder(String method, URI uri) {
        void var2_2;
        void var1_1;
        this.method = var1_1;
        this.uri = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    RequestBuilder(String method, String uri) {
        void var2_2;
        void var1_1;
        this.method = var1_1;
        this.uri = uri != null ? URI.create((String)var2_2) : null;
    }

    RequestBuilder() {
        this(null);
    }

    public static RequestBuilder create(String method) {
        String string;
        Args.notBlank((CharSequence)method, (String)"HTTP method");
        return new RequestBuilder(string);
    }

    public static RequestBuilder get() {
        return new RequestBuilder("GET");
    }

    public static RequestBuilder get(URI uri) {
        URI uRI;
        return new RequestBuilder("GET", uRI);
    }

    public static RequestBuilder get(String uri) {
        String string;
        return new RequestBuilder("GET", string);
    }

    public static RequestBuilder head() {
        return new RequestBuilder("HEAD");
    }

    public static RequestBuilder head(URI uri) {
        URI uRI;
        return new RequestBuilder("HEAD", uRI);
    }

    public static RequestBuilder head(String uri) {
        String string;
        return new RequestBuilder("HEAD", string);
    }

    public static RequestBuilder patch() {
        return new RequestBuilder("PATCH");
    }

    public static RequestBuilder patch(URI uri) {
        URI uRI;
        return new RequestBuilder("PATCH", uRI);
    }

    public static RequestBuilder patch(String uri) {
        String string;
        return new RequestBuilder("PATCH", string);
    }

    public static RequestBuilder post() {
        return new RequestBuilder("POST");
    }

    public static RequestBuilder post(URI uri) {
        URI uRI;
        return new RequestBuilder("POST", uRI);
    }

    public static RequestBuilder post(String uri) {
        String string;
        return new RequestBuilder("POST", string);
    }

    public static RequestBuilder put() {
        return new RequestBuilder("PUT");
    }

    public static RequestBuilder put(URI uri) {
        URI uRI;
        return new RequestBuilder("PUT", uRI);
    }

    public static RequestBuilder put(String uri) {
        String string;
        return new RequestBuilder("PUT", string);
    }

    public static RequestBuilder delete() {
        return new RequestBuilder("DELETE");
    }

    public static RequestBuilder delete(URI uri) {
        URI uRI;
        return new RequestBuilder("DELETE", uRI);
    }

    public static RequestBuilder delete(String uri) {
        String string;
        return new RequestBuilder("DELETE", string);
    }

    public static RequestBuilder trace() {
        return new RequestBuilder("TRACE");
    }

    public static RequestBuilder trace(URI uri) {
        URI uRI;
        return new RequestBuilder("TRACE", uRI);
    }

    public static RequestBuilder trace(String uri) {
        String string;
        return new RequestBuilder("TRACE", string);
    }

    public static RequestBuilder options() {
        return new RequestBuilder("OPTIONS");
    }

    public static RequestBuilder options(URI uri) {
        URI uRI;
        return new RequestBuilder("OPTIONS", uRI);
    }

    public static RequestBuilder options(String uri) {
        String string;
        return new RequestBuilder("OPTIONS", string);
    }

    public static RequestBuilder copy(HttpRequest request) {
        HttpRequest httpRequest;
        Args.notNull((Object)request, (String)"HTTP request");
        return new RequestBuilder().doCopy(httpRequest);
    }

    /*
     * WARNING - void declaration
     */
    private RequestBuilder doCopy(HttpRequest request) {
        void var1_1;
        if (request == null) {
            return this;
        }
        this.method = request.getRequestLine().getMethod();
        this.version = request.getRequestLine().getProtocolVersion();
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.clear();
        this.headergroup.setHeaders(request.getAllHeaders());
        this.parameters = null;
        this.entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            void var2_2;
            void var3_3;
            HttpEntity originalEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            ContentType contentType = ContentType.get((HttpEntity)originalEntity);
            if (contentType != null && var3_3.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                try {
                    List<NameValuePair> formParams = URLEncodedUtils.parse(originalEntity);
                    if (!formParams.isEmpty()) {
                        this.parameters = var2_2;
                    }
                }
                catch (IOException iOException) {}
            } else {
                this.entity = var2_2;
            }
        }
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
        this.config = request instanceof Configurable ? ((Configurable)var1_1).getConfig() : null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setCharset(Charset charset) {
        void var1_1;
        this.charset = var1_1;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setVersion(ProtocolVersion version) {
        void var1_1;
        this.version = var1_1;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setUri(URI uri) {
        void var1_1;
        this.uri = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setUri(String uri) {
        void var1_1;
        this.uri = uri != null ? URI.create((String)var1_1) : null;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Header getFirstHeader(String name) {
        if (this.headergroup != null) {
            void var1_1;
            return this.headergroup.getFirstHeader((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Header getLastHeader(String name) {
        if (this.headergroup != null) {
            void var1_1;
            return this.headergroup.getLastHeader((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Header[] getHeaders(String name) {
        if (this.headergroup != null) {
            void var1_1;
            return this.headergroup.getHeaders((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder addHeader(Header header) {
        void var1_1;
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader((Header)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder addHeader(String name, String value) {
        void var2_2;
        void var1_1;
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.addHeader((Header)new BasicHeader((String)var1_1, (String)var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder removeHeader(Header header) {
        void var1_1;
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.removeHeader((Header)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder removeHeaders(String name) {
        if (name == null || this.headergroup == null) {
            return this;
        }
        HeaderIterator i = this.headergroup.iterator();
        while (i.hasNext()) {
            void var3_3;
            Header header = i.nextHeader();
            if (!name.equalsIgnoreCase(var3_3.getName())) continue;
            i.remove();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setHeader(Header header) {
        void var1_1;
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.updateHeader((Header)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setHeader(String name, String value) {
        void var2_2;
        void var1_1;
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.updateHeader((Header)new BasicHeader((String)var1_1, (String)var2_2));
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setEntity(HttpEntity entity) {
        void var1_1;
        this.entity = var1_1;
        return this;
    }

    public List<NameValuePair> getParameters() {
        if (this.parameters != null) {
            return new ArrayList<NameValuePair>(this.parameters);
        }
        return new ArrayList<NameValuePair>();
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder addParameter(NameValuePair nvp) {
        void var1_1;
        Args.notNull((Object)nvp, (String)"Name value pair");
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add((NameValuePair)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder addParameter(String name, String value) {
        void var2_2;
        void var1_1;
        return this.addParameter((NameValuePair)new BasicNameValuePair((String)var1_1, (String)var2_2));
    }

    public RequestBuilder addParameters(NameValuePair ... nvps) {
        NameValuePair[] arr$ = nvps;
        int len$ = nvps.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NameValuePair nvp = arr$[i$];
            this.addParameter(nvp);
        }
        return this;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public RequestBuilder setConfig(RequestConfig config) {
        void var1_1;
        this.config = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpUriRequest build() {
        void var1_2;
        void var2_1;
        InternalRequest result;
        URI uriNotNull = this.uri != null ? this.uri : URI.create("/");
        Object entityCopy = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityCopy == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                entityCopy = new UrlEncodedFormEntity(this.parameters, this.charset != null ? this.charset : HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uriNotNull = new URIBuilder(uriNotNull).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (entityCopy == null) {
            result = new InternalRequest(this.method);
        } else {
            void var3_3;
            InternalEntityEclosingRequest request = new InternalEntityEclosingRequest(this.method);
            request.setEntity((HttpEntity)result);
            result = var3_3;
        }
        result.setProtocolVersion(this.version);
        result.setURI((URI)var2_1);
        if (this.headergroup != null) {
            result.setHeaders(this.headergroup.getAllHeaders());
        }
        result.setConfig(this.config);
        return var1_2;
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        /*
         * WARNING - void declaration
         */
        InternalEntityEclosingRequest(String method) {
            void var1_1;
            this.method = var1_1;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        /*
         * WARNING - void declaration
         */
        InternalRequest(String method) {
            void var1_1;
            this.method = var1_1;
        }

        @Override
        public String getMethod() {
            return this.method;
        }
    }
}

