/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

@NotThreadSafe
public class HttpRequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest {
    private final HttpRequest original;
    private final HttpHost target;
    private final String method;
    private RequestLine requestLine;
    private ProtocolVersion version;
    private URI uri;

    /*
     * WARNING - void declaration
     */
    private HttpRequestWrapper(HttpRequest request, HttpHost target) {
        void var1_1;
        void var2_2;
        this.original = (HttpRequest)Args.notNull((Object)request, (String)"HTTP request");
        this.target = var2_2;
        this.version = this.original.getRequestLine().getProtocolVersion();
        this.method = this.original.getRequestLine().getMethod();
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : null;
        this.setHeaders(var1_1.getAllHeaders());
    }

    public ProtocolVersion getProtocolVersion() {
        if (this.version != null) {
            return this.version;
        }
        return this.original.getProtocolVersion();
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocolVersion(ProtocolVersion version) {
        void var1_1;
        this.version = var1_1;
        this.requestLine = null;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public void setURI(URI uri) {
        void var1_1;
        this.uri = var1_1;
        this.requestLine = null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public RequestLine getRequestLine() {
        if (this.requestLine == null) {
            void var1_1;
            String requestUri = this.uri != null ? this.uri.toASCIIString() : this.original.getRequestLine().getUri();
            if (requestUri == null || requestUri.isEmpty()) {
                requestUri = "/";
            }
            this.requestLine = new BasicRequestLine(this.method, (String)var1_1, this.getProtocolVersion());
        }
        return this.requestLine;
    }

    public HttpRequest getOriginal() {
        return this.original;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public String toString() {
        return this.getRequestLine() + " " + this.headergroup;
    }

    public static HttpRequestWrapper wrap(HttpRequest request) {
        return HttpRequestWrapper.wrap(request, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HttpRequestWrapper wrap(HttpRequest request, HttpHost target) {
        void var1_1;
        HttpRequest httpRequest;
        Args.notNull((Object)request, (String)"HTTP request");
        if (request instanceof HttpEntityEnclosingRequest) {
            return new HttpEntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request, target);
        }
        return new HttpRequestWrapper(httpRequest, (HttpHost)var1_1);
    }

    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = this.original.getParams().copy();
        }
        return this.params;
    }

    static class HttpEntityEnclosingRequestWrapper
    extends HttpRequestWrapper
    implements HttpEntityEnclosingRequest {
        private HttpEntity entity;

        /*
         * WARNING - void declaration
         */
        HttpEntityEnclosingRequestWrapper(HttpEntityEnclosingRequest request, HttpHost target) {
            super((HttpRequest)request, (HttpHost)var2_2);
            void var1_1;
            void var2_2;
            this.entity = var1_1.getEntity();
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        /*
         * WARNING - void declaration
         */
        public void setEntity(HttpEntity entity) {
            void var1_1;
            this.entity = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean expectContinue() {
            void var1_1;
            Header expect = this.getFirstHeader("Expect");
            return expect != null && "100-continue".equalsIgnoreCase(var1_1.getValue());
        }
    }
}

