/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.methods;

import java.net.URI;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

@NotThreadSafe
public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements Configurable,
HttpUriRequest {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    /*
     * WARNING - void declaration
     */
    public void setProtocolVersion(ProtocolVersion version) {
        void var1_1;
        this.version = var1_1;
    }

    public ProtocolVersion getProtocolVersion() {
        if (this.version != null) {
            return this.version;
        }
        return HttpProtocolParams.getVersion((HttpParams)this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public RequestLine getRequestLine() {
        void var2_2;
        void var1_1;
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            void var3_3;
            uritext = var3_3.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine((String)var1_1, uritext, (ProtocolVersion)var2_2);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(RequestConfig config) {
        void var1_1;
        this.config = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setURI(URI uri) {
        void var1_1;
        this.uri = var1_1;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

