/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.SerializableEntity;
import org.apache.http.entity.StringEntity;

@NotThreadSafe
public class EntityBuilder {
    private String text;
    private byte[] binary;
    private InputStream stream;
    private List<NameValuePair> parameters;
    private Serializable serializable;
    private File file;
    private ContentType contentType;
    private String contentEncoding;
    private boolean chunked;
    private boolean gzipCompress;

    EntityBuilder() {
    }

    public static EntityBuilder create() {
        return new EntityBuilder();
    }

    private void clearContent() {
        this.text = null;
        this.binary = null;
        this.stream = null;
        this.parameters = null;
        this.serializable = null;
        this.file = null;
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setText(String text) {
        void var1_1;
        this.clearContent();
        this.text = var1_1;
        return this;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setBinary(byte[] binary) {
        void var1_1;
        this.clearContent();
        this.binary = var1_1;
        return this;
    }

    public InputStream getStream() {
        return this.stream;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setStream(InputStream stream) {
        void var1_1;
        this.clearContent();
        this.stream = var1_1;
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setParameters(List<NameValuePair> parameters) {
        void var1_1;
        this.clearContent();
        this.parameters = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setParameters(NameValuePair ... parameters) {
        void var1_1;
        return this.setParameters(Arrays.asList(var1_1));
    }

    public Serializable getSerializable() {
        return this.serializable;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setSerializable(Serializable serializable) {
        void var1_1;
        this.clearContent();
        this.serializable = var1_1;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setFile(File file) {
        void var1_1;
        this.clearContent();
        this.file = var1_1;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setContentType(ContentType contentType) {
        void var1_1;
        this.contentType = var1_1;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    /*
     * WARNING - void declaration
     */
    public EntityBuilder setContentEncoding(String contentEncoding) {
        void var1_1;
        this.contentEncoding = var1_1;
        return this;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public EntityBuilder chunked() {
        this.chunked = true;
        return this;
    }

    public boolean isGzipCompress() {
        return this.gzipCompress;
    }

    public EntityBuilder gzipCompress() {
        this.gzipCompress = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private ContentType getContentOrDefault(ContentType def) {
        void var1_1;
        if (this.contentType != null) {
            return this.contentType;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpEntity build() {
        void var1_1;
        Object e;
        if (this.text != null) {
            e = new StringEntity(this.text, this.getContentOrDefault(ContentType.DEFAULT_TEXT));
        } else if (this.binary != null) {
            e = new ByteArrayEntity(this.binary, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.stream != null) {
            e = new InputStreamEntity(this.stream, -1L, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.parameters != null) {
            e = new UrlEncodedFormEntity(this.parameters, this.contentType != null ? this.contentType.getCharset() : null);
        } else if (this.serializable != null) {
            e = new SerializableEntity(this.serializable);
            e.setContentType(ContentType.DEFAULT_BINARY.toString());
        } else {
            e = this.file != null ? new FileEntity(this.file, this.getContentOrDefault(ContentType.DEFAULT_BINARY)) : new BasicHttpEntity();
        }
        if (e.getContentType() != null && this.contentType != null) {
            e.setContentType(this.contentType.toString());
        }
        e.setContentEncoding(this.contentEncoding);
        e.setChunked(this.chunked);
        if (this.gzipCompress) {
            return new GzipCompressingEntity((HttpEntity)e);
        }
        return var1_1;
    }
}

