/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.InputStreamFactory;
import org.apache.http.client.entity.LazyDecompressingInputStream;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.util.Args;

public class DecompressingEntity
extends HttpEntityWrapper {
    private static final int BUFFER_SIZE = 2048;
    private final InputStreamFactory inputStreamFactory;
    private InputStream content;

    /*
     * WARNING - void declaration
     */
    public DecompressingEntity(HttpEntity wrapped, InputStreamFactory inputStreamFactory) {
        super((HttpEntity)var1_1);
        void var2_2;
        void var1_1;
        this.inputStreamFactory = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream getDecompressingStream() throws IOException {
        void var1_1;
        InputStream in = this.wrappedEntity.getContent();
        return new LazyDecompressingInputStream((InputStream)var1_1, this.inputStreamFactory);
    }

    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        InputStream instream = this.getContent();
        try {
            int l;
            byte[] buffer = new byte[2048];
            while ((l = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, l);
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            var2_3.close();
            throw throwable;
        }
        instream.close();
    }

    public Header getContentEncoding() {
        return null;
    }

    public long getContentLength() {
        return -1L;
    }
}

