/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.config;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;

@Immutable
public class RequestConfig
implements Cloneable {
    public static final RequestConfig DEFAULT = new Builder().build();
    private final boolean expectContinueEnabled;
    private final HttpHost proxy;
    private final InetAddress localAddress;
    private final boolean staleConnectionCheckEnabled;
    private final String cookieSpec;
    private final boolean redirectsEnabled;
    private final boolean relativeRedirectsAllowed;
    private final boolean circularRedirectsAllowed;
    private final int maxRedirects;
    private final boolean authenticationEnabled;
    private final Collection<String> targetPreferredAuthSchemes;
    private final Collection<String> proxyPreferredAuthSchemes;
    private final int connectionRequestTimeout;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean contentCompressionEnabled;

    protected RequestConfig() {
        this(false, null, null, false, null, false, false, false, 0, false, null, null, 0, 0, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    RequestConfig(boolean expectContinueEnabled, HttpHost proxy, InetAddress localAddress, boolean staleConnectionCheckEnabled, String cookieSpec, boolean redirectsEnabled, boolean relativeRedirectsAllowed, boolean circularRedirectsAllowed, int maxRedirects, boolean authenticationEnabled, Collection<String> targetPreferredAuthSchemes, Collection<String> proxyPreferredAuthSchemes, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean contentCompressionEnabled) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.expectContinueEnabled = var1_1;
        this.proxy = var2_2;
        this.localAddress = var3_3;
        this.staleConnectionCheckEnabled = staleConnectionCheckEnabled;
        this.cookieSpec = cookieSpec;
        this.redirectsEnabled = redirectsEnabled;
        this.relativeRedirectsAllowed = relativeRedirectsAllowed;
        this.circularRedirectsAllowed = circularRedirectsAllowed;
        this.maxRedirects = maxRedirects;
        this.authenticationEnabled = authenticationEnabled;
        this.targetPreferredAuthSchemes = targetPreferredAuthSchemes;
        this.proxyPreferredAuthSchemes = proxyPreferredAuthSchemes;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.contentCompressionEnabled = contentCompressionEnabled;
    }

    public boolean isExpectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    @Deprecated
    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean isRelativeRedirectsAllowed() {
        return this.relativeRedirectsAllowed;
    }

    public boolean isCircularRedirectsAllowed() {
        return this.circularRedirectsAllowed;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Collection<String> getTargetPreferredAuthSchemes() {
        return this.targetPreferredAuthSchemes;
    }

    public Collection<String> getProxyPreferredAuthSchemes() {
        return this.proxyPreferredAuthSchemes;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Deprecated
    public boolean isDecompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    public boolean isContentCompressionEnabled() {
        return this.contentCompressionEnabled;
    }

    protected RequestConfig clone() throws CloneNotSupportedException {
        return (RequestConfig)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("expectContinueEnabled=").append(this.expectContinueEnabled);
        builder.append(", proxy=").append(this.proxy);
        builder.append(", localAddress=").append(this.localAddress);
        builder.append(", cookieSpec=").append(this.cookieSpec);
        builder.append(", redirectsEnabled=").append(this.redirectsEnabled);
        builder.append(", relativeRedirectsAllowed=").append(this.relativeRedirectsAllowed);
        builder.append(", maxRedirects=").append(this.maxRedirects);
        builder.append(", circularRedirectsAllowed=").append(this.circularRedirectsAllowed);
        builder.append(", authenticationEnabled=").append(this.authenticationEnabled);
        builder.append(", targetPreferredAuthSchemes=").append(this.targetPreferredAuthSchemes);
        builder.append(", proxyPreferredAuthSchemes=").append(this.proxyPreferredAuthSchemes);
        builder.append(", connectionRequestTimeout=").append(this.connectionRequestTimeout);
        builder.append(", connectTimeout=").append(this.connectTimeout);
        builder.append(", socketTimeout=").append(this.socketTimeout);
        builder.append(", contentCompressionEnabled=").append(this.contentCompressionEnabled);
        builder.append("]");
        return var1_1.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(RequestConfig config) {
        RequestConfig requestConfig;
        return new Builder().setExpectContinueEnabled(config.isExpectContinueEnabled()).setProxy(config.getProxy()).setLocalAddress(config.getLocalAddress()).setStaleConnectionCheckEnabled(config.isStaleConnectionCheckEnabled()).setCookieSpec(config.getCookieSpec()).setRedirectsEnabled(config.isRedirectsEnabled()).setRelativeRedirectsAllowed(config.isRelativeRedirectsAllowed()).setCircularRedirectsAllowed(config.isCircularRedirectsAllowed()).setMaxRedirects(config.getMaxRedirects()).setAuthenticationEnabled(config.isAuthenticationEnabled()).setTargetPreferredAuthSchemes(config.getTargetPreferredAuthSchemes()).setProxyPreferredAuthSchemes(config.getProxyPreferredAuthSchemes()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).setConnectTimeout(config.getConnectTimeout()).setSocketTimeout(config.getSocketTimeout()).setDecompressionEnabled(config.isDecompressionEnabled()).setContentCompressionEnabled(requestConfig.isContentCompressionEnabled());
    }

    public static class Builder {
        private boolean expectContinueEnabled;
        private HttpHost proxy;
        private InetAddress localAddress;
        private boolean staleConnectionCheckEnabled = false;
        private String cookieSpec;
        private boolean redirectsEnabled = true;
        private boolean relativeRedirectsAllowed = true;
        private boolean circularRedirectsAllowed;
        private int maxRedirects = 50;
        private boolean authenticationEnabled = true;
        private Collection<String> targetPreferredAuthSchemes;
        private Collection<String> proxyPreferredAuthSchemes;
        private int connectionRequestTimeout = -1;
        private int connectTimeout = -1;
        private int socketTimeout = -1;
        private boolean contentCompressionEnabled = true;

        Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setExpectContinueEnabled(boolean expectContinueEnabled) {
            void var1_1;
            this.expectContinueEnabled = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProxy(HttpHost proxy) {
            void var1_1;
            this.proxy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setLocalAddress(InetAddress localAddress) {
            void var1_1;
            this.localAddress = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setStaleConnectionCheckEnabled(boolean staleConnectionCheckEnabled) {
            void var1_1;
            this.staleConnectionCheckEnabled = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCookieSpec(String cookieSpec) {
            void var1_1;
            this.cookieSpec = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRedirectsEnabled(boolean redirectsEnabled) {
            void var1_1;
            this.redirectsEnabled = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRelativeRedirectsAllowed(boolean relativeRedirectsAllowed) {
            void var1_1;
            this.relativeRedirectsAllowed = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
            void var1_1;
            this.circularRedirectsAllowed = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMaxRedirects(int maxRedirects) {
            void var1_1;
            this.maxRedirects = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAuthenticationEnabled(boolean authenticationEnabled) {
            void var1_1;
            this.authenticationEnabled = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTargetPreferredAuthSchemes(Collection<String> targetPreferredAuthSchemes) {
            void var1_1;
            this.targetPreferredAuthSchemes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProxyPreferredAuthSchemes(Collection<String> proxyPreferredAuthSchemes) {
            void var1_1;
            this.proxyPreferredAuthSchemes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            void var1_1;
            this.connectionRequestTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConnectTimeout(int connectTimeout) {
            void var1_1;
            this.connectTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSocketTimeout(int socketTimeout) {
            void var1_1;
            this.socketTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setDecompressionEnabled(boolean decompressionEnabled) {
            void var1_1;
            this.contentCompressionEnabled = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setContentCompressionEnabled(boolean contentCompressionEnabled) {
            void var1_1;
            this.contentCompressionEnabled = var1_1;
            return this;
        }

        public RequestConfig build() {
            return new RequestConfig(this.expectContinueEnabled, this.proxy, this.localAddress, this.staleConnectionCheckEnabled, this.cookieSpec, this.redirectsEnabled, this.relativeRedirectsAllowed, this.circularRedirectsAllowed, this.maxRedirects, this.authenticationEnabled, this.targetPreferredAuthSchemes, this.proxyPreferredAuthSchemes, this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout, this.contentCompressionEnabled);
        }
    }
}

