/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Immutable
public class NTUserPrincipal
implements Serializable,
Principal {
    private static final long serialVersionUID = -6870169797924406894L;
    private final String username;
    private final String domain;
    private final String ntname;

    /*
     * WARNING - void declaration
     */
    public NTUserPrincipal(String domain, String username) {
        void var2_2;
        Args.notNull((Object)username, (String)"User name");
        this.username = var2_2;
        this.domain = domain != null ? domain.toUpperCase(Locale.ROOT) : null;
        if (this.domain != null && !this.domain.isEmpty()) {
            void var1_1;
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.domain);
            buffer.append('\\');
            buffer.append(this.username);
            this.ntname = var1_1.toString();
            return;
        }
        this.ntname = this.username;
    }

    @Override
    public String getName() {
        return this.ntname;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public int hashCode() {
        int n = LangUtils.hashCode((int)17, (Object)this.username);
        n = LangUtils.hashCode((int)n, (Object)this.domain);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NTUserPrincipal) {
            void var1_1;
            NTUserPrincipal that = (NTUserPrincipal)o;
            if (LangUtils.equals((Object)this.username, (Object)that.username) && LangUtils.equals((Object)this.domain, (Object)var1_1.domain)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ntname;
    }
}

