/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTUserPrincipal;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Immutable
public class NTCredentials
implements Serializable,
Credentials {
    private static final long serialVersionUID = -7385699315228907265L;
    private final NTUserPrincipal principal;
    private final String password;
    private final String workstation;

    /*
     * WARNING - void declaration
     */
    public NTCredentials(String usernamePassword) {
        void var1_2;
        void var2_4;
        String username;
        Args.notNull((Object)usernamePassword, (String)"Username:password string");
        int atColon = usernamePassword.indexOf(58);
        if (atColon >= 0) {
            void var3_3;
            username = usernamePassword.substring(0, atColon);
            this.password = usernamePassword.substring((int)(var3_3 + true));
        } else {
            username = usernamePassword;
            this.password = null;
        }
        int atSlash = username.indexOf(47);
        this.principal = atSlash >= 0 ? new NTUserPrincipal(username.substring(0, atSlash).toUpperCase(Locale.ROOT), username.substring(atSlash + 1)) : new NTUserPrincipal(null, var2_4.substring((int)(var1_2 + true)));
        this.workstation = null;
    }

    /*
     * WARNING - void declaration
     */
    public NTCredentials(String userName, String password, String workstation, String domain) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)userName, (String)"User name");
        this.principal = new NTUserPrincipal(domain, (String)var1_1);
        this.password = var2_2;
        if (workstation != null) {
            void var3_3;
            this.workstation = var3_3.toUpperCase(Locale.ROOT);
            return;
        }
        this.workstation = null;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getUserName() {
        return this.principal.getUsername();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.principal.getDomain();
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public int hashCode() {
        int n = LangUtils.hashCode((int)17, (Object)this.principal);
        n = LangUtils.hashCode((int)n, (Object)this.workstation);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NTCredentials) {
            void var1_1;
            NTCredentials that = (NTCredentials)o;
            if (LangUtils.equals((Object)this.principal, (Object)that.principal) && LangUtils.equals((Object)this.workstation, (Object)var1_1.workstation)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[principal: ");
        buffer.append(this.principal);
        buffer.append("][workstation: ");
        buffer.append(this.workstation);
        buffer.append("]");
        return var1_1.toString();
    }
}

