/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.util.Queue;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.util.Args;

@NotThreadSafe
public class AuthState {
    private AuthProtocolState state = AuthProtocolState.UNCHALLENGED;
    private AuthScheme authScheme;
    private AuthScope authScope;
    private Credentials credentials;
    private Queue<AuthOption> authOptions;

    public void reset() {
        this.state = AuthProtocolState.UNCHALLENGED;
        this.authOptions = null;
        this.authScheme = null;
        this.authScope = null;
        this.credentials = null;
    }

    public AuthProtocolState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(AuthProtocolState state) {
        void var1_1;
        this.state = state != null ? var1_1 : AuthProtocolState.UNCHALLENGED;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    /*
     * WARNING - void declaration
     */
    public void update(AuthScheme authScheme, Credentials credentials) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)authScheme, (String)"Auth scheme");
        Args.notNull((Object)credentials, (String)"Credentials");
        this.authScheme = var1_1;
        this.credentials = var2_2;
        this.authOptions = null;
    }

    public Queue<AuthOption> getAuthOptions() {
        return this.authOptions;
    }

    public boolean hasAuthOptions() {
        return this.authOptions != null && !this.authOptions.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void update(Queue<AuthOption> authOptions) {
        void var1_1;
        Args.notEmpty(authOptions, (String)"Queue of auth options");
        this.authOptions = var1_1;
        this.authScheme = null;
        this.credentials = null;
    }

    @Deprecated
    public void invalidate() {
        this.reset();
    }

    @Deprecated
    public boolean isValid() {
        return this.authScheme != null;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAuthScheme(AuthScheme authScheme) {
        void var1_1;
        if (authScheme == null) {
            this.reset();
            return;
        }
        this.authScheme = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setCredentials(Credentials credentials) {
        void var1_1;
        this.credentials = var1_1;
    }

    @Deprecated
    public AuthScope getAuthScope() {
        return this.authScope;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setAuthScope(AuthScope authScope) {
        void var1_1;
        this.authScope = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("state:").append((Object)this.state).append(";");
        if (this.authScheme != null) {
            buffer.append("auth scheme:").append(this.authScheme.getSchemeName()).append(";");
        }
        if (this.credentials != null) {
            buffer.append("credentials present");
        }
        return var1_1.toString();
    }
}

