/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.auth;

import java.util.Locale;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@Immutable
public class AuthScope {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    public static final AuthScope ANY = new AuthScope(ANY_HOST, -1, ANY_REALM, ANY_SCHEME);
    private final String scheme;
    private final String realm;
    private final String host;
    private final int port;
    private final HttpHost origin;

    /*
     * WARNING - void declaration
     */
    public AuthScope(String host, int port, String realm, String schemeName) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.host = host == null ? ANY_HOST : var1_1.toLowerCase(Locale.ROOT);
        this.port = port < 0 ? -1 : var2_2;
        this.realm = realm == null ? ANY_REALM : var3_3;
        this.scheme = schemeName == null ? ANY_SCHEME : schemeName.toUpperCase(Locale.ROOT);
        this.origin = null;
    }

    /*
     * WARNING - void declaration
     */
    public AuthScope(HttpHost origin, String realm, String schemeName) {
        void var1_1;
        void var3_3;
        void var2_2;
        Args.notNull((Object)origin, (String)"Host");
        this.host = origin.getHostName().toLowerCase(Locale.ROOT);
        this.port = origin.getPort() < 0 ? -1 : origin.getPort();
        this.realm = realm == null ? ANY_REALM : var2_2;
        this.scheme = schemeName == null ? ANY_SCHEME : var3_3.toUpperCase(Locale.ROOT);
        this.origin = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AuthScope(HttpHost origin) {
        this((HttpHost)var1_1, ANY_REALM, ANY_SCHEME);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AuthScope(String host, int port, String realm) {
        this((String)var1_1, (int)var2_2, (String)var3_3, ANY_SCHEME);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AuthScope(String host, int port) {
        this((String)var1_1, (int)var2_2, ANY_REALM, ANY_SCHEME);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AuthScope(AuthScope authscope) {
        void var1_1;
        Args.notNull((Object)authscope, (String)"Scope");
        this.host = authscope.getHost();
        this.port = authscope.getPort();
        this.realm = authscope.getRealm();
        this.scheme = authscope.getScheme();
        this.origin = var1_1.getOrigin();
    }

    public HttpHost getOrigin() {
        return this.origin;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    /*
     * WARNING - void declaration
     */
    public int match(AuthScope that) {
        void var2_2;
        void var1_1;
        int factor = 0;
        if (LangUtils.equals((Object)this.scheme, (Object)that.scheme)) {
            ++factor;
        } else if (this.scheme != ANY_SCHEME && that.scheme != ANY_SCHEME) {
            return -1;
        }
        if (LangUtils.equals((Object)this.realm, (Object)that.realm)) {
            factor += 2;
        } else if (this.realm != ANY_REALM && that.realm != ANY_REALM) {
            return -1;
        }
        if (this.port == that.port) {
            factor += 4;
        } else if (this.port != -1 && that.port != -1) {
            return -1;
        }
        if (LangUtils.equals((Object)this.host, (Object)that.host)) {
            factor += 8;
        } else if (this.host != ANY_HOST && var1_1.host != ANY_HOST) {
            return -1;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthScope)) {
            return super.equals(o);
        }
        AuthScope that = (AuthScope)o;
        return LangUtils.equals((Object)this.host, (Object)that.host) && this.port == that.port && LangUtils.equals((Object)this.realm, (Object)that.realm) && LangUtils.equals((Object)this.scheme, (Object)var1_1.scheme);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        if (this.scheme != null) {
            buffer.append(this.scheme.toUpperCase(Locale.ROOT));
            buffer.append(' ');
        }
        if (this.realm != null) {
            buffer.append('\'');
            buffer.append(this.realm);
            buffer.append('\'');
        } else {
            buffer.append("<any realm>");
        }
        if (this.host != null) {
            buffer.append('@');
            buffer.append(this.host);
            if (this.port >= 0) {
                buffer.append(':');
                buffer.append(this.port);
            }
        }
        return var1_1.toString();
    }

    public int hashCode() {
        int n = LangUtils.hashCode((int)17, (Object)this.host);
        n = LangUtils.hashCode((int)n, (int)this.port);
        n = LangUtils.hashCode((int)n, (Object)this.realm);
        n = LangUtils.hashCode((int)n, (Object)this.scheme);
        return n;
    }
}

