/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.awt.InteropFocusSwitcher;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropPointerInput_skikoKt;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder_desktopKt;
import androidx.compose.ui.viewinterop.TypedInteropViewHolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B7\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060\nj\u0002`\u000b2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00060,j\u0002`-H\u0016J\u001c\u0010.\u001a\u00020\"2\n\u0010#\u001a\u00060\nj\u0002`\u000b2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\u00020\"2\n\u0010#\u001a\u00060\nj\u0002`\u000bH\u0016R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001a\u00a8\u00063"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropViewHolder;", "T", "Ljava/awt/Component;", "Landroidx/compose/ui/viewinterop/TypedInteropViewHolder;", "Lorg/jetbrains/skiko/ClipRectangle;", "factory", "Lkotlin/Function0;", "container", "Landroidx/compose/ui/viewinterop/InteropContainer;", "group", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "focusSwitcher", "Landroidx/compose/ui/awt/InteropFocusSwitcher;", "compositeKeyHash", "", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/viewinterop/InteropContainer;Ljava/awt/Container;Landroidx/compose/ui/awt/InteropFocusSwitcher;I)V", "clipBounds", "Landroidx/compose/ui/unit/IntRect;", "focusListener", "Ljava/awt/event/FocusListener;", "getFocusListener", "()Ljava/awt/event/FocusListener;", "height", "", "getHeight", "()F", "width", "getWidth", "x", "getX", "y", "getY", "changeInteropViewIndex", "", "root", "index", "dispatchToView", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "getDeepestComponentForEvent", "event", "Ljava/awt/event/MouseEvent;", "getInteropView", "", "Landroidx/compose/ui/viewinterop/InteropView;", "insertInteropView", "layoutAccordingTo", "layoutCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "removeInteropView", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSwingInteropViewHolder.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,186:1\n33#2,6:187\n*S KotlinDebug\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n*L\n164#1:187,6\n*E\n"})
public final class SwingInteropViewHolder<T extends Component>
extends TypedInteropViewHolder<T>
implements ClipRectangle {
    private IntRect clipBounds;
    private final FocusListener focusListener;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SwingInteropViewHolder(Function0<? extends T> factory, InteropContainer container2, Container group, InteropFocusSwitcher focusSwitcher, int compositeKeyHash) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)focusSwitcher, (String)"focusSwitcher");
        super(var1_1, (InteropContainer)var2_2, group, compositeKeyHash, 1.INSTANCE);
        this.focusListener = new FocusListener(group, focusSwitcher){
            final /* synthetic */ Container $group;
            final /* synthetic */ InteropFocusSwitcher $focusSwitcher;
            {
                void var2_2;
                void var1_1;
                this.$group = var1_1;
                this.$focusSwitcher = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(e, this.$group)) {
                    void var1_1;
                    FocusEvent.Cause cause = var1_1.getCause();
                    switch (cause == null ? -1 : focusListener.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            this.$focusSwitcher.moveForward();
                            return;
                        }
                        case 2: {
                            this.$focusSwitcher.moveBackward();
                        }
                    }
                }
            }

            public final void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        var3_3.add((Component)this.getTypedInteropView());
        this.setPlatformModifier(DrawModifierKt.drawBehind(InteropPointerInput_skikoKt.pointerInteropFilter(Modifier.Companion, this), (Function1<? super DrawScope, Unit>)((Function1)2.INSTANCE)));
    }

    public final FocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public final Object getInteropView() {
        return this.getTypedInteropView();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void layoutAccordingTo(LayoutCoordinates layoutCoordinates) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
        LayoutCoordinates rootCoordinates = LayoutCoordinatesKt.findRootCoordinates(layoutCoordinates);
        IntRect clippedBounds = SwingInteropViewHolder_desktopKt.access$round(rootCoordinates.localBoundingBoxOf(layoutCoordinates, true), this.getDensity());
        IntRect bounds = SwingInteropViewHolder_desktopKt.access$round(var2_2.localBoundingBoxOf(layoutCoordinates, false), this.getDensity());
        this.clipBounds = clippedBounds;
        this.getContainer().scheduleUpdate((Function0<Unit>)((Function0)new Function0<Unit>(this, (IntRect)var3_3, (IntRect)var1_1){
            final /* synthetic */ SwingInteropViewHolder<T> this$0;
            final /* synthetic */ IntRect $clippedBounds;
            final /* synthetic */ IntRect $bounds;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$clippedBounds = var2_2;
                this.$bounds = var3_3;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGroup().setVisible(!this.$clippedBounds.isEmpty());
                this.this$0.getGroup().setBounds(this.$clippedBounds.getLeft(), this.$clippedBounds.getTop(), this.$clippedBounds.getWidth(), this.$clippedBounds.getHeight());
                ((Component)this.this$0.getTypedInteropView()).setBounds(this.$bounds.getLeft() - this.$clippedBounds.getLeft(), this.$bounds.getTop() - this.$clippedBounds.getTop(), this.$bounds.getWidth(), this.$bounds.getHeight());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void insertInteropView(Container root, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.add((Component)this.getGroup(), index);
        super.insertInteropView((Container)var1_1, (int)var2_2);
        this.getContainer().getRoot().addFocusListener(this.focusListener);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void changeInteropViewIndex(Container root, int index) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        var1_1.setComponentZOrder(this.getGroup(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeInteropView(Container root) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.remove(this.getGroup());
        super.removeInteropView((Container)var1_1);
        this.getContainer().getRoot().removeFocusListener(this.focusListener);
    }

    public final float getX() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getLeft() : this.getGroup().getX();
    }

    public final float getY() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getTop() : this.getGroup().getY();
    }

    public final float getWidth() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getWidth() : this.getGroup().getWidth();
    }

    public final float getHeight() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getHeight() : this.getGroup().getHeight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void dispatchToView(PointerEvent pointerEvent) {
        Intrinsics.checkNotNullParameter((Object)pointerEvent, (String)"pointerEvent");
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull(pointerEvent);
        if (mouseEvent == null) {
            return;
        }
        MouseEvent e = mouseEvent;
        switch (mouseEvent.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom(e.getComponent(), this.getGroup())) {
            return;
        }
        Component component = this.getDeepestComponentForEvent(e);
        if (component != null) {
            void var3_4;
            component.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, (Component)var3_4));
            List<PointerInputChange> $this$fastForEach$iv = pointerEvent.getChanges();
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                PointerInputChange pointerInputChange = $this$fastForEach$iv.get(index$iv);
                PointerInputChange pointerInputChange2 = pointerInputChange;
                pointerInputChange2 = pointerInputChange;
                pointerInputChange.consume();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Component getDeepestComponentForEvent(MouseEvent event) {
        void var1_1;
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)this.getTypedInteropView());
        return SwingUtilities.getDeepestComponentAt((Component)this.getTypedInteropView(), point.x, var1_1.y);
    }
}

