/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.res.vector;

import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.StrokeJoin;
import androidx.compose.ui.graphics.TileMode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u001b\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"ALPHA_MASK", "", "parseColorValue", "color", "", "parseFillType", "Landroidx/compose/ui/graphics/PathFillType;", "fillType", "(Ljava/lang/String;)I", "parseStrokeCap", "Landroidx/compose/ui/graphics/StrokeCap;", "strokeCap", "parseStrokeJoin", "Landroidx/compose/ui/graphics/StrokeJoin;", "strokeJoin", "parseTileMode", "Landroidx/compose/ui/graphics/TileMode;", "tileMode", "parseDp", "Landroidx/compose/ui/unit/Dp;", "density", "Landroidx/compose/ui/unit/Density;", "(Ljava/lang/String;Landroidx/compose/ui/unit/Density;)F", "ui"})
@SourceDebugExtension(value={"SMAP\nDesktopValueParsers.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopValueParsers.desktop.kt\nandroidx/compose/ui/res/vector/DesktopValueParsers_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,104:1\n1#2:105\n169#3:106\n169#3:107\n*S KotlinDebug\n*F\n+ 1 DesktopValueParsers.desktop.kt\nandroidx/compose/ui/res/vector/DesktopValueParsers_desktopKt\n*L\n99#1:106\n100#1:107\n*E\n"})
public final class DesktopValueParsers_desktopKt {
    private static final int ALPHA_MASK = -16777216;

    /*
     * WARNING - void declaration
     */
    public static final int parseColorValue(String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (!StringsKt.startsWith$default((String)color, (String)"#", (boolean)false, (int)2, null)) {
            color = "Invalid color value " + color;
            throw new IllegalArgumentException(color.toString());
        }
        switch (color.length()) {
            case 7: {
                String string = color.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Integer.parseUnsignedInt(string, 16) | 0xFF000000;
            }
            case 9: {
                String string = color.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Integer.parseUnsignedInt(string, 16);
            }
            case 4: {
                String string = color.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int v = Integer.parseUnsignedInt(string, 16);
                int n = (v >> 8 & 0xF) * 0x110000;
                n |= (v >> 4 & 0xF) * 4352;
                return (n |= (v & 0xF) * 17) | 0xFF000000;
            }
            case 5: {
                void var0_2;
                String v;
                String string = v.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int v2 = Integer.parseUnsignedInt(string, 16);
                int n = (v2 >> 12 & 0xF) * 0x11000000;
                n |= (v2 >> 8 & 0xF) * 0x110000;
                n |= (v2 >> 4 & 0xF) * 4352;
                return (n |= (var0_2 & 0xF) * 17) | 0xFF000000;
            }
        }
        return -16777216;
    }

    public static final int parseFillType(String fillType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fillType, (String)"fillType");
        String string2 = fillType;
        if (Intrinsics.areEqual((Object)string2, (Object)"nonZero")) {
            return PathFillType.Companion.getNonZero-Rg-k1Os();
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"evenOdd")) {
            return PathFillType.Companion.getEvenOdd-Rg-k1Os();
        }
        throw new UnsupportedOperationException("unknown fillType: " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseStrokeCap(String strokeCap) {
        String string;
        Intrinsics.checkNotNullParameter((Object)strokeCap, (String)"strokeCap");
        String string2 = strokeCap;
        switch (string2.hashCode()) {
            case -894674659: {
                if (string2.equals("square")) return StrokeCap.Companion.getSquare-KaPHkGw();
                throw new UnsupportedOperationException("unknown strokeCap: " + string);
            }
            case 108704142: {
                if (string2.equals("round")) return StrokeCap.Companion.getRound-KaPHkGw();
                throw new UnsupportedOperationException("unknown strokeCap: " + string);
            }
            case 3035667: {
                if (!string2.equals("butt")) throw new UnsupportedOperationException("unknown strokeCap: " + string);
                return StrokeCap.Companion.getButt-KaPHkGw();
            }
        }
        throw new UnsupportedOperationException("unknown strokeCap: " + string);
    }

    public static final int parseStrokeJoin(String strokeJoin) {
        String string;
        Intrinsics.checkNotNullParameter((Object)strokeJoin, (String)"strokeJoin");
        switch (strokeJoin) {
            case "miter": {
                return StrokeJoin.Companion.getMiter-LxFBmk8();
            }
            case "round": {
                return StrokeJoin.Companion.getRound-LxFBmk8();
            }
            case "bevel": {
                return StrokeJoin.Companion.getBevel-LxFBmk8();
            }
        }
        throw new UnsupportedOperationException("unknown strokeJoin: " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseTileMode(String tileMode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tileMode, (String)"tileMode");
        String string2 = tileMode;
        switch (string2.hashCode()) {
            case -1073910849: {
                if (string2.equals("mirror")) return TileMode.Companion.getMirror-3opZhB0();
                throw new UnsupportedOperationException("unknown tileMode: " + string);
            }
            case -436781190: {
                if (string2.equals("repeated")) return TileMode.Companion.getRepeated-3opZhB0();
                throw new UnsupportedOperationException("unknown tileMode: " + string);
            }
            case 94742715: {
                if (!string2.equals("clamp")) throw new UnsupportedOperationException("unknown tileMode: " + string);
                return TileMode.Companion.getClamp-3opZhB0();
            }
        }
        throw new UnsupportedOperationException("unknown tileMode: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public static final float parseDp(String $this$parseDp22, Density density) {
        String $this$parseDp22;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        if ($this$parseDp22 == null) {
            return Dp.constructor-impl((float)0.0f);
        }
        if (StringsKt.endsWith$default((String)$this$parseDp22, (String)"dp", (boolean)false, (int)2, null)) {
            float $this$parseDp22 = Float.parseFloat(StringsKt.removeSuffix((String)$this$parseDp22, (CharSequence)"dp"));
            return Dp.constructor-impl((float)$this$parseDp22);
        }
        if (StringsKt.endsWith$default((String)$this$parseDp22, (String)"px", (boolean)false, (int)2, null)) {
            String string;
            void var1_2;
            return var1_2.toDp-u2uoSUM(Float.parseFloat(StringsKt.removeSuffix((String)string, (CharSequence)"px")));
        }
        throw new UnsupportedOperationException("value should ends with dp or px");
    }
}

