/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ComposeAccessibleKt;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u00060\u000bR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010\u0010\u001a\u00020\u0011X\u0082\u0004R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
@StabilityInferred(parameters=0)
public final class ComposeAccessible
extends Component
implements Accessible {
    private final AccessibilityController controller;
    private SemanticsNode semanticsNode;
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    public static final int $stable = 8;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;

    /*
     * WARNING - void declaration
     */
    public ComposeAccessible(SemanticsNode semanticsNode, AccessibilityController controller) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = var2_2;
        this.semanticsNode = var1_1;
        this.isNativelyInitialized$volatile = 0;
        this.composeAccessibleContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleComponent>(this){
            final /* synthetic */ ComposeAccessible this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final ComposeAccessibleComponent invoke() {
                return new ComposeAccessibleComponent(this.this$0);
            }
        }));
    }

    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSemanticsNode(SemanticsNode value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.semanticsNode = var1_1;
        this.cachedSemanticsConfig = null;
    }

    /*
     * WARNING - void declaration
     */
    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            void var2_2;
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            this.cachedSemanticsConfig = var2_2;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    private final /* synthetic */ int isNativelyInitialized$volatile() {
        return this.isNativelyInitialized$volatile;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ void setNativelyInitialized$volatile(int value) {
        void var1_1;
        this.isNativelyInitialized$volatile = var1_1;
    }

    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final boolean getRemoved() {
        return this.removed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRemoved(boolean bl) {
        void var1_1;
        this.removed = var1_1;
    }

    @Override
    public final AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a2\u0001\u00a3\u0001\u00a4\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0011\u0010O\u001a\u00020\u00172\u0006\u0010P\u001a\u00020QH\u0096\u0002J\u0010\u0010R\u001a\u00020\u00172\u0006\u0010S\u001a\u000204H\u0016J\n\u0010T\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010U\u001a\u000204H\u0016J\u0010\u0010V\u001a\u00020W2\u0006\u0010S\u001a\u000204H\u0016J\u0012\u0010X\u001a\u0004\u0018\u00010\u000f2\u0006\u0010P\u001a\u00020QH\u0016J\u0012\u0010Y\u001a\u0004\u0018\u00010\u000f2\u0006\u0010S\u001a\u000204H\u0016J\b\u0010Z\u001a\u000204H\u0016J\n\u0010[\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\\\u001a\u0004\u0018\u00010WH\u0016J\n\u0010]\u001a\u0004\u0018\u00010^H\u0016J\b\u0010_\u001a\u000204H\u0016J\n\u0010`\u001a\u0004\u0018\u00010WH\u0016J\n\u0010a\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020eH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010fH\u0016J\n\u0010g\u001a\u0004\u0018\u00010hH\u0016J\b\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020nH\u0016J\b\u0010o\u001a\u00020pH\u0016J\u0012\u0010q\u001a\u00020r2\b\u0010s\u001a\u0004\u0018\u00010pH\u0016J\b\u0010t\u001a\u00020jH\u0016J\b\u0010u\u001a\u00020vH\u0016J\b\u0010w\u001a\u00020QH\u0016J\b\u0010x\u001a\u00020QH\u0016J\b\u0010y\u001a\u00020zH\u0016J\b\u0010{\u001a\u00020\u0017H\u0016J\b\u0010|\u001a\u00020\u0017H\u0016J\b\u0010}\u001a\u00020\u0017H\u0016J\b\u0010~\u001a\u00020\u0017H\u0016J\u0011\u0010\u007f\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u00020\u0017H\u0002J\u0013\u0010\u0081\u0001\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\t\u0010\u0082\u0001\u001a\u00020LH\u0016J\u0014\u0010\u0083\u0001\u001a\u00020L2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010jH\u0016J\u0014\u0010\u0085\u0001\u001a\u00020L2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010lH\u0016J\u0014\u0010\u0087\u0001\u001a\u00020L2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010nH\u0016J\u0012\u0010\u0089\u0001\u001a\u00020L2\u0007\u0010\u008a\u0001\u001a\u00020\u0017H\u0016J\u0013\u0010\u008b\u0001\u001a\u00020L2\b\u0010s\u001a\u0004\u0018\u00010pH\u0016J\u0014\u0010\u008c\u0001\u001a\u00020L2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010jH\u0016J\u0013\u0010\u008d\u0001\u001a\u00020L2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0014\u0010\u008e\u0001\u001a\u00020L2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010zH\u0016J\u0012\u0010\u0090\u0001\u001a\u00020L2\u0007\u0010\u008a\u0001\u001a\u00020\u0017H\u0016J\u001a\u0010\u0091\u0001\u001a\u00020z*\u00030\u0092\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0094\u0001J\u001a\u0010\u0095\u0001\u001a\u00020Q*\u00030\u0096\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u001a\u0010\u0099\u0001\u001a\u000204*\u00030\u009a\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u009b\u0001\u0010\u009c\u0001J\u000e\u0010\u009d\u0001\u001a\u00020l*\u00030\u009e\u0001H\u0002J\u001d\u0010\u009f\u0001\u001a\u00030\u0096\u0001*\u00020QH\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u00a0\u0001\u0010\u00a1\u0001R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0006\u001a\f\u0018\u00010\u0007R\u00060\u0000R\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0019R\u0011\u0010\u001f\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%RI\u0010&\u001a:\u00124\u00122\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u00170(\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0013\u00100\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0019R1\u00102\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001703\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010/R%\u00106\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u001707\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010/R\u0013\u0010:\u001a\u0004\u0018\u0001088F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0013\u0010=\u001a\u0004\u0018\u00010>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0019\u0010A\u001a\u0004\u0018\u00010B8F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0013\u0010E\u001a\u0004\u0018\u00010F8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0013\u0010I\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001d\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u00a5\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "accessibleAction", "accessibleText", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "focused", "", "getFocused", "()Ljava/lang/Boolean;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "isContainer", "isPassword", "()Z", "isTraversalGroup", "progressBarRangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "scrollBy", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "selected", "getSelected", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "setText", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "getSetText", "text", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "verticalScroll", "getVerticalScroll", "addFocusListener", "", "l", "Ljava/awt/event/FocusListener;", "contains", "p", "Ljava/awt/Point;", "doAccessibleAction", "i", "getAccessibleAction", "getAccessibleActionCount", "getAccessibleActionDescription", "", "getAccessibleAt", "getAccessibleChild", "getAccessibleChildrenCount", "getAccessibleComponent", "getAccessibleDescription", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "getAccessibleIndexInParent", "getAccessibleName", "getAccessibleParent", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "Ljavax/accessibility/AccessibleText;", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getBackground", "Ljava/awt/Color;", "getBounds", "Ljava/awt/Rectangle;", "getCursor", "Ljava/awt/Cursor;", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Ljava/awt/FontMetrics;", "f", "getForeground", "getLocale", "Ljava/util/Locale;", "getLocation", "getLocationOnScreen", "getSize", "Ljava/awt/Dimension;", "isEnabled", "isFocusTraversable", "isShowing", "isVisible", "makeScrollbarChild", "vertical", "removeFocusListener", "requestFocus", "setBackground", "c", "setBounds", "r", "setCursor", "cursor", "setEnabled", "b", "setFont", "setForeground", "setLocation", "setSize", "d", "setVisible", "toAwtDimension", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "toAwtPoint", "Landroidx/compose/ui/geometry/Offset;", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Landroidx/compose/ui/geometry/Rect;", "toComposeOffset", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "ComposeAccessibleEditableText", "ComposeAccessibleText", "ScrollBarAccessible", "ui"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n*L\n1#1,884:1\n149#2:885\n350#3,7:886\n82#4:893\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n225#1:885\n327#1:886,7\n365#1:893\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleAction,
    AccessibleComponent {
        private AccessibleAction accessibleAction;
        private final Lazy accessibleText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComposeAccessibleText>(this){
            final /* synthetic */ ComposeAccessibleComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final ComposeAccessibleText invoke() {
                if (this.this$0.getSetText() != null) {
                    return this.this$0.new ComposeAccessibleEditableText();
                }
                if (this.this$0.getText() != null) {
                    return new ComposeAccessibleText(this.this$0);
                }
                return null;
            }
        }));
        final /* synthetic */ ComposeAccessible this$0;

        /*
         * WARNING - void declaration
         */
        public ComposeAccessibleComponent(ComposeAccessible this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        public final AnnotatedString getText() {
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString == null) {
                annotatedString = (AnnotatedString)ComposeAccessibleKt.access$getFirstOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
            }
            return annotatedString;
        }

        /*
         * WARNING - void declaration
         */
        public final TextLayoutResult getTextLayoutResult() {
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            accessibilityAction = accessibilityAction != null && (accessibilityAction = accessibilityAction.getAction()) != null ? (Boolean)accessibilityAction.invoke(textLayoutResults) : null;
            if (Intrinsics.areEqual(accessibilityAction, (Object)Boolean.TRUE)) {
                void var1_1;
                return (TextLayoutResult)var1_1.get(0);
            }
            return null;
        }

        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return this.this$0.controller.getDesktopComponent().getDensity();
        }

        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        /*
         * WARNING - void declaration
         */
        public final List<Accessible> getAuxiliaryChildren() {
            List list;
            List $this$_get_auxiliaryChildren__u24lambda_u242 = list = CollectionsKt.createListBuilder();
            if (this.getHorizontalScroll() != null) {
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
            }
            if (this.getVerticalScroll() != null) {
                void var2_2;
                var2_2.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list);
        }

        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        /*
         * WARNING - void declaration
         */
        private final Accessible makeScrollbarChild(boolean vertical) {
            void var1_2;
            void var2_3;
            void var3_4;
            ScrollBarAccessible bar = new ScrollBarAccessible(this, vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, this.this$0);
            bar.getContext().getAccessibleRelationSet().add((AccessibleRelation)var3_4);
            this.getAccessibleRelationSet().add((AccessibleRelation)var2_3);
            return (Accessible)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ) {
            void var2_2;
            void var1_1;
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u243 = this.getDensity();
            int n = $this$toComposeOffset_u2dtuRUvjQ.x;
            int n2 = n;
            n2 = var1_1.y;
            return OffsetKt.Offset((float)$this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl((float)n)), (float)var2_2.toPx-0680j_4(Dp.constructor-impl((float)n2)));
        }

        /*
         * WARNING - void declaration
         */
        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            void var1_1;
            if (Float.isInfinite($this$toAwtPx_u2d0680j_4)) {
                return Integer.MAX_VALUE;
            }
            return MathKt.roundToInt((float)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            void var1_1;
            void var2_2;
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getWidth())), this.toAwtPx-0680j_4(var2_2.toDp-u2uoSUM(var1_1.getHeight())));
        }

        /*
         * WARNING - void declaration
         */
        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            void var1_1;
            void var3_2;
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            return new Point(this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Offset.getX-impl((long)$this$toAwtPoint_u2dk_u2d4lQ0M))), this.toAwtPx-0680j_4(var3_2.toDp-u2uoSUM(Offset.getY-impl((long)var1_1))));
        }

        /*
         * WARNING - void declaration
         */
        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            void var1_1;
            void var3_2;
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            return new Dimension(this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM(IntSize.getWidth-impl((long)$this$toAwtDimension_u2dozmzZPI))), this.toAwtPx-0680j_4(var3_2.toDp-u2uoSUM(IntSize.getHeight-impl((long)var1_1))));
        }

        @Override
        public String getAccessibleName() {
            AnnotatedString annotatedString = this.getText();
            if (annotatedString != null) {
                return annotatedString.toString();
            }
            return null;
        }

        @Override
        public String getAccessibleDescription() {
            return (String)ComposeAccessibleKt.access$getFirstOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
        }

        @Override
        public Accessible getAccessibleParent() {
            Object object = this.this$0.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = this.this$0;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(n);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    return (Accessible)object;
                }
            }
            return this.accessibleParent;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleAction getAccessibleAction() {
            void var1_1;
            List actions = new ArrayList();
            if (SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick()) != null) {
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(this.this$0, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction((List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>>)var1_1, this.this$0){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.$actions = var1_1;
                    this.this$0 = var2_2;
                }

                public final int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                /*
                 * WARNING - void declaration
                 */
                public final String getAccessibleActionDescription(int i) {
                    void var1_1;
                    String string = (String)this.$actions.get((int)var1_1).component1();
                    return string;
                }

                public final boolean doAccessibleAction(int i) {
                    AccessibilityAction accessibilityAction;
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    Object object = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), accessibilityAction);
                    if (object != null) {
                        accessibilityAction = object;
                        Function0 function0 = (Function0)((AccessibilityAction)object).getAction();
                        object = function0 != null ? (Boolean)function0.invoke() : null;
                        if (object != null) {
                            return (Boolean)object;
                        }
                    }
                    return false;
                }
            };
            return this.accessibleAction;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            if (this.getToggleableState() != null) {
                return new ToggleableAccessibleValue(this);
            }
            if (this.getProgressBarRangeInfo() != null) {
                return new ProgressBarAccessibleValue(this);
            }
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block3: {
                Object object;
                SemanticsNode semanticsNode = this.this$0.getSemanticsNode().getParent();
                Object object2 = object = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (object2 != null) {
                    object = object2;
                    ComposeAccessible composeAccessible = this.this$0;
                    int index$iv = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object3 = object.next();
                        if (((SemanticsNode)(object3 = (SemanticsNode)object3)).getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block3;
                        }
                        ++index$iv;
                    }
                    return -1;
                }
                n = -1;
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.this$0.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Accessible getAccessibleChild(int i) {
            void var3_3;
            void var1_1;
            List<SemanticsNode> replacedChildren = this.this$0.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            if (i < replacedChildrenSize) {
                void var2_2;
                return this.this$0.controller.accessibleByNodeId(((SemanticsNode)var2_2.get(i)).getId());
            }
            return this.getAuxiliaryChildren().get((int)(var1_1 - var3_3));
        }

        @Override
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        public Point getLocationOnScreen() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(composeAccessibleComponent.this$0.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        public Point getLocation() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtPoint-k-4lQ0M(composeAccessibleComponent.this$0.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        public Rectangle getBounds() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtRectangle(composeAccessibleComponent.this$0.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        public Dimension getSize() {
            ComposeAccessibleComponent composeAccessibleComponent = this;
            return composeAccessibleComponent.toAwtDimension-ozmzZPI(composeAccessibleComponent.this$0.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            return !this.this$0.getSemanticsConfig().contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) && !DelegatableNodeKt.requireCoordinator-64DMado(this.this$0.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent();
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Accessible getAccessibleAt(Point p) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                Accessible accessible2 = this.getAccessibleChild(i);
                Object object = accessible2 != null ? accessible2.getAccessibleContext() : null;
                AccessibleComponent child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt((Point)p)) == null) continue;
                p = object;
                return p;
            }
            if (this.contains((Point)var1_1)) {
                return this.this$0;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.FALSE) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (accessibilityAction = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)accessibilityAction.invoke();
            }
        }

        @Override
        public void addFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeFocusListener(FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole;
            AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
            Object object = SemanticsConfigurationKt.getOrNull(this.this$0.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            int n = Role.Companion.getButton-o7Vup1c();
            Role role = object;
            if (role == null ? false : Role.equals-impl0(role.unbox-impl(), n)) {
                accessibleRole = AccessibleRole.PUSH_BUTTON;
            } else {
                n = Role.Companion.getCheckbox-o7Vup1c();
                Object object2 = object;
                if (object2 == null ? false : Role.equals-impl0(((Role)object2).unbox-impl(), n)) {
                    accessibleRole = AccessibleRole.CHECK_BOX;
                } else {
                    n = Role.Companion.getRadioButton-o7Vup1c();
                    Object object3 = object;
                    if (object3 == null ? false : Role.equals-impl0(((Role)object3).unbox-impl(), n)) {
                        accessibleRole = AccessibleRole.RADIO_BUTTON;
                    } else {
                        n = Role.Companion.getTab-o7Vup1c();
                        Object object4 = object;
                        if (object4 == null ? false : Role.equals-impl0(((Role)object4).unbox-impl(), n)) {
                            accessibleRole = AccessibleRole.PAGE_TAB;
                        } else {
                            n = Role.Companion.getDropdownList-o7Vup1c();
                            Object object5 = object;
                            accessibleRole = (object5 == null ? false : Role.equals-impl0(((Role)object5).unbox-impl(), n)) ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            object = accessibleRole;
            AccessibleRole accessibleRole2 = accessibleRole;
            if (accessibleRole == null) {
                if (this.isPassword()) {
                    AccessibleRole accessibleRole3 = AccessibleRole.PASSWORD_TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole3, (String)"PASSWORD_TEXT");
                    return accessibleRole3;
                }
                if (this.getScrollBy() != null) {
                    AccessibleRole accessibleRole4 = AccessibleRole.SCROLL_PANE;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole4, (String)"SCROLL_PANE");
                    return accessibleRole4;
                }
                if (this.getSetText() != null) {
                    AccessibleRole accessibleRole5 = AccessibleRole.TEXT;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole5, (String)"TEXT");
                    return accessibleRole5;
                }
                if (this.getText() != null) {
                    AccessibleRole accessibleRole6 = AccessibleRole.LABEL;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole6, (String)"LABEL");
                    return accessibleRole6;
                }
                if (this.getProgressBarRangeInfo() != null) {
                    AccessibleRole accessibleRole7 = AccessibleRole.PROGRESS_BAR;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole7, (String)"PROGRESS_BAR");
                    return accessibleRole7;
                }
                if (this.isContainer() != null) {
                    AccessibleRole accessibleRole8 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole8, (String)"GROUP_BOX");
                    return accessibleRole8;
                }
                if (this.isTraversalGroup() != null) {
                    AccessibleRole accessibleRole9 = AccessibleRole.GROUP_BOX;
                    Intrinsics.checkNotNullExpressionValue((Object)accessibleRole9, (String)"GROUP_BOX");
                    return accessibleRole9;
                }
                AccessibleRole accessibleRole10 = AccessibleRole.UNKNOWN;
                accessibleRole2 = accessibleRole10;
                Intrinsics.checkNotNullExpressionValue((Object)accessibleRole10, (String)"UNKNOWN");
            }
            return accessibleRole2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            void var2_3;
            boolean canCollapse;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            ComposeAccessible composeAccessible = this.this$0;
            AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u2412 = accessibleStateSet;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)Boolean.TRUE)) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.FOCUSED);
            }
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.CHECKED);
                    break;
                }
                case 2: {
                    $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.INDETERMINATE);
                }
            }
            boolean canExpand = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getExpand()) != null;
            boolean bl = canCollapse = SemanticsConfigurationKt.getOrNull(composeAccessible.getSemanticsConfig(), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (var2_3 != false) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.EXPANDED);
            }
            if (this.getSelected() != null) {
                $this$getAccessibleStateSet_u24lambda_u2412.add(AccessibleState.SELECTABLE);
            }
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)Boolean.TRUE)) {
                void var3_4;
                var3_4.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText2 = this.getAccessibleText();
            if (accessibleText2 instanceof AccessibleEditableText) {
                void var1_1;
                return (AccessibleEditableText)var1_1;
            }
            return null;
        }

        @Override
        public void setBounds(Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setSize(Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setLocation(Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setBackground(Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setForeground(Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setCursor(Cursor cursor) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setFont(Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                return accessibleAction.getAccessibleActionCount();
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getAccessibleActionDescription(int i) {
            void var1_1;
            AccessibleAction accessibleAction = this.accessibleAction;
            String string = accessibleAction != null ? accessibleAction.getAccessibleActionDescription((int)var1_1) : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            if (accessibleAction != null) {
                void var1_1;
                return accessibleAction.doAccessibleAction((int)var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key);
            if (accessibilityAction != null) {
                void var2_2;
                AccessibilityAction<Function0<Boolean>> accessibilityAction2;
                void var1_1;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                var1_1.add(new Pair((Object)accessibilityAction2.getLabel(), (Object)var2_2));
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ long access$toComposeOffset-tuRUvjQ(ComposeAccessibleComponent $this, Point $receiver) {
            void var1_1;
            return $this.toComposeOffset-tuRUvjQ((Point)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Rectangle access$toAwtRectangle(ComposeAccessibleComponent $this, Rect $receiver) {
            void var1_1;
            return $this.toAwtRectangle((Rect)var1_1);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "cut", "", "startIndex", "", "endIndex", "delete", "getTextRange", "", "insertTextAtIndex", "index", "s", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "setTextContents", "ui"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,884:1\n1241#2:885\n1241#2:886\n1241#2:887\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n688#1:885\n703#1:886\n721#1:887\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleEditableText() {
                void var1_1;
                super((ComposeAccessibleComponent)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setTextContents(String s) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString((String)var1_1, null, null, 6, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void insertTextAtIndex(int index, String s) {
                void var3_3;
                void var1_1;
                void var2_2;
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index));
                $this$insertTextAtIndex_u24lambda_u240.append((String)var2_2);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence((int)var1_1, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return ((Object)((CharSequence)annotatedString).subSequence((int)var1_1, (int)var2_2)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void delete(int startIndex, int endIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$delete_u24lambda_u241.append(text.subSequence(0, (int)var1_1));
                $this$delete_u24lambda_u241.append(text.subSequence((int)var2_2, var3_3.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public final void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public final void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void replaceText(int startIndex, int endIndex, String s) {
                void var2_2;
                void var3_3;
                void var1_1;
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AnnotatedString annotatedString = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                AnnotatedString text = annotatedString;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, (int)var1_1));
                $this$replaceText_u24lambda_u242.append((String)var3_3);
                $this$replaceText_u24lambda_u242.append(text.subSequence((int)var2_2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void selectText(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)((int)var1_1), (Object)((int)var2_2), (Object)Boolean.FALSE);
            }

            @Override
            public final void setAttributes(int startIndex, int endIndex, AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\""}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getAfterIndex", "", "part", "", "index", "getAtIndex", "getBeforeIndex", "getCaretPosition", "getCharCount", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "i", "getCharacterBounds", "Ljava/awt/Rectangle;", "getIndexAtPoint", "p", "Ljava/awt/Point;", "getSelectedText", "getSelectionEnd", "getSelectionStart", "getTextBounds", "startIndex", "endIndex", "getTextRange", "getTextSequenceAfter", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAt", "getTextSequenceBefore", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "ui"})
        public class ComposeAccessibleText
        implements AccessibleExtendedText,
        AccessibleText {
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ComposeAccessibleText(ComposeAccessibleComponent this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int getIndexAtPoint(Point p) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.access$toComposeOffset-tuRUvjQ(this.this$0, (Point)var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Rectangle getCharacterBounds(int i) {
                void var1_1;
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        AnnotatedString annotatedString = this.this$0.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        if (i < annotatedString.length()) break block3;
                    }
                    return new Rectangle((int)((float)this.this$0.getLocation().x / this.this$0.getDensity().getDensity()), (int)((float)this.this$0.getLocation().y / this.this$0.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = this.this$0.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.access$toAwtRectangle(this.this$0, textLayoutResult.getBoundingBox((int)var1_1));
            }

            @Override
            public int getCharCount() {
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return -1;
            }

            /*
             * WARNING - void declaration
             */
            private final BreakIterator partToBreakIterator(int part) {
                void var1_2;
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                breakIterator.setText(annotatedString.toString());
                return var1_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAtIndex(int part, int index) {
                void var1_1;
                void var2_2;
                int end = this.partToBreakIterator(part).following(index);
                if (end == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_2, (int)var1_1).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getAfterIndex(int part, int index) {
                void var1_3;
                void var2_4;
                void var3_5;
                BreakIterator iterator2 = this.partToBreakIterator(part);
                while (true) {
                    int start;
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    AnnotatedString annotatedString = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString);
                    if (annotatedString.charAt(start) == ' ') continue;
                    AnnotatedString annotatedString2 = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)annotatedString2);
                    if (annotatedString2.charAt(start) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : var3_5;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var2_4, (int)var1_3).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getBeforeIndex(int part, int index) {
                void var2_2;
                void var1_1;
                int start = this.partToBreakIterator(part).preceding(index);
                if (start == -1) {
                    return "";
                }
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getStart-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = this.this$0.getTextSelectionRange-MzsxiRA();
                if (textRange != null) {
                    return TextRange.getEnd-impl((long)textRange.unbox-impl());
                }
                return 0;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        void var3_3;
                        object = this.this$0.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = this.this$0;
                        long selection = textRange.unbox-impl();
                        AnnotatedString annotatedString = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)annotatedString);
                        object = annotatedString.subSequence(TextRange.getStart-impl((long)selection), TextRange.getEnd-impl((long)var3_3)).toString();
                        if (object != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getTextRange(int startIndex, int endIndex) {
                void var2_2;
                void var1_1;
                AnnotatedString annotatedString = this.this$0.getText();
                Intrinsics.checkNotNull((Object)annotatedString);
                return annotatedString.subSequence((int)var1_1, (int)var2_2).toString();
            }

            @Override
            public AccessibleTextSequence getTextSequenceAt(int part, int index) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getVertical", "()Z", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            private final AccessibleContext context;
            final /* synthetic */ ComposeAccessibleComponent this$0;

            /*
             * WARNING - void declaration
             */
            public ScrollBarAccessible(ComposeAccessibleComponent this$0, boolean vertical) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.vertical = var2_2;
                ScrollBarAccessible scrollBarAccessible = this;
                this.context = (AccessibleContext)((Object)new AccessibleValue(scrollBarAccessible, scrollBarAccessible.this$0, this.this$0.this$0){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        void var1_1;
                        void var3_3;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = var3_3;
                        if (var1_1.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            void var2_2;
                            ScrollAxisRange scrollAxisRange3 = var2_2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public final AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public final AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        if (scrollBarAccessible.getVertical()) {
                            $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL);
                        } else {
                            void var3_3;
                            var3_3.add(AccessibleState.HORIZONTAL);
                        }
                        return accessibleStateSet;
                    }

                    public final Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public final int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public final int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public final Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    public final Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    public final Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean setCurrentAccessibleValue(Number n) {
                        void var1_1;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            return (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        }
                        AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                        Intrinsics.checkNotNull(accessibilityAction);
                        Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                        Intrinsics.checkNotNull(function2);
                        void v6 = var1_1;
                        Intrinsics.checkNotNull((Object)v6);
                        return (Boolean)function2.invoke((Object)Float.valueOf(v6.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                    }

                    public final Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public final Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            public final AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

