/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.DepthSortedSet;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.SortedSet;
import java.util.Comparator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u0086\bJ\u0006\u0010\u0018\u001a\u00020\u0007J\"\u0010\u0019\u001a\u00020\u00132\u0014\b\u0004\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u001bH\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/node/DepthSortedSet;", "", "extraAssertions", "", "(Z)V", "DepthComparator", "Ljava/util/Comparator;", "Landroidx/compose/ui/node/LayoutNode;", "Lkotlin/Comparator;", "mapOfOriginalDepth", "", "", "getMapOfOriginalDepth", "()Ljava/util/Map;", "mapOfOriginalDepth$delegate", "Lkotlin/Lazy;", "set", "Landroidx/compose/ui/node/SortedSet;", "add", "", "node", "contains", "isEmpty", "isNotEmpty", "pop", "popEach", "block", "Lkotlin/Function1;", "remove", "toString", "", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDepthSortedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,191:1\n102#1:227\n42#2,7:192\n42#2,7:199\n42#2,7:206\n42#2,7:213\n42#2,7:220\n*S KotlinDebug\n*F\n+ 1 DepthSortedSet.kt\nandroidx/compose/ui/node/DepthSortedSet\n*L\n93#1:227\n54#1:192,7\n62#1:199,7\n68#1:206,7\n75#1:213,7\n79#1:220,7\n*E\n"})
public final class DepthSortedSet {
    private final boolean extraAssertions;
    private final Lazy mapOfOriginalDepth$delegate;
    private final Comparator<LayoutNode> DepthComparator;
    private final SortedSet<LayoutNode> set;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public DepthSortedSet(boolean extraAssertions) {
        void var1_1;
        this.extraAssertions = var1_1;
        this.mapOfOriginalDepth$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)mapOfOriginalDepth.2.INSTANCE);
        this.DepthComparator = new Comparator<LayoutNode>(){

            /*
             * WARNING - void declaration
             */
            public final int compare(LayoutNode l1, LayoutNode l2) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
                Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
                int depthDiff = Intrinsics.compare((int)l1.getDepth$ui(), (int)l2.getDepth$ui());
                if (depthDiff != 0) {
                    void var3_3;
                    return (int)var3_3;
                }
                return Intrinsics.compare((int)var1_1.hashCode(), (int)var2_2.hashCode());
            }
        };
        this.set = new SortedSet<LayoutNode>(this.DepthComparator);
    }

    private final Map<LayoutNode, Integer> getMapOfOriginalDepth() {
        Lazy lazy = this.mapOfOriginalDepth$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(LayoutNode node) {
        void var2_3;
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean contains = this.set.contains(node);
        if (this.extraAssertions && !(bl = contains == this.getMapOfOriginalDepth().containsKey(var1_1))) {
            InlineClassHelperKt.throwIllegalStateException("inconsistency in TreeSet");
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(LayoutNode node) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl = node.isAttached();
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.add called on an unattached node");
        }
        if (this.extraAssertions) {
            Integer usedDepth = this.getMapOfOriginalDepth().get(node);
            if (usedDepth == null) {
                LayoutNode layoutNode2 = node;
                this.getMapOfOriginalDepth().put(layoutNode2, layoutNode2.getDepth$ui());
            } else {
                void var2_3;
                int n = node.getDepth$ui();
                n = var2_3.intValue() == n ? 1 : 0;
                if (n == 0) {
                    InlineClassHelperKt.throwIllegalStateException("invalid node depth");
                }
            }
        }
        this.set.add((LayoutNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(LayoutNode node) {
        void var1_1;
        Integer n;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl2 = node.isAttached();
        if (!bl2) {
            InlineClassHelperKt.throwIllegalStateException("DepthSortedSet.remove called on an unattached node");
        }
        boolean contains = this.set.remove(node);
        if (this.extraAssertions && !(bl = Intrinsics.areEqual((Object)(n = this.getMapOfOriginalDepth().remove(node)), contains ? Integer.valueOf(var1_1.getDepth$ui()) : null))) {
            InlineClassHelperKt.throwIllegalStateException("invalid node depth");
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public final LayoutNode pop() {
        void var1_1;
        LayoutNode node = (LayoutNode)this.set.first();
        Intrinsics.checkNotNull((Object)node);
        this.remove(node);
        return var1_1;
    }

    public final void popEach(Function1<? super LayoutNode, Unit> block) {
        DepthSortedSet depthSortedSet;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        while (!(depthSortedSet = this).isEmpty()) {
            LayoutNode node = this.pop();
            block.invoke((Object)depthSortedSet);
        }
    }

    public final boolean isEmpty() {
        return this.set.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final String toString() {
        String string = this.set.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

