/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import androidx.compose.ui.internal.InlineClassHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u001a(\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0002\u0010\u0018\u001a(\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u001a\u0011\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0082\b\u001a2\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\b\b\u0002\u0010$\u001a\u00020\u0014H\u0000\u001a\u0012\u0010%\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)\u001a\u0014\u0010*\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u0014\u0010+\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u0014\u0010,\u001a\u00020\u0003*\u00020\u00142\u0006\u0010-\u001a\u00020\u0014H\u0002\u001a,\u0010.\u001a\u00020\u0003*\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`/2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0001H\u0082\n\u00a2\u0006\u0002\u00102\u001a\r\u00103\u001a\u00020\u0003*\u00020\u0014H\u0082\b\u001a4\u00104\u001a\u00020&*\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`/2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0003H\u0082\n\u00a2\u0006\u0002\u00106\u001a1\u00104\u001a\u00020&*\n\u0012\u0006\u0012\u0004\u0018\u0001070\u00132\u0006\u00108\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u0002092\u0006\u0010:\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\",\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\",\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068G@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\t\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r*\u0018\b\u0002\u0010\u0012\"\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0012\u0004\u0012\u00020\u00140\u0013*\f\b\u0002\u0010<\"\u00020\u00142\u00020\u0014\u00a8\u0006="}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HorizonMilliseconds", "<set-?>", "", "VelocityTrackerAddPointsFix", "getVelocityTrackerAddPointsFix$annotations", "()V", "getVelocityTrackerAddPointsFix", "()Z", "setVelocityTrackerAddPointsFix", "(Z)V", "VelocityTrackerStrategyUseImpulse", "getVelocityTrackerStrategyUseImpulse$annotations", "getVelocityTrackerStrategyUseImpulse", "setVelocityTrackerStrategyUseImpulse", "Matrix", "", "", "Landroidx/compose/ui/input/pointer/util/Vector;", "rows", "cols", "(II)[[F", "calculateImpulseVelocity", "dataPoints", "time", "sampleCount", "isDataDifferential", "kineticEnergyToVelocity", "kineticEnergy", "polyFitLeastSquares", "x", "y", "degree", "coefficients", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "addPointerInputChangeLegacy", "addPointerInputChangeWithFix", "dot", "a", "get", "Landroidx/compose/ui/input/pointer/util/Matrix;", "row", "col", "([[FII)F", "norm", "set", "value", "([[FIIF)V", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "", "dataPoint", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "Vector", "ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,756:1\n718#1:769\n725#1,2:770\n721#1,6:772\n718#1:778\n718#1:779\n713#1:780\n699#1:782\n699#1:783\n33#2,6:757\n33#2,6:763\n78#3:781\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n520#1:769\n522#1:770,2\n524#1:772,6\n531#1:778\n533#1:779\n546#1:780\n683#1:782\n689#1:783\n418#1:757,6\n454#1:763,6\n546#1:781\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;
    private static boolean VelocityTrackerAddPointsFix = true;
    private static boolean VelocityTrackerStrategyUseImpulse;

    /*
     * WARNING - void declaration
     */
    private static final void set(DataPointAtTime[] $this$set, int index, long time, float dataPoint) {
        void var2_2;
        DataPointAtTime currentEntry = $this$set[index];
        if (currentEntry == null) {
            var0[var1_1] = new DataPointAtTime(time, dataPoint);
            return;
        }
        currentEntry.setTime((long)var2_2);
        currentEntry.setDataPoint(dataPoint);
    }

    /*
     * WARNING - void declaration
     */
    public static final void addPointerInputChange(VelocityTracker $this$addPointerInputChange, PointerInputChange event) {
        void var1_1;
        VelocityTracker velocityTracker;
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (VelocityTrackerAddPointsFix) {
            VelocityTrackerKt.addPointerInputChangeWithFix($this$addPointerInputChange, event);
            return;
        }
        VelocityTrackerKt.addPointerInputChangeLegacy(velocityTracker, (PointerInputChange)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addPointerInputChangeLegacy(VelocityTracker $this$addPointerInputChangeLegacy, PointerInputChange event) {
        VelocityTracker velocityTracker;
        void var1_1;
        void var2_4;
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeLegacy.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChangeLegacy.resetTracking();
        }
        long previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange historicalChange;
            HistoricalChange it = historicalChange = $this$fastForEach$iv.get(index$iv);
            long historicalDelta = Offset.minus-MK-Hz9U((long)historicalChange.getPosition-F1C5BW0(), (long)previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            VelocityTracker velocityTracker2 = $this$addPointerInputChangeLegacy;
            velocityTracker2.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker2.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)historicalDelta));
            $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChangeLegacy.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
        }
        long delta = Offset.minus-MK-Hz9U((long)event.getPosition-F1C5BW0(), (long)previousPointerPosition);
        VelocityTracker velocityTracker3 = $this$addPointerInputChangeLegacy;
        velocityTracker3.setCurrentPointerPositionAccumulator-k-4lQ0M$ui(Offset.plus-MK-Hz9U((long)velocityTracker3.getCurrentPointerPositionAccumulator-F1C5BW0$ui(), (long)var2_4));
        $this$addPointerInputChangeLegacy.addPosition-Uv8p0NA(var1_1.getUptimeMillis(), velocityTracker.getCurrentPointerPositionAccumulator-F1C5BW0$ui());
    }

    /*
     * WARNING - void declaration
     */
    private static final void addPointerInputChangeWithFix(VelocityTracker $this$addPointerInputChangeWithFix, PointerInputChange event) {
        void var1_1;
        VelocityTracker velocityTracker;
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        if (!PointerEventKt.changedToUpIgnoreConsumed(event)) {
            List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                HistoricalChange historicalChange;
                HistoricalChange it = historicalChange = $this$fastForEach$iv.get(index$iv);
                $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(it.getUptimeMillis(), it.getOriginalEventPosition-F1C5BW0$ui());
            }
            $this$addPointerInputChangeWithFix.addPosition-Uv8p0NA(event.getUptimeMillis(), event.getOriginalEventPosition-F1C5BW0$ui());
        }
        if (PointerEventKt.changedToUpIgnoreConsumed(event) && event.getUptimeMillis() - $this$addPointerInputChangeWithFix.getLastMoveEventTimeStamp$ui() > 40L) {
            $this$addPointerInputChangeWithFix.resetTracking();
        }
        velocityTracker.setLastMoveEventTimeStamp$ui(var1_1.getUptimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    public static final float[] polyFitLeastSquares(float[] x2, float[] y, int sampleCount, int degree, float[] coefficients) {
        void var1_4;
        int row$iv2;
        int m;
        void truncatedDegree;
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        if (degree <= 0) {
            InlineClassHelperKt.throwIllegalArgumentException("The degree must be at positive integer");
        }
        if (sampleCount == 0) {
            InlineClassHelperKt.throwIllegalArgumentException("At least one point must be provided");
        }
        truncatedDegree = degree >= sampleCount ? sampleCount - 1 : truncatedDegree;
        int n = truncatedDegree + true;
        int n2 = 0;
        float[][] fArrayArray = new float[n][];
        while (n2 < n) {
            int n3 = n2++;
            fArrayArray[n3] = new float[m];
        }
        float[][] a = fArrayArray;
        for (int h = 0; h < m; ++h) {
            float[][] fArrayArray2 = a;
            a[0][h] = 1.0f;
            for (int i = 1; i < n; ++i) {
                void $this$get$iv;
                void value$iv22;
                fArrayArray = a;
                float[][] fArrayArray3 = a;
                row$iv2 = i - 1;
                $this$set$iv[i][h] = value$iv22 = $this$get$iv[row$iv2][h] * x2[h];
            }
        }
        int $this$set$iv = 0;
        float[][] value$iv22 = new float[n][];
        while ($this$set$iv < n) {
            row$iv2 = $this$set$iv++;
            value$iv22[row$iv2] = new float[m];
        }
        float[][] q = value$iv22;
        int value$iv22 = 0;
        float[][] row$iv2 = new float[n][];
        while (value$iv22 < n) {
            int x2 = value$iv22++;
            row$iv2[x2] = new float[n];
        }
        float[][] r = row$iv2;
        for (int j = 0; j < n; ++j) {
            float f;
            float[] w = q[j];
            ArraysKt.copyInto((float[])a[j], (float[])w, (int)0, (int)0, (int)m);
            for (int i = 0; i < j; ++i) {
                float[] z = q[i];
                float dot = VelocityTrackerKt.dot(w, z);
                for (int h = 0; h < m; ++h) {
                    int n4 = h;
                    w[n4] = w[n4] - dot * z[h];
                }
            }
            float[] $this$norm$iv = w;
            float $this$fastCoerceAtLeast$iv = (float)Math.sqrt(VelocityTrackerKt.dot(w, $this$norm$iv));
            float inverseNorm = 1.0f / (f < 1.0E-6f ? 1.0E-6f : $this$fastCoerceAtLeast$iv);
            int h = 0;
            while (h < m) {
                int dot = h++;
                w[dot] = w[dot] * inverseNorm;
            }
            float[] v = r[j];
            for (int i = 0; i < n; ++i) {
                int n5 = i;
                v[n5] = n5 < j ? 0.0f : VelocityTrackerKt.dot(w, a[i]);
            }
        }
        void wy = var1_4;
        for (void i = n - true; i >= 0; --i) {
            float[] fArray;
            float c = VelocityTrackerKt.dot(q[i], (float[])wy);
            float[] ri = r[i];
            void var12_32 = i + true;
            void j = n - true;
            if (var12_32 <= j) {
                while (true) {
                    c -= ri[j] * coefficients[j];
                    if (j == var12_32) break;
                    --j;
                }
            }
            coefficients[i] = c / fArray[i];
        }
        return coefficients;
    }

    public static /* synthetic */ float[] polyFitLeastSquares$default(float[] fArray, float[] fArray2, int n, int n2, float[] fArray3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            fArray3 = new float[RangesKt.coerceAtLeast((int)(n2 + 1), (int)0)];
        }
        return VelocityTrackerKt.polyFitLeastSquares(fArray, fArray2, n, n2, fArray3);
    }

    private static final float calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        float work = 0.0f;
        int start = sampleCount - 1;
        float nextTime = time[start];
        for (int i = start; i > 0; --i) {
            float currentTime = nextTime;
            if (currentTime == (nextTime = time[i - 1])) continue;
            float f = isDataDifferential ? -dataPoints[i - 1] : dataPoints[i] - dataPoints[i - 1];
            float vCurr = f / (currentTime - nextTime);
            float vPrev = Math.signum(work) * (float)Math.sqrt(2.0f * Math.abs(work));
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != start) continue;
            work *= 0.5f;
        }
        return Math.signum(work) * (float)Math.sqrt(2.0f * Math.abs(work));
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        float f;
        return Math.signum(kineticEnergy) * (float)Math.sqrt(2.0f * Math.abs(f));
    }

    /*
     * WARNING - void declaration
     */
    private static final float dot(float[] $this$dot, float[] a) {
        void var2_2;
        float result2 = 0.0f;
        int n = $this$dot.length;
        for (int i = 0; i < n; ++i) {
            result2 += $this$dot[i] * a[i];
        }
        return (float)var2_2;
    }

    private static final float norm(float[] $this$norm) {
        return (float)Math.sqrt(VelocityTrackerKt.dot($this$norm, $this$norm));
    }

    private static final float[][] Matrix(int rows, int cols) {
        int n = 0;
        float[][] fArrayArray = new float[rows][];
        while (n < rows) {
            int n2 = n++;
            fArrayArray[n2] = new float[cols];
        }
        return fArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final float get(float[][] $this$get, int row, int col) {
        void var2_2;
        void var1_1;
        float[][] fArray;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        return fArray[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    private static final void set(float[][] $this$set, int row, int col, float value) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        var0[var1_1][var2_2] = var3_3;
    }

    @ExperimentalComposeUiApi
    public static final boolean getVelocityTrackerAddPointsFix() {
        return VelocityTrackerAddPointsFix;
    }

    @ExperimentalComposeUiApi
    public static final void setVelocityTrackerAddPointsFix(boolean bl) {
        VelocityTrackerAddPointsFix = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerAddPointsFix$annotations() {
    }

    @ExperimentalComposeUiApi
    public static final boolean getVelocityTrackerStrategyUseImpulse() {
        return VelocityTrackerStrategyUseImpulse;
    }

    @ExperimentalComposeUiApi
    public static final void setVelocityTrackerStrategyUseImpulse(boolean bl) {
        VelocityTrackerStrategyUseImpulse = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getVelocityTrackerStrategyUseImpulse$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index, long time, float dataPoint) {
        void var2_2;
        void var1_1;
        VelocityTrackerKt.set($receiver, (int)var1_1, (long)var2_2, dataPoint);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ float access$calculateImpulseVelocity(float[] dataPoints, float[] time, int sampleCount, boolean isDataDifferential) {
        void var3_3;
        void var2_2;
        void var1_1;
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, (float[])var1_1, (int)var2_2, (boolean)var3_3);
    }
}

