/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import androidx.compose.ui.input.pointer.util.VelocityTracker_notMobileKt;
import androidx.compose.ui.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "", "isDataDifferential", "", "(Z)V", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "(ZLandroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;)V", "index", "", "()Z", "minSampleSize", "reusableDataPointsArray", "", "reusableTimeArray", "reusableVelocityCoefficients", "samples", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "[Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "addDataPoint", "", "timeMillis", "", "dataPoint", "", "calculateLeastSquaresVelocity", "dataPoints", "time", "sampleCount", "calculateVelocity", "maximumVelocity", "resetTracking", "Strategy", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTracker1D\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,756:1\n42#2,7:757\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTracker1D\n*L\n305#1:757,7\n*E\n"})
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    private final Strategy strategy;
    private final int minSampleSize;
    private final DataPointAtTime[] samples;
    private int index;
    private final float[] reusableDataPointsArray;
    private final float[] reusableTimeArray;
    private final float[] reusableVelocityCoefficients;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public VelocityTracker1D(boolean isDataDifferential, Strategy strategy) {
        int n;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.isDataDifferential = var1_1;
        this.strategy = var2_2;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minSampleSize = n;
        this.samples = new DataPointAtTime[20];
        this.reusableDataPointsArray = new float[20];
        this.reusableTimeArray = new float[20];
        this.reusableVelocityCoefficients = new float[3];
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            strategy = Strategy.Lsq2;
        }
        this(bl, strategy);
    }

    public final boolean isDataDifferential() {
        return this.isDataDifferential;
    }

    /*
     * WARNING - void declaration
     */
    public VelocityTracker1D(boolean isDataDifferential) {
        this((boolean)var1_1, Strategy.Impulse);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void addDataPoint(long timeMillis, float dataPoint) {
        void var3_2;
        void var1_1;
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, (long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final float calculateVelocity() {
        float[] dataPoints = this.reusableDataPointsArray;
        float[] time = this.reusableTimeArray;
        int sampleCount = 0;
        int index = this.index;
        DataPointAtTime dataPointAtTime = this.samples[index];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime newestSample = dataPointAtTime;
        DataPointAtTime previousSample = dataPointAtTime;
        boolean afterPointerStop = false;
        while (this.samples[index] != null) {
            DataPointAtTime sample;
            float age = newestSample.getTime() - sample.getTime();
            float delta = Math.abs(sample.getTime() - previousSample.getTime());
            DataPointAtTime dataPointAtTime2 = previousSample = this.strategy == Strategy.Lsq2 || this.isDataDifferential ? sample : newestSample;
            if (delta > 40.0f) {
                afterPointerStop = true;
                break;
            }
            if (age > 100.0f) break;
            dataPoints[sampleCount] = sample.getDataPoint();
            time[sampleCount] = -age;
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= this.minSampleSize && VelocityTracker_notMobileKt.shouldUseDataPoints(this, dataPoints, time, sampleCount, afterPointerStop)) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1: {
                    f = VelocityTrackerKt.access$calculateImpulseVelocity(dataPoints, time, sampleCount, this.isDataDifferential);
                    break;
                }
                case 2: {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    f = this.calculateLeastSquaresVelocity((float[])var1_1, (float[])var2_2, (int)var3_3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return f * 1000.0f;
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public final float calculateVelocity(float maximumVelocity) {
        void var1_1;
        void var2_3;
        float velocity;
        boolean bl = maximumVelocity > 0.0f;
        if (!bl) {
            InlineClassHelperKt.throwIllegalStateException("maximumVelocity should be a positive value. You specified=" + maximumVelocity);
        }
        if ((velocity = this.calculateVelocity()) == 0.0f || Float.isNaN(velocity)) {
            return 0.0f;
        }
        if (velocity > 0.0f) {
            return RangesKt.coerceAtMost((float)velocity, (float)maximumVelocity);
        }
        return RangesKt.coerceAtLeast((float)var2_3, (float)(-var1_1));
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
        this.index = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final float calculateLeastSquaresVelocity(float[] dataPoints, float[] time, int sampleCount) {
        float f;
        try {
            void var3_4;
            void var1_1;
            f = VelocityTrackerKt.polyFitLeastSquares(time, (float[])var1_1, (int)var3_4, 2, this.reusableVelocityCoefficients)[1];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            f = 0.0f;
        }
        return f;
    }

    public VelocityTracker1D() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "", "(Ljava/lang/String;I)V", "Lsq2", "Impulse", "ui"})
    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private Strategy() {
            void var2_2;
            void var1_1;
        }

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String value) {
            String string;
            return Enum.valueOf(Strategy.class, string);
        }

        public static EnumEntries<Strategy> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ Strategy[] $values() {
            Strategy[] strategyArray = new Strategy[2];
            Strategy[] strategyArray2 = strategyArray;
            strategyArray[0] = Lsq2;
            strategyArray2[1] = Impulse;
            return strategyArray2;
        }

        static {
            $VALUES = Strategy.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

