/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.draw.PainterNode;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.DrawModifierNodeKt;
import androidx.compose.ui.node.LayoutModifierNodeKt;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\t\u0010 \u001a\u00020\fH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003JG\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001J\b\u0010#\u001a\u00020\u0002H\u0016J\u0013\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0002H\u0016J\f\u0010.\u001a\u00020,*\u00020/H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Landroidx/compose/ui/draw/PainterElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/ui/draw/PainterNode;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "sizeToIntrinsics", "", "alignment", "Landroidx/compose/ui/Alignment;", "contentScale", "Landroidx/compose/ui/layout/ContentScale;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "(Landroidx/compose/ui/graphics/painter/Painter;ZLandroidx/compose/ui/Alignment;Landroidx/compose/ui/layout/ContentScale;FLandroidx/compose/ui/graphics/ColorFilter;)V", "getAlignment", "()Landroidx/compose/ui/Alignment;", "getAlpha", "()F", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "getContentScale", "()Landroidx/compose/ui/layout/ContentScale;", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "getSizeToIntrinsics", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "create", "equals", "other", "", "hashCode", "", "toString", "", "update", "", "node", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "ui"})
final class PainterElement
extends ModifierNodeElement<PainterNode> {
    private final Painter painter;
    private final boolean sizeToIntrinsics;
    private final Alignment alignment;
    private final ContentScale contentScale;
    private final float alpha;
    private final ColorFilter colorFilter;

    /*
     * WARNING - void declaration
     */
    public PainterElement(Painter painter, boolean sizeToIntrinsics, Alignment alignment, ContentScale contentScale, float alpha, ColorFilter colorFilter) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        this.painter = var1_1;
        this.sizeToIntrinsics = var2_2;
        this.alignment = var3_3;
        this.contentScale = contentScale;
        this.alpha = alpha;
        this.colorFilter = colorFilter;
    }

    public final Painter getPainter() {
        return this.painter;
    }

    public final boolean getSizeToIntrinsics() {
        return this.sizeToIntrinsics;
    }

    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final ContentScale getContentScale() {
        return this.contentScale;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    @Override
    public final PainterNode create() {
        return new PainterNode(this.painter, this.sizeToIntrinsics, this.alignment, this.contentScale, this.alpha, this.colorFilter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void update(PainterNode node) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean intrinsicsChanged = node.getSizeToIntrinsics() != this.sizeToIntrinsics || this.sizeToIntrinsics && !Size.equals-impl0((long)node.getPainter().getIntrinsicSize-NH-jbRc(), (long)this.painter.getIntrinsicSize-NH-jbRc());
        node.setPainter(this.painter);
        node.setSizeToIntrinsics(this.sizeToIntrinsics);
        node.setAlignment(this.alignment);
        node.setContentScale(this.contentScale);
        node.setAlpha(this.alpha);
        node.setColorFilter(this.colorFilter);
        if (var2_2 != false) {
            LayoutModifierNodeKt.invalidateMeasurement(node);
        }
        DrawModifierNodeKt.invalidateDraw((DrawModifierNode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void inspectableProperties(InspectorInfo $this$inspectableProperties) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
        $this$inspectableProperties.setName("paint");
        $this$inspectableProperties.getProperties().set("painter", this.painter);
        $this$inspectableProperties.getProperties().set("sizeToIntrinsics", this.sizeToIntrinsics);
        $this$inspectableProperties.getProperties().set("alignment", this.alignment);
        $this$inspectableProperties.getProperties().set("contentScale", this.contentScale);
        $this$inspectableProperties.getProperties().set("alpha", Float.valueOf(this.alpha));
        var1_1.getProperties().set("colorFilter", this.colorFilter);
    }

    public final Painter component1() {
        return this.painter;
    }

    public final boolean component2() {
        return this.sizeToIntrinsics;
    }

    public final Alignment component3() {
        return this.alignment;
    }

    public final ContentScale component4() {
        return this.contentScale;
    }

    public final float component5() {
        return this.alpha;
    }

    public final ColorFilter component6() {
        return this.colorFilter;
    }

    /*
     * WARNING - void declaration
     */
    public final PainterElement copy(Painter painter, boolean sizeToIntrinsics, Alignment alignment, ContentScale contentScale, float alpha, ColorFilter colorFilter) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        return new PainterElement((Painter)var1_1, (boolean)var2_2, (Alignment)var3_3, contentScale, alpha, colorFilter);
    }

    public static /* synthetic */ PainterElement copy$default(PainterElement painterElement, Painter painter, boolean bl, Alignment alignment, ContentScale contentScale, float f, ColorFilter colorFilter, int n, Object object) {
        if ((n & 1) != 0) {
            painter = painterElement.painter;
        }
        if ((n & 2) != 0) {
            bl = painterElement.sizeToIntrinsics;
        }
        if ((n & 4) != 0) {
            alignment = painterElement.alignment;
        }
        if ((n & 8) != 0) {
            contentScale = painterElement.contentScale;
        }
        if ((n & 0x10) != 0) {
            f = painterElement.alpha;
        }
        if ((n & 0x20) != 0) {
            colorFilter = painterElement.colorFilter;
        }
        return painterElement.copy(painter, bl, alignment, contentScale, f, colorFilter);
    }

    public final String toString() {
        return "PainterElement(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", contentScale=" + this.contentScale + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ')';
    }

    @Override
    public final int hashCode() {
        int n = this.painter.hashCode();
        n = n * 31 + Boolean.hashCode(this.sizeToIntrinsics);
        n = n * 31 + this.alignment.hashCode();
        n = n * 31 + this.contentScale.hashCode();
        n = n * 31 + Float.hashCode(this.alpha);
        n = n * 31 + (this.colorFilter == null ? 0 : this.colorFilter.hashCode());
        return n;
    }

    @Override
    public final boolean equals(Object other) {
        PainterElement painterElement;
        if (this == other) {
            return true;
        }
        if (!(other instanceof PainterElement)) {
            return false;
        }
        painterElement = painterElement;
        if (!Intrinsics.areEqual((Object)this.painter, (Object)painterElement.painter)) {
            return false;
        }
        if (this.sizeToIntrinsics != painterElement.sizeToIntrinsics) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alignment, (Object)painterElement.alignment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentScale, (Object)painterElement.contentScale)) {
            return false;
        }
        if (Float.compare(this.alpha, painterElement.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorFilter, (Object)painterElement.colorFilter);
    }
}

