/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.awt.RenderSettings;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.scene.ComposeContainer;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayerAnalytics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0012\u0010-\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\tH\u0002J\b\u00101\u001a\u00020\fH\u0007J\b\u00102\u001a\u00020\u001bH\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020\u001bH\u0016J\b\u00106\u001a\u00020\u001bH\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u0010,\u001a\u00020+H\u0016J\u0012\u00108\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u00109\u001a\u00020\fH\u0016J\b\u0010:\u001a\u00020\fH\u0016J\u0012\u0010:\u001a\u00020\f2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u0016J\b\u0010>\u001a\u00020\u001bH\u0016J\u0012\u0010>\u001a\u00020\u001b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J(\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020AH\u0016J\u0012\u0010E\u001a\u00020\f2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u001e\u0010H\u001a\u00020\f2\u0011\u0010I\u001a\r\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010JJ\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020\u001bH\u0016J\u0010\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u001bH\u0016J\u0012\u0010O\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010PH\u0016J\u0010\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\u001bH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001a\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010$\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0002\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006S"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "renderSettings", "Landroidx/compose/ui/awt/RenderSettings;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;Landroidx/compose/ui/awt/RenderSettings;)V", "_composeContainer", "Landroidx/compose/ui/scene/ComposeContainer;", "_composeContent", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "_focusListeners", "", "Ljava/awt/event/FocusListener;", "value", "Landroidx/compose/ui/window/WindowExceptionHandler;", "exceptionHandler", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "isDisposeOnRemove", "", "isDisposeOnRemove$annotations", "()Z", "setDisposeOnRemove", "(Z)V", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "windowContainer", "getWindowContainer$annotations", "getWindowContainer", "()Ljavax/swing/JLayeredPane;", "setWindowContainer", "(Ljavax/swing/JLayeredPane;)V", "add", "Ljava/awt/Component;", "component", "addFocusListener", "l", "addNotify", "createComposeContainer", "dispose", "getFocusTraversalKeysEnabled", "getPreferredSize", "Ljava/awt/Dimension;", "hasFocus", "isFocusOwner", "remove", "removeFocusListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "temporary", "requestFocusInWindow", "setBounds", "x", "", "y", "width", "height", "setComponentOrientation", "o", "Ljava/awt/ComponentOrientation;", "setContent", "content", "(Lkotlin/jvm/functions/Function2;)V", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "setLocale", "Ljava/util/Locale;", "setRequestFocusEnabled", "requestFocusEnabled", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposePanel.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1855#2,2:314\n*S KotlinDebug\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n*L\n209#1:314,2\n*E\n"})
public final class ComposePanel
extends JLayeredPane {
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    private final RenderSettings renderSettings;
    private final Set<FocusListener> _focusListeners;
    private ComposeContainer _composeContainer;
    private Function2<? super Composer, ? super Integer, Unit> _composeContent;
    private boolean isDisposeOnRemove;
    private WindowExceptionHandler exceptionHandler;
    private JLayeredPane windowContainer;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @ExperimentalComposeUiApi
    public ComposePanel(SkiaLayerAnalytics skiaLayerAnalytics, RenderSettings renderSettings) {
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"skiaLayerAnalytics");
        Intrinsics.checkNotNullParameter((Object)renderSettings, (String)"renderSettings");
        this.skiaLayerAnalytics = string;
        this.renderSettings = var2_2;
        if (!SwingUtilities.isEventDispatchThread()) {
            string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(this){
            final /* synthetic */ ComposePanel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Component getComponentAfter(Container aContainer, Component aComponent) {
                void var1_1;
                Container ancestor = this.this$0.getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = ancestor.getFocusTraversalPolicy();
                return focusTraversalPolicy.getComponentAfter((Container)var1_1, this.this$0);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Component getComponentBefore(Container aContainer, Component aComponent) {
                void var1_1;
                Container ancestor = this.this$0.getFocusCycleRootAncestor();
                FocusTraversalPolicy focusTraversalPolicy = ancestor.getFocusTraversalPolicy();
                return focusTraversalPolicy.getComponentBefore((Container)var1_1, this.this$0);
            }

            public final Void getFirstComponent(Container aContainer) {
                return null;
            }

            public final Void getLastComponent(Container aContainer) {
                return null;
            }

            public final Void getDefaultComponent(Container aContainer) {
                return null;
            }
        });
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        this._focusListeners = new LinkedHashSet();
        this.isDisposeOnRemove = true;
        this.windowContainer = this;
    }

    public /* synthetic */ ComposePanel(SkiaLayerAnalytics skiaLayerAnalytics, RenderSettings renderSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            renderSettings = RenderSettings.Companion.getDefault();
        }
        this(skiaLayerAnalytics, renderSettings);
    }

    public ComposePanel() {
        this(SkiaLayerAnalytics.Companion.getEmpty(), RenderSettings.Companion.getDefault());
    }

    public final boolean isDisposeOnRemove() {
        return this.isDisposeOnRemove;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDisposeOnRemove(boolean bl) {
        void var1_1;
        this.isDisposeOnRemove = var1_1;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void isDisposeOnRemove$annotations() {
    }

    @ExperimentalComposeUiApi
    public final void dispose() {
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.dispose();
        }
        this._composeContainer = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setBounds(int x, int y, int width, int height) {
        void var2_2;
        void var1_1;
        super.setBounds((int)var1_1, (int)var2_2, width, height);
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            void var3_3;
            composeContainer.setBounds(0, 0, (int)var3_3, height);
            return;
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            return composeContainer.getPreferredSize();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public final void setContent(Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this._composeContent = content;
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            void var1_1;
            composeContainer.setContent((Function2<? super Composer, ? super Integer, Unit>)var1_1);
            return;
        }
    }

    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void setExceptionHandler(WindowExceptionHandler value) {
        void var1_1;
        this.exceptionHandler = value;
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer == null) {
            return;
        }
        composeContainer.setExceptionHandler((WindowExceptionHandler)var1_1);
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getExceptionHandler$annotations() {
    }

    public final JLayeredPane getWindowContainer() {
        return this.windowContainer;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWindowContainer(JLayeredPane value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.windowContainer = value;
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer == null) {
            return;
        }
        composeContainer.setWindowContainer((JLayeredPane)var1_1);
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getWindowContainer$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Component add(Component component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Component component2 = super.add((Component)var1_1);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"add(...)");
        return component2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void remove(Component component) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super.remove((Component)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addNotify() {
        ComposeContainer composeContainer;
        super.addNotify();
        ComposeContainer composeContainer2 = this._composeContainer;
        if (composeContainer2 == null) {
            ComposeContainer it;
            this._composeContainer = it = (composeContainer = this.createComposeContainer());
            Function2<? super Composer, ? super Integer, Unit> composeContent = this._composeContent;
            if (composeContent != null) {
                void var3_3;
                void var2_2;
                var2_2.setContent((Function2<? super Composer, ? super Integer, Unit>)var3_3);
            }
            composeContainer2 = composeContainer;
        }
        composeContainer = composeContainer2;
        composeContainer2.addNotify();
    }

    /*
     * WARNING - void declaration
     */
    private final ComposeContainer createComposeContainer() {
        void var2_2;
        ComposeContainer composeContainer;
        ComposeContainer $this$createComposeContainer_u24lambda_u242 = composeContainer = new ComposeContainer(this, this.skiaLayerAnalytics, null, this.windowContainer, false, null, this.renderSettings, 52, null);
        composeContainer.setBounds(0, 0, this.getWidth(), this.getHeight());
        $this$createComposeContainer_u24lambda_u242.getContentComponent().setFocusable(this.isFocusable());
        $this$createComposeContainer_u24lambda_u242.getContentComponent().setRequestFocusEnabled(this.isRequestFocusEnabled());
        $this$createComposeContainer_u24lambda_u242.setExceptionHandler(this.exceptionHandler);
        Object object = this._focusListeners;
        JComponent jComponent = $this$createComposeContainer_u24lambda_u242.getContentComponent();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            FocusListener p0 = (FocusListener)e;
            jComponent.addFocusListener(p0);
        }
        $this$createComposeContainer_u24lambda_u242.getContentComponent().addFocusListener(new FocusListener(this, (ComposeContainer)var2_2){
            final /* synthetic */ ComposePanel this$0;
            final /* synthetic */ ComposeContainer $this_apply;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$this_apply = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!e.isTemporary() && !SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(e, this.this$0)) {
                    void var1_1;
                    FocusEvent.Cause cause = var1_1.getCause();
                    switch (cause == null ? -1 : createComposeContainer.1.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (this.$this_apply.getFocusManager().getHasFocus()) break;
                            this.$this_apply.getFocusManager().takeFocus-3ESFkO8(FocusDirection.Companion.getNext-dhqQ-8s());
                        }
                    }
                }
            }

            public final void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
        return composeContainer;
    }

    @Override
    public final void removeNotify() {
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.removeNotify();
        }
        if (this.isDisposeOnRemove) {
            this.dispose();
        }
        super.removeNotify();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setComponentOrientation(ComponentOrientation o) {
        void var1_1;
        super.setComponentOrientation((ComponentOrientation)var1_1);
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.onLayoutDirectionChanged(this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLocale(Locale l) {
        void var1_1;
        super.setLocale((Locale)var1_1);
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.onLayoutDirectionChanged(this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addFocusListener(FocusListener l) {
        void var1_1;
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            ((Component)object).addFocusListener(l);
        }
        this._focusListeners.add((FocusListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void removeFocusListener(FocusListener l) {
        void var1_1;
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            ((Component)object).removeFocusListener(l);
        }
        this._focusListeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setFocusable(boolean focusable) {
        void var1_1;
        super.setFocusable(focusable);
        ComposeContainer composeContainer = this._composeContainer;
        JComponent jComponent = composeContainer != null ? composeContainer.getContentComponent() : null;
        if (jComponent == null) {
            return;
        }
        jComponent.setFocusable((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setRequestFocusEnabled(boolean requestFocusEnabled) {
        void var1_1;
        super.setRequestFocusEnabled(requestFocusEnabled);
        ComposeContainer composeContainer = this._composeContainer;
        JComponent jComponent = composeContainer != null ? composeContainer.getContentComponent() : null;
        if (jComponent == null) {
            return;
        }
        jComponent.setRequestFocusEnabled((boolean)var1_1);
    }

    @Override
    public final boolean hasFocus() {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            return ((Component)object).hasFocus();
        }
        return false;
    }

    @Override
    public final boolean isFocusOwner() {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            return ((Component)object).isFocusOwner();
        }
        return false;
    }

    @Override
    public final void requestFocus() {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            ((JComponent)object).requestFocus();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean requestFocus(boolean temporary) {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            void var1_1;
            return ((JComponent)object).requestFocus((boolean)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void requestFocus(FocusEvent.Cause cause) {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            void var1_1;
            ((Component)object).requestFocus((FocusEvent.Cause)var1_1);
            return;
        }
    }

    @Override
    public final boolean requestFocusInWindow() {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            return ((JComponent)object).requestFocusInWindow();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean requestFocusInWindow(FocusEvent.Cause cause) {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            void var1_1;
            return ((Component)object).requestFocusInWindow((FocusEvent.Cause)var1_1);
        }
        return false;
    }

    @Override
    public final void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
    }

    @Override
    public final boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public final GraphicsApi getRenderApi() {
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer == null || (composeContainer = composeContainer.getRenderApi()) == null) {
            composeContainer = GraphicsApi.UNKNOWN;
        }
        return composeContainer;
    }
}

