/*
 * Decompiled with CFR 0.152.
 */
package androidx.arch.core.internal;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class SafeIterableMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    Entry<K, V> mStart;
    private Entry<K, V> mEnd;
    private final WeakHashMap<SupportRemove<K, V>, Boolean> mIterators = new WeakHashMap();
    private int mSize = 0;

    public final int size() {
        return this.mSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        void var1_1;
        AscendingIterator<K, V> iterator = new AscendingIterator<K, V>(this.mStart, this.mEnd);
        this.mIterators.put(iterator, Boolean.FALSE);
        return var1_1;
    }

    public final Map.Entry<K, V> eldest$25e7c4bc() {
        return this.mStart;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeIterableMap)) {
            return false;
        }
        SafeIterableMap map = (SafeIterableMap)obj;
        SafeIterableMap safeIterableMap = this;
        SafeIterableMap safeIterableMap2 = safeIterableMap;
        safeIterableMap2 = map;
        if (safeIterableMap.mSize != safeIterableMap2.mSize) {
            return false;
        }
        Iterator<Map.Entry<K, V>> iterator1 = this.iterator();
        Iterator<Map.Entry<K, V>> iterator2 = map.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            void var3_3;
            Map.Entry<K, V> next1 = iterator1.next();
            Map.Entry<K, V> next2 = iterator2.next();
            if ((next1 != null || next2 == null) && (next1 == null || var3_3.equals(next2))) continue;
            return false;
        }
        return !safeIterableMap2.hasNext() && !var1_1.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int h = 0;
        for (Map.Entry<K, V> kvEntry : this) {
            void var3_3;
            h += var3_3.hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return var1_1.toString();
    }

    static final class Entry<K, V>
    implements Map.Entry<K, V> {
        @Override
        public final K getKey() {
            Entry entry = this;
            throw null;
        }

        @Override
        public final V getValue() {
            Entry entry = this;
            throw null;
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException("An entry modification is not supported");
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Entry entry = this;
            throw null;
        }

        @Override
        public final boolean equals(Object obj) {
            Entry entry;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            entry = entry;
            Entry entry2 = this;
            throw null;
        }

        @Override
        public final int hashCode() {
            Entry entry = this;
            throw null;
        }
    }

    public static abstract class SupportRemove<K, V> {
    }

    static final class AscendingIterator<K, V>
    extends ListIterator<K, V> {
        /*
         * WARNING - void declaration
         */
        AscendingIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        final Entry<K, V> forward(Entry<K, V> entry) {
            Entry<K, V> entry2 = entry;
            throw null;
        }
    }

    private static abstract class ListIterator<K, V>
    extends SupportRemove<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private Entry<K, V> mExpectedEnd;
        private Entry<K, V> mNext;

        /*
         * WARNING - void declaration
         */
        ListIterator(Entry<K, V> start, Entry<K, V> expectedEnd) {
            void var1_1;
            void var2_2;
            this.mExpectedEnd = var2_2;
            this.mNext = var1_1;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        abstract Entry<K, V> forward(Entry<K, V> var1);
    }
}

