/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;

@SourceDebugExtension(value={"SMAP\nmodifierChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 modifierChecks.kt\norg/jetbrains/kotlin/util/NoDefaultAndVarargsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,264:1\n1734#2,3:265\n*S KotlinDebug\n*F\n+ 1 modifierChecks.kt\norg/jetbrains/kotlin/util/NoDefaultAndVarargsCheck\n*L\n105#1:265,3\n*E\n"})
final class NoDefaultAndVarargsCheck
implements Check {
    public static final NoDefaultAndVarargsCheck INSTANCE = new NoDefaultAndVarargsCheck();
    private static final String description = "should not have varargs or parameters with default values";

    private NoDefaultAndVarargsCheck() {
    }

    @Override
    public final String getDescription() {
        return description;
    }

    @Override
    public final boolean check(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        List<ValueParameterDescriptor> list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterable $this$all$iv = list;
        if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) {
            Iterator iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ValueParameterDescriptor it = (ValueParameterDescriptor)t;
                Intrinsics.checkNotNull((Object)it);
                if (!DescriptorUtilsKt.declaresOrInheritsDefaultValue(it) && t.getVarargElementType() == null) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String invoke(FunctionDescriptor functionDescriptor) {
        void var1_1;
        return Check.DefaultImpls.invoke(this, (FunctionDescriptor)var1_1);
    }
}

