/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.FilteredAnnotations;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.DisjointKeysUnionTypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IndexedParametersSubstitution;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilitiesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancement;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import kotlin.reflect.jvm.internal.impl.utils.ExceptionUtilsKt;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    private final TypeSubstitution substitution;

    public static TypeSubstitutor create(TypeSubstitution substitution) {
        TypeSubstitution typeSubstitution;
        if (substitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(0);
        }
        return new TypeSubstitutor(typeSubstitution);
    }

    public TypeSubstitutor replaceWithNonApproximatingSubstitution() {
        if (!(this.substitution instanceof IndexedParametersSubstitution) || !this.substitution.approximateContravariantCapturedTypes()) {
            return this;
        }
        return new TypeSubstitutor(new IndexedParametersSubstitution(((IndexedParametersSubstitution)this.substitution).getParameters(), ((IndexedParametersSubstitution)this.substitution).getArguments(), false));
    }

    /*
     * WARNING - void declaration
     */
    public static TypeSubstitutor createChainedSubstitutor(TypeSubstitution first, TypeSubstitution second) {
        void var1_1;
        TypeSubstitution typeSubstitution;
        if (first == null) {
            TypeSubstitutor.$$$reportNull$$$0(3);
        }
        if (second == null) {
            TypeSubstitutor.$$$reportNull$$$0(4);
        }
        return TypeSubstitutor.create(DisjointKeysUnionTypeSubstitution.create(typeSubstitution, (TypeSubstitution)var1_1));
    }

    public static TypeSubstitutor create(KotlinType context) {
        KotlinType kotlinType;
        if (context == null) {
            TypeSubstitutor.$$$reportNull$$$0(6);
        }
        return TypeSubstitutor.create(TypeConstructorSubstitution.create(context.getConstructor(), kotlinType.getArguments()));
    }

    /*
     * WARNING - void declaration
     */
    protected TypeSubstitutor(TypeSubstitution substitution) {
        void var1_1;
        if (substitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(7);
        }
        this.substitution = var1_1;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            TypeSubstitutor.$$$reportNull$$$0(8);
        }
        return typeSubstitution;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinType safeSubstitute(KotlinType type, Variance howThisTypeIsUsed) {
        KotlinType kotlinType;
        if (type == null) {
            TypeSubstitutor.$$$reportNull$$$0(9);
        }
        if (howThisTypeIsUsed == null) {
            TypeSubstitutor.$$$reportNull$$$0(10);
        }
        if (this.isEmpty()) {
            KotlinType kotlinType2 = type;
            if (kotlinType2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(11);
            }
            return kotlinType2;
        }
        try {
            void var2_3;
            kotlinType = this.unsafeSubstitute(new TypeProjectionImpl((Variance)var2_3, type), null, 0).getType();
        }
        catch (SubstitutionException e) {
            void var1_2;
            ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, var1_2.getMessage());
            if (errorType == null) {
                TypeSubstitutor.$$$reportNull$$$0(13);
            }
            return errorType;
        }
        if (kotlinType == null) {
            TypeSubstitutor.$$$reportNull$$$0(12);
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    public KotlinType substitute(KotlinType type, Variance howThisTypeIsUsed) {
        void var1_1;
        void var2_2;
        TypeProjection projection;
        if (type == null) {
            TypeSubstitutor.$$$reportNull$$$0(14);
        }
        if (howThisTypeIsUsed == null) {
            TypeSubstitutor.$$$reportNull$$$0(15);
        }
        if ((projection = this.substitute(new TypeProjectionImpl(howThisTypeIsUsed, this.getSubstitution().prepareTopLevelType(type, (Variance)var2_2)))) == null) {
            return null;
        }
        return var1_1.getType();
    }

    /*
     * WARNING - void declaration
     */
    public TypeProjection substitute(TypeProjection typeProjection) {
        void var1_1;
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(16);
        }
        TypeProjection substitutedTypeProjection = this.substituteWithoutApproximation(typeProjection);
        if (!this.substitution.approximateCapturedTypes() && !this.substitution.approximateContravariantCapturedTypes()) {
            return substitutedTypeProjection;
        }
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary((TypeProjection)var1_1, this.substitution.approximateContravariantCapturedTypes());
    }

    /*
     * WARNING - void declaration
     */
    public TypeProjection substituteWithoutApproximation(TypeProjection typeProjection) {
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(17);
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            void var1_1;
            return this.unsafeSubstitute((TypeProjection)var1_1, null, 0);
        }
        catch (SubstitutionException substitutionException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private TypeProjection unsafeSubstitute(TypeProjection originalProjection, TypeParameterDescriptor typeParameter, int recursionDepth) throws SubstitutionException {
        void var3_3;
        void var1_1;
        UnwrappedType substitutedFlexibleType;
        if (originalProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(18);
        }
        TypeSubstitutor.assertRecursionDepth(recursionDepth, originalProjection, this.substitution);
        if (originalProjection.isStarProjection()) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(19);
            }
            return typeProjection;
        }
        KotlinType type = originalProjection.getType();
        if (type instanceof TypeWithEnhancement) {
            UnwrappedType origin = ((TypeWithEnhancement)((Object)type)).getOrigin();
            KotlinType enhancement = ((TypeWithEnhancement)((Object)type)).getEnhancement();
            TypeProjection substitution = this.unsafeSubstitute(new TypeProjectionImpl(originalProjection.getProjectionKind(), origin), typeParameter, recursionDepth + 1);
            if (substitution.isStarProjection()) {
                TypeProjection typeProjection = substitution;
                if (typeProjection == null) {
                    TypeSubstitutor.$$$reportNull$$$0(20);
                }
                return typeProjection;
            }
            KotlinType substitutedEnhancement = this.substitute(enhancement, originalProjection.getProjectionKind());
            UnwrappedType resultingType = TypeWithEnhancementKt.wrapEnhancement(substitution.getType().unwrap(), substitutedEnhancement);
            return new TypeProjectionImpl(substitution.getProjectionKind(), resultingType);
        }
        if (DynamicTypesKt.isDynamic(type) || type.unwrap() instanceof RawType) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(21);
            }
            return typeProjection;
        }
        TypeProjection substituted = this.substitution.get(type);
        TypeProjection replacement = substituted != null ? TypeSubstitutor.projectedTypeForConflictedTypeWithUnsafeVariance(type, substituted, typeParameter, originalProjection) : null;
        Variance originalProjectionKind = originalProjection.getProjectionKind();
        if (replacement == null && FlexibleTypesKt.isFlexible(type) && !TypeCapabilitiesKt.isCustomTypeParameter(type)) {
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type);
            TypeProjection substitutedLower = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibleType.getLowerBound()), typeParameter, recursionDepth + 1);
            TypeProjection substitutedUpper = this.unsafeSubstitute(new TypeProjectionImpl(originalProjectionKind, flexibleType.getUpperBound()), typeParameter, recursionDepth + 1);
            Variance substitutedProjectionKind = substitutedLower.getProjectionKind();
            assert (substitutedProjectionKind == substitutedUpper.getProjectionKind() && originalProjectionKind == Variance.INVARIANT || originalProjectionKind == substitutedProjectionKind) : "Unexpected substituted projection kind: " + (Object)((Object)substitutedProjectionKind) + "; original: " + (Object)((Object)originalProjectionKind);
            if (substitutedLower.getType() == flexibleType.getLowerBound() && substitutedUpper.getType() == flexibleType.getUpperBound()) {
                TypeProjection typeProjection = originalProjection;
                if (typeProjection == null) {
                    TypeSubstitutor.$$$reportNull$$$0(22);
                }
                return typeProjection;
            }
            substitutedFlexibleType = KotlinTypeFactory.flexibleType(TypeSubstitutionKt.asSimpleType(substitutedLower.getType()), TypeSubstitutionKt.asSimpleType(substitutedUpper.getType()));
            return new TypeProjectionImpl(substitutedProjectionKind, substitutedFlexibleType);
        }
        if (KotlinBuiltIns.isNothing(type) || KotlinTypeKt.isError(type)) {
            void v4 = substitutedFlexibleType;
            if (v4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(23);
            }
            return v4;
        }
        if (replacement != null) {
            void var2_2;
            void var3_5;
            VarianceConflictType varianceConflict = TypeSubstitutor.conflictType(originalProjectionKind, replacement.getProjectionKind());
            boolean bl = CapturedTypeConstructorKt.isCaptured(type);
            if (!bl) {
                switch (varianceConflict) {
                    case OUT_IN_IN_POSITION: {
                        throw new SubstitutionException("Out-projection in in-position");
                    }
                    case IN_IN_OUT_POSITION: {
                        return new TypeProjectionImpl(Variance.OUT_VARIANCE, type.getConstructor().getBuiltIns().getNullableAnyType());
                    }
                }
            }
            CustomTypeParameter customTypeParameter = TypeCapabilitiesKt.getCustomTypeParameter(type);
            if (replacement.isStarProjection()) {
                TypeProjection typeProjection = replacement;
                if (typeProjection == null) {
                    TypeSubstitutor.$$$reportNull$$$0(24);
                }
                return typeProjection;
            }
            KotlinType substitutedType = customTypeParameter != null ? var3_5.substitutionResult(replacement.getType()) : TypeUtils.makeNullableIfNeeded(replacement.getType(), type.isMarkedNullable());
            if (!type.getAnnotations().isEmpty()) {
                Annotations typeAnnotations = TypeSubstitutor.filterOutUnsafeVariance(this.substitution.filterAnnotations(type.getAnnotations()));
                substitutedType = TypeUtilsKt.replaceAnnotations(substitutedType, new CompositeAnnotations(substitutedType.getAnnotations(), typeAnnotations));
            }
            Variance resultingProjectionKind = varianceConflict == VarianceConflictType.NO_CONFLICT ? TypeSubstitutor.combine(originalProjectionKind, replacement.getProjectionKind()) : originalProjectionKind;
            return new TypeProjectionImpl((Variance)var1_1, (KotlinType)var2_2);
        }
        TypeProjection typeProjection = this.substituteCompoundType((TypeProjection)var1_1, (int)var3_3);
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(25);
        }
        return typeProjection;
    }

    /*
     * WARNING - void declaration
     */
    private static TypeProjection projectedTypeForConflictedTypeWithUnsafeVariance(KotlinType originalType, TypeProjection substituted, TypeParameterDescriptor typeParameter, TypeProjection originalProjection) {
        void var1_1;
        VarianceConflictType varianceConflictType;
        VarianceConflictType varianceConflictType2;
        if (originalType == null) {
            TypeSubstitutor.$$$reportNull$$$0(26);
        }
        if (substituted == null) {
            TypeSubstitutor.$$$reportNull$$$0(27);
        }
        if (originalProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(28);
        }
        if (!originalType.getAnnotations().hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
            TypeProjection typeProjection = substituted;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(29);
            }
            return typeProjection;
        }
        TypeProjection constructor = substituted.getType().getConstructor();
        if (!(constructor instanceof NewCapturedTypeConstructor)) {
            TypeProjection typeProjection = substituted;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(30);
            }
            return typeProjection;
        }
        constructor = (NewCapturedTypeConstructor)((Object)constructor);
        TypeProjection capturedTypeProjection = ((NewCapturedTypeConstructor)((Object)constructor)).getProjection();
        Variance varianceOfCapturedType = capturedTypeProjection.getProjectionKind();
        if ((varianceConflictType2 = TypeSubstitutor.conflictType(varianceConflictType2.getProjectionKind(), varianceOfCapturedType)) == VarianceConflictType.OUT_IN_IN_POSITION) {
            return new TypeProjectionImpl(capturedTypeProjection.getType());
        }
        if (typeParameter == null) {
            TypeProjection typeProjection = substituted;
            if (typeProjection == null) {
                TypeSubstitutor.$$$reportNull$$$0(31);
            }
            return typeProjection;
        }
        if ((varianceConflictType = TypeSubstitutor.conflictType(varianceConflictType.getVariance(), varianceOfCapturedType)) == VarianceConflictType.OUT_IN_IN_POSITION) {
            TypeProjection typeProjection;
            return new TypeProjectionImpl(typeProjection.getType());
        }
        void v3 = var1_1;
        if (v3 == null) {
            TypeSubstitutor.$$$reportNull$$$0(32);
        }
        return v3;
    }

    private static Annotations filterOutUnsafeVariance(Annotations annotations) {
        Annotations annotations2;
        if (annotations == null) {
            TypeSubstitutor.$$$reportNull$$$0(33);
        }
        if (!annotations.hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
            Annotations annotations3 = annotations;
            if (annotations3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(34);
            }
            return annotations3;
        }
        return new FilteredAnnotations(annotations2, (Function1<? super FqName, Boolean>)new Function1<FqName, Boolean>(){

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(FqName name) {
                void var1_1;
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !var1_1.equals(StandardNames.FqNames.unsafeVariance);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor$1", "invoke"));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private TypeProjection substituteCompoundType(TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        void var2_3;
        void var3_4;
        List<TypeProjection> substitutedArguments;
        KotlinType substitutedType;
        KotlinType type = originalProjection.getType();
        Variance projectionKind = originalProjection.getProjectionKind();
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return originalProjection;
        }
        KotlinType substitutedAbbreviation = null;
        SimpleType abbreviation = SpecialTypesKt.getAbbreviation(type);
        if (abbreviation != null) {
            TypeSubstitutor typeSubstitutor2 = this.replaceWithNonApproximatingSubstitution();
            substitutedAbbreviation = typeSubstitutor2.substitute(abbreviation, Variance.INVARIANT);
        }
        if ((substitutedType = TypeSubstitutionKt.replace(type, substitutedArguments = this.substituteTypeArguments(type.getConstructor().getParameters(), type.getArguments(), recursionDepth), this.substitution.filterAnnotations(var3_4.getAnnotations()))) instanceof SimpleType && substitutedAbbreviation instanceof SimpleType) {
            void var1_1;
            substitutedType = SpecialTypesKt.withAbbreviation((SimpleType)substitutedType, (SimpleType)var1_1);
        }
        return new TypeProjectionImpl(projectionKind, (KotlinType)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> typeParameters, List<TypeProjection> typeArguments, int recursionDepth) throws SubstitutionException {
        ArrayList<TypeProjection> substitutedArguments = new ArrayList<TypeProjection>(typeParameters.size());
        boolean wereChanges = false;
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            TypeProjection typeArgument = typeArguments.get(i);
            TypeProjection substitutedTypeArgument = this.unsafeSubstitute(typeArgument, typeParameter, recursionDepth + 1);
            switch (TypeSubstitutor.conflictType(typeParameter.getVariance(), substitutedTypeArgument.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameter.getVariance() == Variance.INVARIANT || substitutedTypeArgument.isStarProjection()) break;
                    substitutedTypeArgument = new TypeProjectionImpl(Variance.INVARIANT, substitutedTypeArgument.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    substitutedTypeArgument = TypeUtils.makeStarProjection(typeParameter);
                }
            }
            if (substitutedTypeArgument != typeArgument) {
                wereChanges = true;
            }
            substitutedArguments.add(substitutedTypeArgument);
        }
        if (!wereChanges) {
            void var2_2;
            return var2_2;
        }
        return substitutedArguments;
    }

    /*
     * WARNING - void declaration
     */
    public static Variance combine(Variance typeParameterVariance, TypeProjection typeProjection) {
        void var1_1;
        Variance variance;
        if (typeParameterVariance == null) {
            TypeSubstitutor.$$$reportNull$$$0(35);
        }
        if (typeProjection == null) {
            TypeSubstitutor.$$$reportNull$$$0(36);
        }
        if (typeProjection.isStarProjection()) {
            Variance variance2 = Variance.OUT_VARIANCE;
            if (variance2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(37);
            }
            return variance2;
        }
        return TypeSubstitutor.combine(variance, var1_1.getProjectionKind());
    }

    /*
     * WARNING - void declaration
     */
    public static Variance combine(Variance typeParameterVariance, Variance projectionKind) {
        void var1_1;
        Variance variance;
        if (typeParameterVariance == null) {
            TypeSubstitutor.$$$reportNull$$$0(38);
        }
        if (projectionKind == null) {
            TypeSubstitutor.$$$reportNull$$$0(39);
        }
        if (typeParameterVariance == Variance.INVARIANT) {
            Variance variance2 = projectionKind;
            if (variance2 == null) {
                TypeSubstitutor.$$$reportNull$$$0(40);
            }
            return variance2;
        }
        if (projectionKind == Variance.INVARIANT) {
            Variance variance3 = typeParameterVariance;
            if (variance3 == null) {
                TypeSubstitutor.$$$reportNull$$$0(41);
            }
            return variance3;
        }
        if (typeParameterVariance == projectionKind) {
            Variance variance4 = projectionKind;
            if (variance4 == null) {
                TypeSubstitutor.$$$reportNull$$$0(42);
            }
            return variance4;
        }
        throw new AssertionError((Object)("Variance conflict: type parameter variance '" + (Object)((Object)variance) + "' and projection kind '" + var1_1 + "' cannot be combined"));
    }

    /*
     * WARNING - void declaration
     */
    private static VarianceConflictType conflictType(Variance position, Variance argument) {
        void var1_1;
        Variance variance;
        if (position == Variance.IN_VARIANCE && argument == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (variance == Variance.OUT_VARIANCE && var1_1 == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    /*
     * WARNING - void declaration
     */
    private static void assertRecursionDepth(int recursionDepth, TypeProjection projection, TypeSubstitution substitution) {
        if (recursionDepth > 100) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(var1_1) + "; substitution: " + TypeSubstitutor.safeToString(var2_2));
        }
    }

    private static String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (Throwable throwable) {
            Object object;
            Object e = throwable;
            if (ExceptionUtilsKt.isProcessCanceledException(throwable)) {
                throw (RuntimeException)e;
            }
            return "[Exception while computing toString(): " + object + "]";
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "howThisTypeIsUsed";
                break;
            }
            case 16: 
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProjection";
                break;
            }
            case 18: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProjection";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterVariance";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionKind";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/types/TypeSubstitutor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithNonApproximatingSubstitution";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithContravariantApproximatingSubstitution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "safeSubstitute";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unsafeSubstitute";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUnsafeVariance";
                break;
            }
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChainedSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "safeSubstitute";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithoutApproximation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unsafeSubstitute";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "projectedTypeForConflictedTypeWithUnsafeVariance";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUnsafeVariance";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "combine";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public SubstitutionException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }
}

