/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

@SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,860:1\n1#2:861\n*E\n"})
public class TypeCheckerState {
    private final boolean isErrorTypeEqualsToAnything;
    private final boolean isStubTypeEqualsToAnything;
    private final boolean allowedTypeVariable;
    private final TypeSystemContext typeSystemContext;
    private final AbstractTypePreparator kotlinTypePreparator;
    private final AbstractTypeRefiner kotlinTypeRefiner;
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleTypeMarker> supertypesDeque;
    private Set<SimpleTypeMarker> supertypesSet;

    /*
     * WARNING - void declaration
     */
    public TypeCheckerState(boolean isErrorTypeEqualsToAnything, boolean isStubTypeEqualsToAnything, boolean allowedTypeVariable, TypeSystemContext typeSystemContext, AbstractTypePreparator kotlinTypePreparator, AbstractTypeRefiner kotlinTypeRefiner) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)kotlinTypePreparator, (String)"kotlinTypePreparator");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        this.isErrorTypeEqualsToAnything = var1_1;
        this.isStubTypeEqualsToAnything = var2_2;
        this.allowedTypeVariable = var3_3;
        this.typeSystemContext = typeSystemContext;
        this.kotlinTypePreparator = kotlinTypePreparator;
        this.kotlinTypeRefiner = kotlinTypeRefiner;
    }

    public final boolean isErrorTypeEqualsToAnything() {
        return this.isErrorTypeEqualsToAnything;
    }

    public final boolean isStubTypeEqualsToAnything() {
        return this.isStubTypeEqualsToAnything;
    }

    public final TypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    /*
     * WARNING - void declaration
     */
    public final KotlinTypeMarker refineType(KotlinTypeMarker type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.kotlinTypeRefiner.refineType((KotlinTypeMarker)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final KotlinTypeMarker prepareType(KotlinTypeMarker type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.kotlinTypePreparator.prepareType((KotlinTypeMarker)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean customIsSubtypeOf(KotlinTypeMarker subType, KotlinTypeMarker superType) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"superType");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public LowerCapturedTypePolicy getLowerCapturedTypePolicy(SimpleTypeMarker subType, CapturedTypeMarker superType) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"superType");
        return LowerCapturedTypePolicy.CHECK_SUBTYPE_AND_LOWER;
    }

    /*
     * WARNING - void declaration
     */
    public Boolean addSubtypeConstraint(KotlinTypeMarker subType, KotlinTypeMarker superType, boolean isFromNullabilityConstraint) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"superType");
        return null;
    }

    public static /* synthetic */ Boolean addSubtypeConstraint$default(TypeCheckerState typeCheckerState, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSubtypeConstraint");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return typeCheckerState.addSubtypeConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public boolean runForkingPoint(Function1<? super ForkPointContext, Unit> block) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ForkPointContext.Default $this$runForkingPoint_u24lambda_u240 = new ForkPointContext.Default();
        var1_1.invoke((Object)$this$runForkingPoint_u24lambda_u240);
        return var2_2.getResult();
    }

    public final ArrayDeque<SimpleTypeMarker> getSupertypesDeque() {
        return this.supertypesDeque;
    }

    public final Set<SimpleTypeMarker> getSupertypesSet() {
        return this.supertypesSet;
    }

    public final void initialize() {
        boolean bl;
        boolean bl2 = bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Supertypes were locked for " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new AssertionError((Object)string);
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque(4);
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = (Set)((Object)SmartSet.Companion.create());
        }
    }

    public final void clear() {
        ArrayDeque<SimpleTypeMarker> arrayDeque = this.supertypesDeque;
        Intrinsics.checkNotNull(arrayDeque);
        arrayDeque.clear();
        Set<SimpleTypeMarker> set = this.supertypesSet;
        Intrinsics.checkNotNull(set);
        set.clear();
        this.supertypesLocked = false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAllowedTypeVariable(KotlinTypeMarker type) {
        void var1_1;
        TypeSystemContext typeSystemContext;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.allowedTypeVariable && (typeSystemContext = this.typeSystemContext).isTypeVariableType((KotlinTypeMarker)var1_1);
    }

    public static final /* synthetic */ int access$getArgumentsDepth(TypeCheckerState $this) {
        return $this.argumentsDepth;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setArgumentsDepth(TypeCheckerState $this, int n) {
        void var1_1;
        $this.argumentsDepth = var1_1;
    }

    public static interface ForkPointContext {
        public void fork(Function0<Boolean> var1);

        public static final class Default
        implements ForkPointContext {
            private boolean result;

            public final boolean getResult() {
                return this.result;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void fork(Function0<Boolean> block) {
                void var1_1;
                Intrinsics.checkNotNullParameter(block, (String)"block");
                if (this.result) {
                    return;
                }
                this.result = (Boolean)var1_1.invoke();
            }
        }
    }

    public static final class LowerCapturedTypePolicy
    extends Enum<LowerCapturedTypePolicy> {
        public static final /* enum */ LowerCapturedTypePolicy CHECK_ONLY_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy CHECK_SUBTYPE_AND_LOWER = new LowerCapturedTypePolicy();
        public static final /* enum */ LowerCapturedTypePolicy SKIP_LOWER = new LowerCapturedTypePolicy();
        private static final /* synthetic */ LowerCapturedTypePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private LowerCapturedTypePolicy() {
            void var2_2;
            void var1_1;
        }

        public static LowerCapturedTypePolicy[] values() {
            return (LowerCapturedTypePolicy[])$VALUES.clone();
        }

        public static LowerCapturedTypePolicy valueOf(String value) {
            String string;
            return Enum.valueOf(LowerCapturedTypePolicy.class, string);
        }

        private static final /* synthetic */ LowerCapturedTypePolicy[] $values() {
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray = new LowerCapturedTypePolicy[3];
            LowerCapturedTypePolicy[] lowerCapturedTypePolicyArray2 = lowerCapturedTypePolicyArray;
            lowerCapturedTypePolicyArray[0] = CHECK_ONLY_LOWER;
            lowerCapturedTypePolicyArray2[1] = CHECK_SUBTYPE_AND_LOWER;
            lowerCapturedTypePolicyArray2[2] = SKIP_LOWER;
            return lowerCapturedTypePolicyArray2;
        }

        static {
            $VALUES = LowerCapturedTypePolicy.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static abstract class SupertypesPolicy {
        private SupertypesPolicy() {
        }

        public abstract SimpleTypeMarker transformType(TypeCheckerState var1, KotlinTypeMarker var2);

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static abstract class DoCustomTransform
        extends SupertypesPolicy {
            public DoCustomTransform() {
                super(null);
            }
        }

        @SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$LowerIfFlexible\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,860:1\n1#2:861\n*E\n"})
        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE = new LowerIfFlexible();

            private LowerIfFlexible() {
                super(null);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final SimpleTypeMarker transformType(TypeCheckerState state, KotlinTypeMarker type) {
                void var2_2;
                TypeSystemContext typeSystemContext;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                typeSystemContext = ((TypeCheckerState)((Object)typeSystemContext)).getTypeSystemContext();
                return typeSystemContext.lowerBoundIfFlexible((KotlinTypeMarker)var2_2);
            }
        }

        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            /*
             * WARNING - void declaration
             */
            public final Void transformType(TypeCheckerState state, KotlinTypeMarker type) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"type");
                throw new UnsupportedOperationException("Should not be called");
            }
        }

        @SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState$SupertypesPolicy$UpperIfFlexible\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,860:1\n1#2:861\n*E\n"})
        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE = new UpperIfFlexible();

            private UpperIfFlexible() {
                super(null);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final SimpleTypeMarker transformType(TypeCheckerState state, KotlinTypeMarker type) {
                void var2_2;
                TypeSystemContext typeSystemContext;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                typeSystemContext = ((TypeCheckerState)((Object)typeSystemContext)).getTypeSystemContext();
                return typeSystemContext.upperBoundIfFlexible((KotlinTypeMarker)var2_2);
            }
        }
    }
}

