/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public abstract class ProtoContainer {
    private final NameResolver nameResolver;
    private final TypeTable typeTable;
    private final SourceElement source;

    /*
     * WARNING - void declaration
     */
    private ProtoContainer(NameResolver nameResolver, TypeTable typeTable, SourceElement source) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.nameResolver = var1_1;
        this.typeTable = var2_2;
        this.source = var3_3;
    }

    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final SourceElement getSource() {
        return this.source;
    }

    public abstract FqName debugFqName();

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.debugFqName();
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ ProtoContainer(NameResolver nameResolver, TypeTable typeTable, SourceElement source, DefaultConstructorMarker $constructor_marker) {
        this((NameResolver)var1_1, (TypeTable)var2_2, (SourceElement)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public static final class Class
    extends ProtoContainer {
        private final ProtoBuf.Class classProto;
        private final Class outerClass;
        private final ClassId classId;
        private final ProtoBuf.Class.Kind kind;
        private final boolean isInner;
        private final boolean isData;

        /*
         * WARNING - void declaration
         */
        public Class(ProtoBuf.Class classProto, NameResolver nameResolver, TypeTable typeTable, SourceElement source, Class outerClass) {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
            Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            super(nameResolver, (TypeTable)var3_3, source, null);
            this.classProto = var1_1;
            this.outerClass = outerClass;
            this.classId = NameResolverUtilKt.getClassId((NameResolver)var2_2, this.classProto.getFqName());
            ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(this.classProto.getFlags());
            if (kind == null) {
                kind = ProtoBuf.Class.Kind.CLASS;
            }
            this.kind = kind;
            Boolean bl = Flags.IS_INNER.get(this.classProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
            this.isInner = bl;
            Boolean bl2 = Flags.IS_DATA.get(this.classProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"get(...)");
            this.isData = bl2;
        }

        public final ProtoBuf.Class getClassProto() {
            return this.classProto;
        }

        public final Class getOuterClass() {
            return this.outerClass;
        }

        public final ClassId getClassId() {
            return this.classId;
        }

        public final ProtoBuf.Class.Kind getKind() {
            return this.kind;
        }

        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        public final FqName debugFqName() {
            return this.classId.asSingleFqName();
        }
    }

    public static final class Package
    extends ProtoContainer {
        private final FqName fqName;

        /*
         * WARNING - void declaration
         */
        public Package(FqName fqName, NameResolver nameResolver, TypeTable typeTable, SourceElement source) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            super((NameResolver)var2_2, (TypeTable)var3_3, source, null);
            this.fqName = var1_1;
        }

        @Override
        public final FqName debugFqName() {
            return this.fqName;
        }
    }
}

