/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

@SourceDebugExtension(value={"SMAP\nAnnotationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/AnnotationDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n121#1:147\n121#1:148\n121#1:149\n121#1:150\n1202#2,2:128\n1230#2,4:130\n1611#2,9:134\n1863#2:143\n1864#2:145\n1620#2:146\n1557#2:151\n1628#2,3:152\n1734#2,3:155\n1#3:144\n*S KotlinDebug\n*F\n+ 1 AnnotationDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/AnnotationDeserializer\n*L\n74#1:147\n76#1:148\n77#1:149\n78#1:150\n47#1:128,2\n47#1:130,4\n48#1:134,9\n48#1:143\n48#1:145\n48#1:146\n87#1:151\n87#1:152,3\n112#1:155,3\n48#1:144\n*E\n"})
public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    /*
     * WARNING - void declaration
     */
    public AnnotationDeserializer(ModuleDescriptor module, NotFoundClasses notFoundClasses) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = var1_1;
        this.notFoundClasses = var2_2;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationDescriptor deserializeAnnotation(ProtoBuf.Annotation proto, NameResolver nameResolver) {
        void var3_3;
        Map map;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, proto.getId()));
        Map arguments = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $this$mapNotNullTo$iv$iv;
                ValueParameterDescriptor valueParameterDescriptor;
                Object $this$associateByTo$iv$iv;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                Iterable $this$associateBy$iv = list;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                $this$associateByTo$iv$iv = $this$associateByTo$iv$iv.iterator();
                while ($this$associateByTo$iv$iv.hasNext()) {
                    void it;
                    Object element$iv$iv = $this$associateByTo$iv$iv.next();
                    valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    map2.put(it.getName(), element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getArgumentList(...)");
                $this$associateByTo$iv$iv = list2;
                Iterable element$iv$iv = $this$associateByTo$iv$iv;
                Collection destination$iv$iv2 = new ArrayList();
                proto = $this$mapNotNullTo$iv$iv;
                Iterator iterator2 = proto.iterator();
                while (iterator2.hasNext()) {
                    void var1_1;
                    valueParameterDescriptor = iterator2.next();
                    proto = valueParameterDescriptor;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)((Object)valueParameterDescriptor);
                    Intrinsics.checkNotNull((Object)it);
                    if (this.resolveArgument(it, parameterByName, nameResolver) == null) continue;
                    destination$iv$iv2.add(var1_1);
                }
                map = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }
        return new AnnotationDescriptorImpl(var3_3.getDefaultType(), map, SourceElement.NO_SOURCE);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        void var3_3;
        void var1_1;
        void var2_2;
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(NameResolverUtilKt.getName(nameResolver, proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, proto.getNameId());
        KotlinType kotlinType = var2_2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        ProtoBuf.Annotation.Argument.Value value = var1_1.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"getValue(...)");
        return new Pair((Object)name, this.resolveValueAndCheckExpectedType(kotlinType, value, (NameResolver)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        ConstantValue constantValue;
        ConstantValue it = constantValue = this.resolveValue(expectedType, value, (NameResolver)((Object)constantValue));
        ConstantValue constantValue2 = this.doesValueConformToExpectedType(it, expectedType, value) ? constantValue : null;
        if (constantValue2 == null) {
            void var1_1;
            void var2_2;
            constantValue2 = ErrorValue.Companion.create("Unexpected argument value: actual type " + var2_2.getType() + " != expected type " + var1_1);
        }
        return constantValue2;
    }

    /*
     * WARNING - void declaration
     */
    public final ConstantValue<?> resolveValue(KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        void var1_1;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Boolean bl = Flags.IS_UNSIGNED.get(((ProtoBuf.Annotation.Argument.Value)value).getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean isUnsigned2 = bl;
        ProtoBuf.Annotation.Argument.Value.Type type = ((ProtoBuf.Annotation.Argument.Value)value).getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                ConstantValue constantValue;
                byte $this$letIf$iv = (byte)((ProtoBuf.Annotation.Argument.Value)value).getIntValue();
                if (isUnsigned2) {
                    byte p0 = $this$letIf$iv;
                    constantValue = new UByteValue(p0);
                } else {
                    byte p0 = $this$letIf$iv;
                    constantValue = new ByteValue(p0);
                }
                return constantValue;
            }
            case 2: {
                return new CharValue((char)((ProtoBuf.Annotation.Argument.Value)value).getIntValue());
            }
            case 3: {
                ConstantValue constantValue;
                short $this$letIf$iv = (short)((ProtoBuf.Annotation.Argument.Value)value).getIntValue();
                if (isUnsigned2) {
                    short p0 = $this$letIf$iv;
                    constantValue = new UShortValue(p0);
                } else {
                    short p0 = $this$letIf$iv;
                    constantValue = new ShortValue(p0);
                }
                return constantValue;
            }
            case 4: {
                ConstantValue constantValue;
                int $this$letIf$iv = (int)((ProtoBuf.Annotation.Argument.Value)value).getIntValue();
                if (isUnsigned2) {
                    int p0 = $this$letIf$iv;
                    constantValue = new UIntValue(p0);
                } else {
                    int p0 = $this$letIf$iv;
                    constantValue = new IntValue(p0);
                }
                return constantValue;
            }
            case 5: {
                ConstantValue constantValue;
                long $this$letIf$iv = ((ProtoBuf.Annotation.Argument.Value)value).getIntValue();
                if (isUnsigned2) {
                    long p0 = $this$letIf$iv;
                    constantValue = new ULongValue(p0);
                } else {
                    long p0 = $this$letIf$iv;
                    constantValue = new LongValue(p0);
                }
                return constantValue;
            }
            case 6: {
                return new FloatValue(((ProtoBuf.Annotation.Argument.Value)value).getFloatValue());
            }
            case 7: {
                return new DoubleValue(((ProtoBuf.Annotation.Argument.Value)value).getDoubleValue());
            }
            case 8: {
                return new BooleanValue(((ProtoBuf.Annotation.Argument.Value)value).getIntValue() != 0L);
            }
            case 9: {
                return new StringValue(nameResolver.getString(((ProtoBuf.Annotation.Argument.Value)value).getStringValue()));
            }
            case 10: {
                return new KClassValue(NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf.Annotation.Argument.Value)value).getClassId()), ((ProtoBuf.Annotation.Argument.Value)value).getArrayDimensionCount());
            }
            case 11: {
                return new EnumValue(NameResolverUtilKt.getClassId(nameResolver, ((ProtoBuf.Annotation.Argument.Value)value).getClassId()), NameResolverUtilKt.getName(nameResolver, ((ProtoBuf.Annotation.Argument.Value)value).getEnumValueId()));
            }
            case 12: {
                ProtoBuf.Annotation annotation = ((ProtoBuf.Annotation.Argument.Value)value).getAnnotation();
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"getAnnotation(...)");
                return new AnnotationValue(this.deserializeAnnotation(annotation, nameResolver));
            }
            case 13: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<ProtoBuf.Annotation.Argument.Value> list = ((ProtoBuf.Annotation.Argument.Value)value).getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArrayElementList(...)");
                value = list;
                ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
                void isUnsigned2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), (int)10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    item$iv$iv = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AnnotationDeserializer annotationDeserializer = this;
                    SimpleType simpleType = annotationDeserializer.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getAnyType(...)");
                    KotlinType kotlinType = simpleType;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(annotationDeserializer.resolveValue(kotlinType, (ProtoBuf.Annotation.Argument.Value)it, nameResolver));
                }
                return constantValueFactory.createArrayValue((List)destination$iv$iv, expectedType);
            }
        }
        throw new IllegalStateException(("Unsupported annotation argument type: " + ((ProtoBuf.Annotation.Argument.Value)((Object)iterator2)).getType() + " (expected " + var1_1 + ')').toString());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doesValueConformToExpectedType(ConstantValue<?> result, KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value) {
        void var2_2;
        void var1_1;
        ProtoBuf.Annotation.Argument.Value.Type type = value.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor expectedClass = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                return expectedClass == null || KotlinBuiltIns.isKClass(expectedClass);
            }
            case 13: {
                ClassDescriptor expectedClass;
                if (!(result instanceof ArrayValue && ((List)((ArrayValue)result).getValue()).size() == value.getArrayElementList().size())) {
                    String string = "Deserialized ArrayValue should have the same number of elements as the original array value: " + result;
                    throw new IllegalStateException(string.toString());
                }
                KotlinType kotlinType = this.getBuiltIns().getArrayElementType((KotlinType)((Object)expectedClass));
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getArrayElementType(...)");
                KotlinType expectedElementType = kotlinType;
                Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)((ArrayValue)result).getValue()));
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int n;
                    int i = n = ((IntIterator)iterator2).nextInt();
                    ConstantValue constantValue = (ConstantValue)((List)((ArrayValue)result).getValue()).get(i);
                    ProtoBuf.Annotation.Argument.Value value2 = value.getArrayElement(i);
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getArrayElement(...)");
                    if (this.doesValueConformToExpectedType(constantValue, expectedElementType, value2)) continue;
                    return false;
                }
                return true;
            }
        }
        return Intrinsics.areEqual((Object)var1_1.getType(this.module), (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor resolveClass(ClassId classId) {
        void var1_1;
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, (ClassId)var1_1, this.notFoundClasses);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

