/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@SourceDebugExtension(value={"SMAP\ninlineClassManglingRules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1755#2,3:54\n1755#2,3:57\n1#3:60\n*S KotlinDebug\n*F\n+ 1 inlineClassManglingRules.kt\norg/jetbrains/kotlin/resolve/jvm/InlineClassManglingRulesKt\n*L\n21#1:54,3\n27#1:57,3\n*E\n"})
public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToValueClassTypeValueParameters(CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
        if (classConstructorDescriptor == null) {
            return false;
        }
        Iterator constructorDescriptor = classConstructorDescriptor;
        if (DescriptorVisibilities.isPrivate(classConstructorDescriptor.getVisibility())) {
            return false;
        }
        ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
        if (InlineClassesUtilsKt.isValueClass(classDescriptor)) {
            return false;
        }
        if (DescriptorUtils.isSealedClass(constructorDescriptor.getConstructedClass())) {
            return false;
        }
        List<ValueParameterDescriptor> list = constructorDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Iterator $this$any$iv = list;
        if (!($this$any$iv instanceof Collection) || !((Collection)((Object)$this$any$iv)).isEmpty()) {
            Iterator iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                object = (ValueParameterDescriptor)object;
                KotlinType kotlinType = object.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isValueClassThatRequiresMangling(DeclarationDescriptor $this$isValueClassThatRequiresMangling) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        return InlineClassesUtilsKt.isValueClass($this$isValueClassThatRequiresMangling) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)declarationDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isValueClassThatRequiresMangling(KotlinType $this$isValueClassThatRequiresMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassThatRequiresMangling, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isValueClassThatRequiresMangling.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            KotlinType kotlinType;
            void var1_1;
            ClassifierDescriptor it = classifierDescriptor;
            return InlineClassesUtilsKt.isInlineClass(classifierDescriptor) && InlineClassManglingRulesKt.isValueClassThatRequiresMangling((DeclarationDescriptor)var1_1) || InlineClassesUtilsKt.needsMfvcFlattening(kotlinType);
        }
        return false;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType $this$requiresFunctionNameManglingInParameterTypes) {
        KotlinType kotlinType;
        return InlineClassManglingRulesKt.isValueClassThatRequiresMangling($this$requiresFunctionNameManglingInParameterTypes) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(kotlinType, true);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)StandardNames.RESULT_FQ_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType $this$isTypeParameterWithUpperBoundThatRequiresMangling, boolean includeMfvc) {
        Annotated annotated;
        void var1_1;
        TypeParameterDescriptor typeParameterDescriptor = ($this$isTypeParameterWithUpperBoundThatRequiresMangling = $this$isTypeParameterWithUpperBoundThatRequiresMangling.getConstructor().getDeclarationDescriptor()) instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)$this$isTypeParameterWithUpperBoundThatRequiresMangling : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        Annotated descriptor2 = typeParameterDescriptor;
        return (var1_1 != false || !InlineClassesUtilsKt.isMultiFieldValueClass((DeclarationDescriptor)descriptor2)) && InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)annotated));
    }
}

