/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

@SourceDebugExtension(value={"SMAP\nconstantValues.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constantValues.kt\norg/jetbrains/kotlin/resolve/constants/EnumValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
public final class EnumValue
extends ConstantValue<Pair<? extends ClassId, ? extends Name>> {
    private final ClassId enumClassId;
    private final Name enumEntryName;

    /*
     * WARNING - void declaration
     */
    public EnumValue(ClassId enumClassId, Name enumEntryName) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
        Intrinsics.checkNotNullParameter((Object)enumEntryName, (String)"enumEntryName");
        super(TuplesKt.to((Object)enumClassId, (Object)enumEntryName));
        this.enumClassId = var1_1;
        this.enumEntryName = var2_2;
    }

    public final Name getEnumEntryName() {
        return this.enumEntryName;
    }

    @Override
    public final KotlinType getType(ModuleDescriptor module) {
        String[] stringArray;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)((Object)classDescriptor), this.enumClassId);
        if (annotated != null) {
            classDescriptor = annotated;
            stringArray = (String[])annotated;
            if ((annotated = DescriptorUtils.isEnumClass((DeclarationDescriptor)stringArray) ? classDescriptor : null) != null && (annotated = annotated.getDefaultType()) != null) {
                return (KotlinType)annotated;
            }
        }
        String[] stringArray2 = new String[2];
        stringArray = stringArray2;
        stringArray2[0] = this.enumClassId.toString();
        stringArray[1] = this.enumEntryName.toString();
        return ErrorUtils.createErrorType(ErrorTypeKind.ERROR_ENUM_TYPE, stringArray);
    }

    @Override
    public final String toString() {
        return "" + this.enumClassId.getShortClassName() + '.' + this.enumEntryName;
    }
}

