/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyAccessorDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PropertyDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorEquivalenceForOverrides;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.ExternalOverridabilityCondition;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingStrategy;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtilTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.resolve.VisibilityUtilKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypePreparator;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class OverridingUtil {
    private static final List<ExternalOverridabilityCondition> EXTERNAL_CONDITIONS = CollectionsKt.toList(ServiceLoader.load(ExternalOverridabilityCondition.class, ExternalOverridabilityCondition.class.getClassLoader()));
    public static final OverridingUtil DEFAULT;
    private static final KotlinTypeChecker.TypeConstructorEquality DEFAULT_TYPE_CONSTRUCTOR_EQUALITY;
    private final KotlinTypeRefiner kotlinTypeRefiner;
    private final KotlinTypePreparator kotlinTypePreparator;
    private final KotlinTypeChecker.TypeConstructorEquality equalityAxioms;
    private final Function2<KotlinType, KotlinType, Boolean> customSubtype;

    public static OverridingUtil createWithTypeRefiner(KotlinTypeRefiner kotlinTypeRefiner) {
        KotlinTypeRefiner kotlinTypeRefiner2;
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(0);
        }
        return new OverridingUtil(DEFAULT_TYPE_CONSTRUCTOR_EQUALITY, kotlinTypeRefiner2, KotlinTypePreparator.Default.INSTANCE, null);
    }

    /*
     * WARNING - void declaration
     */
    public static OverridingUtil create(KotlinTypeRefiner kotlinTypeRefiner, KotlinTypeChecker.TypeConstructorEquality equalityAxioms) {
        KotlinTypeRefiner kotlinTypeRefiner2;
        void var1_1;
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(3);
        }
        if (equalityAxioms == null) {
            OverridingUtil.$$$reportNull$$$0(4);
        }
        return new OverridingUtil((KotlinTypeChecker.TypeConstructorEquality)var1_1, kotlinTypeRefiner2, KotlinTypePreparator.Default.INSTANCE, null);
    }

    /*
     * WARNING - void declaration
     */
    private OverridingUtil(KotlinTypeChecker.TypeConstructorEquality axioms, KotlinTypeRefiner kotlinTypeRefiner, KotlinTypePreparator kotlinTypePreparator, Function2<KotlinType, KotlinType, Boolean> customSubtype) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (axioms == null) {
            OverridingUtil.$$$reportNull$$$0(5);
        }
        if (kotlinTypeRefiner == null) {
            OverridingUtil.$$$reportNull$$$0(6);
        }
        if (kotlinTypePreparator == null) {
            OverridingUtil.$$$reportNull$$$0(7);
        }
        this.equalityAxioms = var1_1;
        this.kotlinTypeRefiner = var2_2;
        this.kotlinTypePreparator = var3_3;
        this.customSubtype = customSubtype;
    }

    /*
     * WARNING - void declaration
     */
    public static <D extends CallableDescriptor> Set<D> filterOutOverridden(Set<D> candidateSet) {
        void var1_1;
        Set<D> set;
        if (candidateSet == null) {
            OverridingUtil.$$$reportNull$$$0(8);
        }
        boolean allowDescriptorCopies = !candidateSet.isEmpty() && DescriptorUtilsKt.isTypeRefinementEnabled(DescriptorUtilsKt.getModule((DeclarationDescriptor)candidateSet.iterator().next()));
        return OverridingUtil.filterOverrides(set, (boolean)var1_1, null, new Function2<D, D, Pair<CallableDescriptor, CallableDescriptor>>(){

            /*
             * WARNING - void declaration
             */
            public final Pair<CallableDescriptor, CallableDescriptor> invoke(D a, D b) {
                void var2_2;
                void var1_1;
                return new Pair((Object)var1_1, (Object)var2_2);
            }
        });
    }

    public static <D> Set<D> filterOverrides(Set<D> candidateSet, boolean allowDescriptorCopies, Function0<?> cancellationCallback, Function2<? super D, ? super D, Pair<CallableDescriptor, CallableDescriptor>> transformFirst) {
        if (candidateSet == null) {
            OverridingUtil.$$$reportNull$$$0(9);
        }
        if (transformFirst == null) {
            OverridingUtil.$$$reportNull$$$0(10);
        }
        if (candidateSet.size() <= 1) {
            Set<D> set = candidateSet;
            if (set == null) {
                OverridingUtil.$$$reportNull$$$0(11);
            }
            return set;
        }
        LinkedHashSet<D> result = new LinkedHashSet<D>();
        block0: for (D meD : candidateSet) {
            if (cancellationCallback != null) {
                cancellationCallback.invoke();
            }
            Iterator iterator2 = result.iterator();
            while (iterator2.hasNext()) {
                CallableDescriptor other;
                Object otherD = iterator2.next();
                Pair meAndOther = (Pair)transformFirst.invoke(meD, otherD);
                CallableDescriptor me = (CallableDescriptor)meAndOther.component1();
                if (OverridingUtil.overrides(me, other = (CallableDescriptor)meAndOther.component2(), allowDescriptorCopies, true)) {
                    iterator2.remove();
                    continue;
                }
                if (OverridingUtil.overrides(other, me, allowDescriptorCopies, true)) continue block0;
            }
            result.add(meD);
        }
        if (!$assertionsDisabled && result.isEmpty()) {
            Set<D> set;
            throw new AssertionError((Object)("All candidates filtered out from " + set));
        }
        return result;
    }

    public static <D extends CallableDescriptor> boolean overrides(D f, D g, boolean allowDeclarationCopies, boolean distinguishExpectsAndNonExpects) {
        Object object;
        if (f == null) {
            OverridingUtil.$$$reportNull$$$0(13);
        }
        if (g == null) {
            OverridingUtil.$$$reportNull$$$0(14);
        }
        if (!f.equals(g) && DescriptorEquivalenceForOverrides.INSTANCE.areEquivalent(f.getOriginal(), g.getOriginal(), allowDeclarationCopies, distinguishExpectsAndNonExpects)) {
            return true;
        }
        CallableDescriptor originalG = g.getOriginal();
        for (CallableDescriptor overriddenFunction : DescriptorUtils.getAllOverriddenDescriptors(object)) {
            if (!DescriptorEquivalenceForOverrides.INSTANCE.areEquivalent(originalG, overriddenFunction, allowDeclarationCopies, distinguishExpectsAndNonExpects)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<CallableMemberDescriptor> getOverriddenDeclarations(CallableMemberDescriptor descriptor2) {
        void var1_1;
        CallableMemberDescriptor callableMemberDescriptor;
        if (descriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(15);
        }
        LinkedHashSet<CallableMemberDescriptor> result = new LinkedHashSet<CallableMemberDescriptor>();
        OverridingUtil.collectOverriddenDeclarations(callableMemberDescriptor, result);
        return var1_1;
    }

    private static void collectOverriddenDeclarations(CallableMemberDescriptor descriptor2, Set<CallableMemberDescriptor> result) {
        Object object;
        if (descriptor2 == null) {
            OverridingUtil.$$$reportNull$$$0(17);
        }
        if (result == null) {
            OverridingUtil.$$$reportNull$$$0(18);
        }
        if (descriptor2.getKind().isReal()) {
            result.add(descriptor2);
            return;
        }
        if (descriptor2.getOverriddenDescriptors().isEmpty()) {
            throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor2);
        }
        for (CallableMemberDescriptor callableMemberDescriptor : object.getOverriddenDescriptors()) {
            OverridingUtil.collectOverriddenDeclarations(callableMemberDescriptor, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OverrideCompatibilityInfo isOverridableBy(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (superDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(19);
        }
        if (subDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(20);
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = this.isOverridableBy((CallableDescriptor)var1_1, (CallableDescriptor)var2_2, (ClassDescriptor)var3_3, false);
        if (overrideCompatibilityInfo == null) {
            OverridingUtil.$$$reportNull$$$0(21);
        }
        return overrideCompatibilityInfo;
    }

    public OverrideCompatibilityInfo isOverridableBy(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor, boolean checkReturnType) {
        ExternalOverridabilityCondition.Result result;
        OverrideCompatibilityInfo basicResult;
        if (superDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(22);
        }
        if (subDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(23);
        }
        boolean wasSuccess = (basicResult = this.isOverridableByWithoutExternalConditions(superDescriptor, subDescriptor, checkReturnType)).getResult() == OverrideCompatibilityInfo.Result.OVERRIDABLE;
        block8: for (ExternalOverridabilityCondition externalCondition : EXTERNAL_CONDITIONS) {
            if (externalCondition.getContract() == ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY || wasSuccess && externalCondition.getContract() == ExternalOverridabilityCondition.Contract.SUCCESS_ONLY) continue;
            result = externalCondition.isOverridable(superDescriptor, subDescriptor, subClassDescriptor);
            switch (result) {
                case OVERRIDABLE: {
                    wasSuccess = true;
                    continue block8;
                }
                case INCOMPATIBLE: {
                    OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("External condition");
                    if (overrideCompatibilityInfo == null) {
                        OverridingUtil.$$$reportNull$$$0(24);
                    }
                    return overrideCompatibilityInfo;
                }
            }
        }
        if (!wasSuccess) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = basicResult;
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(25);
            }
            return overrideCompatibilityInfo;
        }
        for (ExternalOverridabilityCondition externalCondition : EXTERNAL_CONDITIONS) {
            if (externalCondition.getContract() != ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY) continue;
            result = externalCondition.isOverridable(superDescriptor, subDescriptor, subClassDescriptor);
            switch (result) {
                case INCOMPATIBLE: {
                    OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("External condition");
                    if (overrideCompatibilityInfo == null) {
                        OverridingUtil.$$$reportNull$$$0(26);
                    }
                    return overrideCompatibilityInfo;
                }
                case OVERRIDABLE: {
                    throw new IllegalStateException("Contract violation in " + externalCondition.getClass().getName() + " condition. It's not supposed to end with success");
                }
            }
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo == null) {
            OverridingUtil.$$$reportNull$$$0(27);
        }
        return overrideCompatibilityInfo;
    }

    /*
     * WARNING - void declaration
     */
    public OverrideCompatibilityInfo isOverridableByWithoutExternalConditions(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, boolean checkReturnType) {
        void var3_4;
        int i;
        OverrideCompatibilityInfo basicOverridability;
        if (superDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(28);
        }
        if (subDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(29);
        }
        if ((basicOverridability = OverridingUtil.getBasicOverridabilityProblem(superDescriptor, subDescriptor)) != null) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = basicOverridability;
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(30);
            }
            return overrideCompatibilityInfo;
        }
        List<KotlinType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<KotlinType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (superTypeParameters.size() != subTypeParameters.size()) {
            for (int i2 = 0; i2 < superValueParameters.size(); ++i2) {
                if (KotlinTypeChecker.DEFAULT.equalTypes(superValueParameters.get(i2), subValueParameters.get(i2))) continue;
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Type parameter number mismatch");
                if (overrideCompatibilityInfo == null) {
                    OverridingUtil.$$$reportNull$$$0(31);
                }
                return overrideCompatibilityInfo;
            }
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Type parameter number mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(32);
            }
            return overrideCompatibilityInfo;
        }
        TypeCheckerState typeCheckerState = this.createTypeCheckerState(superTypeParameters, subTypeParameters);
        for (i = 0; i < superTypeParameters.size(); ++i) {
            if (OverridingUtil.areTypeParametersEquivalent(superTypeParameters.get(i), subTypeParameters.get(i), typeCheckerState)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Type parameter bounds mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(33);
            }
            return overrideCompatibilityInfo;
        }
        for (i = 0; i < superValueParameters.size(); ++i) {
            if (OverridingUtil.areTypesEquivalent(superValueParameters.get(i), subValueParameters.get(i), typeCheckerState)) continue;
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.incompatible("Value parameter type mismatch");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(34);
            }
            return overrideCompatibilityInfo;
        }
        if (superDescriptor instanceof FunctionDescriptor && subDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)superDescriptor).isSuspend() != ((FunctionDescriptor)subDescriptor).isSuspend()) {
            OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Incompatible suspendability");
            if (overrideCompatibilityInfo == null) {
                OverridingUtil.$$$reportNull$$$0(35);
            }
            return overrideCompatibilityInfo;
        }
        if (var3_4 != false) {
            void var1_1;
            boolean bl;
            void var2_2;
            KotlinType superReturnType = superDescriptor.getReturnType();
            KotlinType subReturnType = var2_2.getReturnType();
            if (superReturnType != null && subReturnType != null && !(bl = KotlinTypeKt.isError(subReturnType) && KotlinTypeKt.isError(superReturnType)) && !AbstractTypeChecker.INSTANCE.isSubtypeOf(typeCheckerState, var1_1.unwrap(), superReturnType.unwrap())) {
                OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.conflict("Return type mismatch");
                if (overrideCompatibilityInfo == null) {
                    OverridingUtil.$$$reportNull$$$0(36);
                }
                return overrideCompatibilityInfo;
            }
        }
        OverrideCompatibilityInfo overrideCompatibilityInfo = OverrideCompatibilityInfo.success();
        if (overrideCompatibilityInfo == null) {
            OverridingUtil.$$$reportNull$$$0(37);
        }
        return overrideCompatibilityInfo;
    }

    /*
     * WARNING - void declaration
     */
    public static OverrideCompatibilityInfo getBasicOverridabilityProblem(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
        void var1_1;
        if (superDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(38);
        }
        if (subDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(39);
        }
        if (superDescriptor instanceof FunctionDescriptor && !(subDescriptor instanceof FunctionDescriptor) || superDescriptor instanceof PropertyDescriptor && !(subDescriptor instanceof PropertyDescriptor)) {
            return OverrideCompatibilityInfo.incompatible("Member kind mismatch");
        }
        if (!(superDescriptor instanceof FunctionDescriptor) && !(superDescriptor instanceof PropertyDescriptor)) {
            throw new IllegalArgumentException("This type of CallableDescriptor cannot be checked for overridability: " + superDescriptor);
        }
        if (!superDescriptor.getName().equals(subDescriptor.getName())) {
            return OverrideCompatibilityInfo.incompatible("Name mismatch");
        }
        OverrideCompatibilityInfo receiverAndParameterResult = OverridingUtil.checkReceiverAndParameterCount(superDescriptor, (CallableDescriptor)var1_1);
        if (receiverAndParameterResult != null) {
            OverrideCompatibilityInfo overrideCompatibilityInfo;
            return overrideCompatibilityInfo;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private TypeCheckerState createTypeCheckerState(List<TypeParameterDescriptor> firstParameters, List<TypeParameterDescriptor> secondParameters) {
        void var3_3;
        if (firstParameters == null) {
            OverridingUtil.$$$reportNull$$$0(40);
        }
        if (secondParameters == null) {
            OverridingUtil.$$$reportNull$$$0(41);
        }
        assert (firstParameters.size() == secondParameters.size()) : "Should be the same number of type parameters: " + firstParameters + " vs " + secondParameters;
        if (firstParameters.isEmpty()) {
            TypeCheckerState typeCheckerState = new OverridingUtilTypeSystemContext(null, this.equalityAxioms, this.kotlinTypeRefiner, this.kotlinTypePreparator, this.customSubtype).newTypeCheckerState(true, true);
            if (typeCheckerState == null) {
                OverridingUtil.$$$reportNull$$$0(42);
            }
            return typeCheckerState;
        }
        HashMap<TypeConstructor, TypeConstructor> matchingTypeConstructors = new HashMap<TypeConstructor, TypeConstructor>();
        for (int i = 0; i < firstParameters.size(); ++i) {
            matchingTypeConstructors.put(firstParameters.get(i).getTypeConstructor(), secondParameters.get(i).getTypeConstructor());
        }
        TypeCheckerState typeCheckerState = new OverridingUtilTypeSystemContext((Map<TypeConstructor, ? extends TypeConstructor>)var3_3, this.equalityAxioms, this.kotlinTypeRefiner, this.kotlinTypePreparator, this.customSubtype).newTypeCheckerState(true, true);
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(43);
        }
        return typeCheckerState;
    }

    /*
     * WARNING - void declaration
     */
    private static OverrideCompatibilityInfo checkReceiverAndParameterCount(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor) {
        void var1_1;
        CallableDescriptor callableDescriptor;
        if (superDescriptor.getExtensionReceiverParameter() == null != (subDescriptor.getExtensionReceiverParameter() == null)) {
            return OverrideCompatibilityInfo.incompatible("Receiver presence mismatch");
        }
        if (callableDescriptor.getValueParameters().size() != var1_1.getValueParameters().size()) {
            return OverrideCompatibilityInfo.incompatible("Value parameter number mismatch");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean areTypesEquivalent(KotlinType typeInSuper, KotlinType typeInSub, TypeCheckerState typeCheckerState) {
        void var1_1;
        KotlinType kotlinType;
        void var2_2;
        boolean bl;
        if (typeInSuper == null) {
            OverridingUtil.$$$reportNull$$$0(44);
        }
        if (typeInSub == null) {
            OverridingUtil.$$$reportNull$$$0(45);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(46);
        }
        if (bl = KotlinTypeKt.isError(typeInSuper) && KotlinTypeKt.isError(typeInSub)) {
            return true;
        }
        return AbstractTypeChecker.INSTANCE.equalTypes((TypeCheckerState)var2_2, kotlinType.unwrap(), var1_1.unwrap());
    }

    private static boolean areTypeParametersEquivalent(TypeParameterDescriptor superTypeParameter, TypeParameterDescriptor subTypeParameter, TypeCheckerState typeCheckerState) {
        Iterator iterator2;
        if (superTypeParameter == null) {
            OverridingUtil.$$$reportNull$$$0(47);
        }
        if (subTypeParameter == null) {
            OverridingUtil.$$$reportNull$$$0(48);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(49);
        }
        Iterator superBounds = superTypeParameter.getUpperBounds();
        ArrayList<KotlinType> subBounds = new ArrayList<KotlinType>(subTypeParameter.getUpperBounds());
        if (superBounds.size() != subBounds.size()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        block0: while (iterator2.hasNext()) {
            KotlinType superBound = (KotlinType)iterator2.next();
            ListIterator it = subBounds.listIterator();
            while (it.hasNext()) {
                KotlinType subBound = (KotlinType)it.next();
                if (!OverridingUtil.areTypesEquivalent(superBound, subBound, typeCheckerState)) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static List<KotlinType> compiledValueParameters(CallableDescriptor callableDescriptor) {
        void var2_2;
        Object object;
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getExtensionReceiverParameter();
        ArrayList<KotlinType> parameters = new ArrayList<KotlinType>();
        if (receiverParameter != null) {
            parameters.add(receiverParameter.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : object.getValueParameters()) {
            void var1_1;
            parameters.add(var1_1.getType());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void generateOverridesInFunctionGroup(Name name, Collection<? extends CallableMemberDescriptor> membersFromSupertypes, Collection<? extends CallableMemberDescriptor> membersFromCurrent, ClassDescriptor current, OverridingStrategy strategy) {
        void var1_1;
        Iterator iterator2;
        if (name == null) {
            OverridingUtil.$$$reportNull$$$0(50);
        }
        if (membersFromSupertypes == null) {
            OverridingUtil.$$$reportNull$$$0(51);
        }
        if (membersFromCurrent == null) {
            OverridingUtil.$$$reportNull$$$0(52);
        }
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(53);
        }
        if (strategy == null) {
            OverridingUtil.$$$reportNull$$$0(54);
        }
        LinkedHashSet<? extends CallableMemberDescriptor> notOverridden = new LinkedHashSet<CallableMemberDescriptor>(membersFromSupertypes);
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor fromCurrent = (CallableMemberDescriptor)iterator2.next();
            Collection<CallableMemberDescriptor> bound = this.extractAndBindOverridesForMember(fromCurrent, membersFromSupertypes, current, strategy);
            notOverridden.removeAll(bound);
        }
        OverridingUtil.createAndBindFakeOverrides(current, (Collection<CallableMemberDescriptor>)var1_1, strategy);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isVisibleForOverride(MemberDescriptor overriding, MemberDescriptor fromSuper, boolean useSpecialRulesForPrivateSealedConstructors) {
        void var2_2;
        MemberDescriptor memberDescriptor;
        void var1_1;
        if (overriding == null) {
            OverridingUtil.$$$reportNull$$$0(55);
        }
        if (fromSuper == null) {
            OverridingUtil.$$$reportNull$$$0(56);
        }
        return !DescriptorVisibilities.isPrivate(fromSuper.getVisibility()) && DescriptorVisibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)var1_1, memberDescriptor, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Collection<CallableMemberDescriptor> extractAndBindOverridesForMember(CallableMemberDescriptor fromCurrent, Collection<? extends CallableMemberDescriptor> descriptorsFromSuper, ClassDescriptor current, OverridingStrategy strategy) {
        void var1_1;
        Iterator iterator2;
        if (fromCurrent == null) {
            OverridingUtil.$$$reportNull$$$0(57);
        }
        if (descriptorsFromSuper == null) {
            OverridingUtil.$$$reportNull$$$0(58);
        }
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(59);
        }
        if (strategy == null) {
            OverridingUtil.$$$reportNull$$$0(60);
        }
        ArrayList<CallableMemberDescriptor> bound = new ArrayList<CallableMemberDescriptor>(descriptorsFromSuper.size());
        SmartSet overridden = SmartSet.create();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor fromSupertype = (CallableMemberDescriptor)iterator2.next();
            OverrideCompatibilityInfo.Result result = this.isOverridableBy(fromSupertype, fromCurrent, current).getResult();
            boolean isVisibleForOverride = OverridingUtil.isVisibleForOverride(fromCurrent, fromSupertype, false);
            switch (result) {
                case OVERRIDABLE: {
                    if (isVisibleForOverride) {
                        overridden.add((CallableMemberDescriptor)fromSupertype);
                    }
                    bound.add(fromSupertype);
                    break;
                }
                case CONFLICT: {
                    if (isVisibleForOverride) {
                        strategy.overrideConflict(fromSupertype, fromCurrent);
                    }
                    bound.add(fromSupertype);
                }
            }
        }
        strategy.setOverriddenDescriptors((CallableMemberDescriptor)var1_1, (Collection<? extends CallableMemberDescriptor>)((Object)overridden));
        return bound;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean allHasSameContainingDeclaration(Collection<CallableMemberDescriptor> notOverridden) {
        void var1_1;
        Collection<CallableMemberDescriptor> collection;
        if (notOverridden == null) {
            OverridingUtil.$$$reportNull$$$0(61);
        }
        if (notOverridden.size() < 2) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = notOverridden.iterator().next().getContainingDeclaration();
        return CollectionsKt.all(collection, (Function1)new Function1<CallableMemberDescriptor, Boolean>((DeclarationDescriptor)var1_1){
            final /* synthetic */ DeclarationDescriptor val$containingDeclaration;
            {
                this.val$containingDeclaration = declarationDescriptor;
            }

            public final Boolean invoke(CallableMemberDescriptor descriptor2) {
                return descriptor2.getContainingDeclaration() == this.val$containingDeclaration;
            }
        });
    }

    private static void createAndBindFakeOverrides(ClassDescriptor current, Collection<CallableMemberDescriptor> notOverridden, OverridingStrategy strategy) {
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(62);
        }
        if (notOverridden == null) {
            OverridingUtil.$$$reportNull$$$0(63);
        }
        if (strategy == null) {
            OverridingUtil.$$$reportNull$$$0(64);
        }
        if (OverridingUtil.allHasSameContainingDeclaration(notOverridden)) {
            notOverridden = notOverridden.iterator();
            while (notOverridden.hasNext()) {
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)notOverridden.next();
                OverridingUtil.createAndBindFakeOverride(Collections.singleton(callableMemberDescriptor), current, strategy);
            }
            return;
        }
        LinkedList<CallableMemberDescriptor> fromSuperQueue = new LinkedList<CallableMemberDescriptor>((Collection<CallableMemberDescriptor>)notOverridden);
        while (!fromSuperQueue.isEmpty()) {
            Object object = VisibilityUtilKt.findMemberWithMaxVisibility(fromSuperQueue);
            object = OverridingUtil.extractMembersOverridableInBothWays((CallableMemberDescriptor)object, fromSuperQueue, strategy);
            OverridingUtil.createAndBindFakeOverride(object, current, strategy);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMoreSpecific(CallableDescriptor a, CallableDescriptor b) {
        CallableDescriptor callableDescriptor;
        if (a == null) {
            OverridingUtil.$$$reportNull$$$0(65);
        }
        if (b == null) {
            OverridingUtil.$$$reportNull$$$0(66);
        }
        KotlinType aReturnType = a.getReturnType();
        KotlinType bReturnType = b.getReturnType();
        assert (aReturnType != null) : "Return type of " + a + " is null";
        assert (bReturnType != null) : "Return type of " + b + " is null";
        if (!OverridingUtil.isVisibilityMoreSpecific(a, b)) {
            return false;
        }
        TypeCheckerState checkerState = DEFAULT.createTypeCheckerState(a.getTypeParameters(), b.getTypeParameters());
        if (a instanceof FunctionDescriptor) {
            assert (b instanceof FunctionDescriptor) : "b is " + b.getClass();
            return OverridingUtil.isReturnTypeMoreSpecific(a, aReturnType, b, bReturnType, checkerState);
        }
        if (a instanceof PropertyDescriptor) {
            void var3_3;
            void var1_1;
            void var2_2;
            assert (b instanceof PropertyDescriptor) : "b is " + b.getClass();
            PropertyDescriptor pa = (PropertyDescriptor)a;
            PropertyDescriptor pb = (PropertyDescriptor)b;
            if (!OverridingUtil.isAccessorMoreSpecific(pa.getSetter(), pb.getSetter())) {
                return false;
            }
            if (pa.isVar() && pb.isVar()) {
                return AbstractTypeChecker.INSTANCE.equalTypes(checkerState, aReturnType.unwrap(), bReturnType.unwrap());
            }
            return (pa.isVar() || !pb.isVar()) && OverridingUtil.isReturnTypeMoreSpecific(a, (KotlinType)var2_2, (CallableDescriptor)var1_1, (KotlinType)var3_3, checkerState);
        }
        throw new IllegalArgumentException("Unexpected callable: " + callableDescriptor.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isVisibilityMoreSpecific(DeclarationDescriptorWithVisibility a, DeclarationDescriptorWithVisibility b) {
        Object object;
        void var1_1;
        Object result;
        if (a == null) {
            OverridingUtil.$$$reportNull$$$0(67);
        }
        if (b == null) {
            OverridingUtil.$$$reportNull$$$0(68);
        }
        return (result = DescriptorVisibilities.compare(a.getVisibility(), var1_1.getVisibility())) == null || (Integer)object >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAccessorMoreSpecific(PropertyAccessorDescriptor a, PropertyAccessorDescriptor b) {
        void var1_1;
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        if (a == null || b == null) {
            return true;
        }
        return OverridingUtil.isVisibilityMoreSpecific(propertyAccessorDescriptor, (DeclarationDescriptorWithVisibility)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isMoreSpecificThenAllOf(CallableDescriptor candidate, Collection<CallableDescriptor> descriptors) {
        Iterator iterator2;
        if (candidate == null) {
            OverridingUtil.$$$reportNull$$$0(69);
        }
        if (descriptors == null) {
            OverridingUtil.$$$reportNull$$$0(70);
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            CallableDescriptor descriptor2 = (CallableDescriptor)iterator2.next();
            if (OverridingUtil.isMoreSpecific(candidate, (CallableDescriptor)var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isReturnTypeMoreSpecific(CallableDescriptor a, KotlinType aReturnType, CallableDescriptor b, KotlinType bReturnType, TypeCheckerState typeCheckerState) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (a == null) {
            OverridingUtil.$$$reportNull$$$0(71);
        }
        if (aReturnType == null) {
            OverridingUtil.$$$reportNull$$$0(72);
        }
        if (var2_2 == null) {
            OverridingUtil.$$$reportNull$$$0(73);
        }
        if (bReturnType == null) {
            OverridingUtil.$$$reportNull$$$0(74);
        }
        if (typeCheckerState == null) {
            OverridingUtil.$$$reportNull$$$0(75);
        }
        return AbstractTypeChecker.INSTANCE.isSubtypeOf(typeCheckerState, var1_1.unwrap(), var3_3.unwrap());
    }

    /*
     * WARNING - void declaration
     */
    public static <H> H selectMostSpecificMember(Collection<H> overridables, Function1<H, CallableDescriptor> descriptorByHandle) {
        void var2_2;
        if (overridables == null) {
            OverridingUtil.$$$reportNull$$$0(76);
        }
        if (descriptorByHandle == null) {
            OverridingUtil.$$$reportNull$$$0(77);
        }
        assert (!overridables.isEmpty()) : "Should have at least one overridable descriptor";
        if (overridables.size() == 1) {
            Object object = CollectionsKt.first(overridables);
            if (object == null) {
                OverridingUtil.$$$reportNull$$$0(78);
            }
            return (H)object;
        }
        ArrayList candidates = new ArrayList(2);
        List callableMemberDescriptors = CollectionsKt.map(overridables, descriptorByHandle);
        Object transitivelyMostSpecific = CollectionsKt.first(overridables);
        CallableDescriptor transitivelyMostSpecificDescriptor = (CallableDescriptor)descriptorByHandle.invoke(transitivelyMostSpecific);
        overridables = overridables.iterator();
        while (overridables.hasNext()) {
            Object overridable = overridables.next();
            CallableDescriptor descriptor2 = (CallableDescriptor)descriptorByHandle.invoke(overridable);
            if (OverridingUtil.isMoreSpecificThenAllOf(descriptor2, callableMemberDescriptors)) {
                candidates.add(overridable);
            }
            if (!OverridingUtil.isMoreSpecific(descriptor2, transitivelyMostSpecificDescriptor) || OverridingUtil.isMoreSpecific(transitivelyMostSpecificDescriptor, descriptor2)) continue;
            transitivelyMostSpecific = overridable;
        }
        if (candidates.isEmpty()) {
            Object object = transitivelyMostSpecific;
            if (object == null) {
                OverridingUtil.$$$reportNull$$$0(79);
            }
            return (H)object;
        }
        if (candidates.size() == 1) {
            Object object = CollectionsKt.first(candidates);
            if (object == null) {
                OverridingUtil.$$$reportNull$$$0(80);
            }
            return (H)object;
        }
        Collection<Object> firstNonFlexible = null;
        for (Object candidate : candidates) {
            if (FlexibleTypesKt.isFlexible(((CallableDescriptor)descriptorByHandle.invoke(candidate)).getReturnType())) continue;
            firstNonFlexible = candidate;
            break;
        }
        if (firstNonFlexible != null) {
            Collection<Object> collection;
            Collection<H> collection2 = collection;
            if (collection2 == null) {
                OverridingUtil.$$$reportNull$$$0(81);
            }
            return (H)collection2;
        }
        Object object = CollectionsKt.first((Iterable)var2_2);
        if (object == null) {
            OverridingUtil.$$$reportNull$$$0(82);
        }
        return (H)object;
    }

    /*
     * WARNING - void declaration
     */
    private static void createAndBindFakeOverride(Collection<CallableMemberDescriptor> overridables, ClassDescriptor current, OverridingStrategy strategy) {
        void var1_1;
        void var2_2;
        Collection<CallableMemberDescriptor> collection;
        void var3_3;
        Collection<CallableMemberDescriptor> visibleOverridables;
        boolean allInvisible;
        if (overridables == null) {
            OverridingUtil.$$$reportNull$$$0(83);
        }
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(84);
        }
        if (strategy == null) {
            OverridingUtil.$$$reportNull$$$0(85);
        }
        Collection<CallableMemberDescriptor> effectiveOverridden = (allInvisible = (visibleOverridables = OverridingUtil.filterVisibleFakeOverrides(current, overridables)).isEmpty()) ? overridables : visibleOverridables;
        Modality modality = OverridingUtil.determineModalityForFakeOverride(effectiveOverridden, current);
        DescriptorVisibility visibility = allInvisible ? DescriptorVisibilities.INVISIBLE_FAKE : DescriptorVisibilities.INHERITED;
        CallableMemberDescriptor callableMemberDescriptor = OverridingUtil.selectMostSpecificMember(effectiveOverridden, new Function1<CallableMemberDescriptor, CallableDescriptor>(){

            public final CallableMemberDescriptor invoke(CallableMemberDescriptor descriptor2) {
                return descriptor2;
            }
        });
        CallableMemberDescriptor fakeOverride = callableMemberDescriptor.copy(current, (Modality)var3_3, visibility, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
        strategy.setOverriddenDescriptors(fakeOverride, collection);
        assert (!fakeOverride.getOverriddenDescriptors().isEmpty()) : "Overridden descriptors should be set for " + (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE);
        var2_2.addFakeOverride((CallableMemberDescriptor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Modality determineModalityForFakeOverride(Collection<CallableMemberDescriptor> descriptors, ClassDescriptor current) {
        void var1_1;
        Iterator<CallableMemberDescriptor> iterator2;
        void var3_4;
        boolean transformAbstractToClassModality;
        if (descriptors == null) {
            OverridingUtil.$$$reportNull$$$0(86);
        }
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(87);
        }
        boolean hasOpen = false;
        boolean hasAbstract = false;
        for (CallableMemberDescriptor descriptor2 : descriptors) {
            switch (descriptor2.getModality()) {
                case FINAL: {
                    Modality modality = Modality.FINAL;
                    if (modality == null) {
                        OverridingUtil.$$$reportNull$$$0(88);
                    }
                    return modality;
                }
                case SEALED: {
                    throw new IllegalStateException("Member cannot have SEALED modality: " + descriptor2);
                }
                case OPEN: {
                    hasOpen = true;
                    break;
                }
                case ABSTRACT: {
                    hasAbstract = true;
                }
            }
        }
        boolean bl = transformAbstractToClassModality = current.isExpect() && current.getModality() != Modality.ABSTRACT && current.getModality() != Modality.SEALED;
        if (hasOpen && !hasAbstract) {
            Modality modality = Modality.OPEN;
            if (modality == null) {
                OverridingUtil.$$$reportNull$$$0(89);
            }
            return modality;
        }
        if (!hasOpen && var3_4 != false) {
            Modality modality = transformAbstractToClassModality ? current.getModality() : Modality.ABSTRACT;
            if (modality == null) {
                OverridingUtil.$$$reportNull$$$0(90);
            }
            return modality;
        }
        HashSet<CallableMemberDescriptor> allOverriddenDeclarations = new HashSet<CallableMemberDescriptor>();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_3;
            CallableMemberDescriptor descriptor3 = (CallableMemberDescriptor)iterator2.next();
            allOverriddenDeclarations.addAll(OverridingUtil.getOverriddenDeclarations((CallableMemberDescriptor)var2_3));
        }
        return OverridingUtil.getMinimalModality(OverridingUtil.filterOutOverridden(allOverriddenDeclarations), transformAbstractToClassModality, var1_1.getModality());
    }

    /*
     * WARNING - void declaration
     */
    private static Modality getMinimalModality(Collection<CallableMemberDescriptor> descriptors, boolean transformAbstractToClassModality, Modality classModality) {
        void var3_3;
        Iterator<CallableMemberDescriptor> iterator2;
        if (descriptors == null) {
            OverridingUtil.$$$reportNull$$$0(91);
        }
        if (classModality == null) {
            OverridingUtil.$$$reportNull$$$0(92);
        }
        Modality result = Modality.ABSTRACT;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)iterator2.next();
            Modality effectiveModality = transformAbstractToClassModality && descriptor2.getModality() == Modality.ABSTRACT ? classModality : descriptor2.getModality();
            if (effectiveModality.compareTo(result) >= 0) continue;
            result = effectiveModality;
        }
        void v0 = var3_3;
        if (v0 == null) {
            OverridingUtil.$$$reportNull$$$0(93);
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<CallableMemberDescriptor> filterVisibleFakeOverrides(ClassDescriptor current, Collection<CallableMemberDescriptor> toFilter) {
        ClassDescriptor classDescriptor;
        void var1_1;
        if (current == null) {
            OverridingUtil.$$$reportNull$$$0(94);
        }
        if (toFilter == null) {
            OverridingUtil.$$$reportNull$$$0(95);
        }
        List list = CollectionsKt.filter((Iterable)var1_1, (Function1)new Function1<CallableMemberDescriptor, Boolean>(){

            /*
             * WARNING - void declaration
             */
            public final Boolean invoke(CallableMemberDescriptor descriptor2) {
                void var1_1;
                return !DescriptorVisibilities.isPrivate(descriptor2.getVisibility()) && DescriptorVisibilities.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)var1_1, classDescriptor, false);
            }
        });
        if (list == null) {
            OverridingUtil.$$$reportNull$$$0(96);
        }
        return list;
    }

    public static <H> Collection<H> extractMembersOverridableInBothWays(H overrider, Collection<H> extractFrom, Function1<H, CallableDescriptor> descriptorByHandle, Function1<H, Unit> onConflict) {
        if (overrider == null) {
            OverridingUtil.$$$reportNull$$$0(97);
        }
        if (extractFrom == null) {
            OverridingUtil.$$$reportNull$$$0(98);
        }
        if (descriptorByHandle == null) {
            OverridingUtil.$$$reportNull$$$0(99);
        }
        if (onConflict == null) {
            OverridingUtil.$$$reportNull$$$0(100);
        }
        ArrayList<H> overridable = new ArrayList<H>();
        overridable.add(overrider);
        CallableDescriptor overriderDescriptor = (CallableDescriptor)descriptorByHandle.invoke(overrider);
        Iterator<H> iterator2 = extractFrom.iterator();
        while (iterator2.hasNext()) {
            H candidate = iterator2.next();
            CallableDescriptor candidateDescriptor = (CallableDescriptor)descriptorByHandle.invoke(candidate);
            if (overrider == candidate) {
                iterator2.remove();
                continue;
            }
            OverrideCompatibilityInfo.Result finalResult = OverridingUtil.getBothWaysOverridability(overriderDescriptor, candidateDescriptor);
            if (finalResult == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
                overridable.add(candidate);
                iterator2.remove();
                continue;
            }
            if (finalResult != OverrideCompatibilityInfo.Result.CONFLICT) continue;
            onConflict.invoke(candidate);
            iterator2.remove();
        }
        return overridable;
    }

    /*
     * WARNING - void declaration
     */
    public static OverrideCompatibilityInfo.Result getBothWaysOverridability(CallableDescriptor overriderDescriptor, CallableDescriptor candidateDescriptor) {
        Object object;
        void var2_2;
        void var1_1;
        OverrideCompatibilityInfo.Result result1 = DEFAULT.isOverridableBy(candidateDescriptor, overriderDescriptor, null).getResult();
        Object result2 = DEFAULT.isOverridableBy(overriderDescriptor, (CallableDescriptor)var1_1, null).getResult();
        if (result1 == OverrideCompatibilityInfo.Result.OVERRIDABLE && result2 == OverrideCompatibilityInfo.Result.OVERRIDABLE) {
            return OverrideCompatibilityInfo.Result.OVERRIDABLE;
        }
        if (var2_2 == OverrideCompatibilityInfo.Result.CONFLICT || object == OverrideCompatibilityInfo.Result.CONFLICT) {
            return OverrideCompatibilityInfo.Result.CONFLICT;
        }
        return OverrideCompatibilityInfo.Result.INCOMPATIBLE;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<CallableMemberDescriptor> extractMembersOverridableInBothWays(CallableMemberDescriptor overrider, Queue<CallableMemberDescriptor> extractFrom, OverridingStrategy strategy) {
        CallableMemberDescriptor callableMemberDescriptor;
        void var2_2;
        void var1_1;
        if (overrider == null) {
            OverridingUtil.$$$reportNull$$$0(102);
        }
        if (extractFrom == null) {
            OverridingUtil.$$$reportNull$$$0(103);
        }
        if (strategy == null) {
            OverridingUtil.$$$reportNull$$$0(104);
        }
        return OverridingUtil.extractMembersOverridableInBothWays(overrider, var1_1, new Function1<CallableMemberDescriptor, CallableDescriptor>(){

            public final CallableDescriptor invoke(CallableMemberDescriptor descriptor2) {
                return descriptor2;
            }
        }, new Function1<CallableMemberDescriptor, Unit>((OverridingStrategy)var2_2, callableMemberDescriptor){
            final /* synthetic */ OverridingStrategy val$strategy;
            final /* synthetic */ CallableMemberDescriptor val$overrider;
            {
                this.val$strategy = overridingStrategy;
                this.val$overrider = callableMemberDescriptor;
            }

            /*
             * WARNING - void declaration
             */
            public final Unit invoke(CallableMemberDescriptor descriptor2) {
                void var1_1;
                this.val$strategy.inheritanceConflict(this.val$overrider, (CallableMemberDescriptor)var1_1);
                return Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void resolveUnknownVisibilityForMember(CallableMemberDescriptor memberDescriptor, Function1<CallableMemberDescriptor, Unit> cannotInferVisibility) {
        void var3_6;
        if (memberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(105);
        }
        for (CallableMemberDescriptor callableMemberDescriptor : memberDescriptor.getOverriddenDescriptors()) {
            if (callableMemberDescriptor.getVisibility() != DescriptorVisibilities.INHERITED) continue;
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, cannotInferVisibility);
        }
        if (memberDescriptor.getVisibility() != DescriptorVisibilities.INHERITED) {
            return;
        }
        DescriptorVisibility maxVisibility = OverridingUtil.computeVisibilityToInherit((CallableMemberDescriptor)((Object)memberDescriptor));
        if (maxVisibility == null) {
            if (cannotInferVisibility != null) {
                cannotInferVisibility.invoke((Object)memberDescriptor);
            }
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        } else {
            DescriptorVisibility descriptorVisibility = maxVisibility;
        }
        if (memberDescriptor instanceof PropertyDescriptorImpl) {
            ((PropertyDescriptorImpl)((Object)memberDescriptor)).setVisibility((DescriptorVisibility)var3_6);
            for (PropertyAccessorDescriptor propertyAccessorDescriptor : ((PropertyDescriptor)((Object)memberDescriptor)).getAccessors()) {
                OverridingUtil.resolveUnknownVisibilityForMember(propertyAccessorDescriptor, maxVisibility == null ? null : cannotInferVisibility);
            }
            return;
        }
        if (memberDescriptor instanceof FunctionDescriptorImpl) {
            ((FunctionDescriptorImpl)((Object)memberDescriptor)).setVisibility((DescriptorVisibility)var3_6);
            return;
        }
        assert (memberDescriptor instanceof PropertyAccessorDescriptorImpl);
        CallableMemberDescriptor propertyAccessorDescriptor = (PropertyAccessorDescriptorImpl)((Object)memberDescriptor);
        ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility((DescriptorVisibility)var3_6);
        if (var3_6 != ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).getCorrespondingProperty().getVisibility()) {
            CallableMemberDescriptor callableMemberDescriptor;
            ((PropertyAccessorDescriptorImpl)callableMemberDescriptor).setDefault(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DescriptorVisibility computeVisibilityToInherit(CallableMemberDescriptor memberDescriptor) {
        void var2_4;
        Object object;
        Collection<? extends CallableMemberDescriptor> collection;
        DescriptorVisibility maxVisibility;
        if (memberDescriptor == null) {
            OverridingUtil.$$$reportNull$$$0(106);
        }
        if ((maxVisibility = OverridingUtil.findMaxVisibility(collection = memberDescriptor.getOverriddenDescriptors())) == null) {
            return null;
        }
        if (object.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (CallableMemberDescriptor callableMemberDescriptor : collection) {
                if (callableMemberDescriptor.getModality() == Modality.ABSTRACT || callableMemberDescriptor.getVisibility().equals(maxVisibility)) continue;
                return null;
            }
            return maxVisibility;
        }
        return var2_4.normalize();
    }

    /*
     * WARNING - void declaration
     */
    public static DescriptorVisibility findMaxVisibility(Collection<? extends CallableMemberDescriptor> descriptors) {
        void var1_1;
        Collection<? extends CallableMemberDescriptor> collection;
        if (descriptors == null) {
            OverridingUtil.$$$reportNull$$$0(107);
        }
        if (descriptors.isEmpty()) {
            return DescriptorVisibilities.DEFAULT_VISIBILITY;
        }
        DescriptorVisibility maxVisibility = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            DescriptorVisibility visibility = callableMemberDescriptor.getVisibility();
            assert (visibility != DescriptorVisibilities.INHERITED) : "Visibility should have been computed for " + callableMemberDescriptor;
            if (maxVisibility == null) {
                maxVisibility = visibility;
                continue;
            }
            Integer n = DescriptorVisibilities.compare(visibility, maxVisibility);
            if (n == null) {
                maxVisibility = null;
                continue;
            }
            if (n <= 0) continue;
            maxVisibility = visibility;
        }
        if (maxVisibility == null) {
            return null;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : collection) {
            Integer compareResult = DescriptorVisibilities.compare(maxVisibility, callableMemberDescriptor.getVisibility());
            if (compareResult != null && compareResult >= 0) continue;
            return null;
        }
        return var1_1;
    }

    static {
        DEFAULT_TYPE_CONSTRUCTOR_EQUALITY = new KotlinTypeChecker.TypeConstructorEquality(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean equals(TypeConstructor a, TypeConstructor b) {
                void var2_2;
                void var1_1;
                if (a == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                return var1_1.equals(var2_2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "a";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "b";
                    }
                }
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$1";
                objectArray[2] = "equals";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DEFAULT = new OverridingUtil(DEFAULT_TYPE_CONSTRUCTOR_EQUALITY, KotlinTypeRefiner.Default.INSTANCE, KotlinTypePreparator.Default.INSTANCE, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypeRefiner";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinTypePreparator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSubtype";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityAxioms";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "axioms";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformFirst";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: 
            case 22: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superDescriptor";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDescriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstParameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondParameters";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInSuper";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInSub";
                break;
            }
            case 46: 
            case 49: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCheckerState";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeParameter";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTypeParameter";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromSupertypes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromCurrent";
                break;
            }
            case 53: 
            case 59: 
            case 62: 
            case 84: 
            case 87: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 54: 
            case 60: 
            case 64: 
            case 85: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriding";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromSuper";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCurrent";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsFromSuper";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notOverridden";
                break;
            }
            case 65: 
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 66: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 70: 
            case 86: 
            case 91: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aReturnType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bReturnType";
                break;
            }
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridables";
                break;
            }
            case 77: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorByHandle";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classModality";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFilter";
                break;
            }
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrider";
                break;
            }
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractFrom";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onConflict";
                break;
            }
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverrides";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenDeclarations";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isOverridableBy";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "isOverridableByWithoutExternalConditions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeCheckerState";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMostSpecificMember";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "determineModalityForFakeOverride";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimalModality";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "filterVisibleFakeOverrides";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMembersOverridableInBothWays";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWithTypeRefiner";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWithTypePreparatorAndCustomSubtype";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterOutOverridden";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterOverrides";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "overrides";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenDeclarations";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectOverriddenDeclarations";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableBy";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableByWithoutExternalConditions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getBasicOverridabilityProblem";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTypeCheckerState";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areTypesEquivalent";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areTypeParametersEquivalent";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateOverridesInFunctionGroup";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleForOverride";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "extractAndBindOverridesForMember";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "allHasSameContainingDeclaration";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createAndBindFakeOverrides";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecific";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isVisibilityMoreSpecific";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecificThenAllOf";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeMoreSpecific";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "selectMostSpecificMember";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createAndBindFakeOverride";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "determineModalityForFakeOverride";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalModality";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "filterVisibleFakeOverrides";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "extractMembersOverridableInBothWays";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnknownVisibilityForMember";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "computeVisibilityToInherit";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "findMaxVisibility";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 96: 
            case 101: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(Result.OVERRIDABLE, "SUCCESS");
        private final Result overridable;
        private final String debugMessage;

        public static OverrideCompatibilityInfo success() {
            OverrideCompatibilityInfo overrideCompatibilityInfo = SUCCESS;
            if (overrideCompatibilityInfo == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(0);
            }
            return overrideCompatibilityInfo;
        }

        public static OverrideCompatibilityInfo incompatible(String debugMessage) {
            String string;
            if (debugMessage == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(1);
            }
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, string);
        }

        public static OverrideCompatibilityInfo conflict(String debugMessage) {
            String string;
            if (debugMessage == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(2);
            }
            return new OverrideCompatibilityInfo(Result.CONFLICT, string);
        }

        /*
         * WARNING - void declaration
         */
        public OverrideCompatibilityInfo(Result success, String debugMessage) {
            void var2_2;
            void var1_1;
            if (success == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(3);
            }
            if (debugMessage == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(4);
            }
            this.overridable = var1_1;
            this.debugMessage = var2_2;
        }

        public Result getResult() {
            Result result = this.overridable;
            if (result == null) {
                OverrideCompatibilityInfo.$$$reportNull$$$0(5);
            }
            return result;
        }

        public String toString() {
            return (Object)((Object)this.overridable) + ": " + this.debugMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$OverrideCompatibilityInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "success";
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "success";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/OverridingUtil$OverrideCompatibilityInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugMessage";
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "incompatible";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "conflict";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                }
            }
            throw runtimeException;
        }

        public static enum Result {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }
}

