/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;

@SourceDebugExtension(value={"SMAP\ninlineClassesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1557#2:101\n1628#2,3:102\n1557#2:106\n1628#2,3:107\n1755#2,3:110\n1#3:105\n*S KotlinDebug\n*F\n+ 1 inlineClassesUtils.kt\norg/jetbrains/kotlin/resolve/InlineClassesUtilsKt\n*L\n39#1:101\n39#1:102,3\n56#1:106\n56#1:107,3\n67#1:110,3\n*E\n"})
public final class InlineClassesUtilsKt {
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID = ClassId.Companion.topLevel(JVM_INLINE_ANNOTATION_FQ_NAME);

    public static final boolean isInlineClass(DeclarationDescriptor $this$isInlineClass) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        return $this$isInlineClass instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(DeclarationDescriptor $this$isMultiFieldValueClass) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClass, (String)"<this>");
        return $this$isMultiFieldValueClass instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final boolean isValueClass(DeclarationDescriptor $this$isValueClass) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return InlineClassesUtilsKt.isInlineClass($this$isValueClass) || InlineClassesUtilsKt.isMultiFieldValueClass(declarationDescriptor);
    }

    public static final KotlinType unsubstitutedUnderlyingType(KotlinType $this$unsubstitutedUnderlyingType) {
        Annotated annotated;
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedUnderlyingType, (String)"<this>");
        annotated = annotated.getConstructor().getDeclarationDescriptor();
        Object object = annotated instanceof ClassDescriptor ? (ClassDescriptor)annotated : null;
        return object != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? (SimpleType)((InlineClassRepresentation)object).getUnderlyingType() : null;
    }

    public static final boolean isInlineClassType(KotlinType $this$isInlineClassType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return InlineClassesUtilsKt.isInlineClass(classifierDescriptor);
        }
        return false;
    }

    public static final boolean isValueClassType(KotlinType $this$isValueClassType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isValueClassType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return InlineClassesUtilsKt.isValueClass(classifierDescriptor);
        }
        return false;
    }

    public static final boolean needsMfvcFlattening(KotlinType $this$needsMfvcFlattening) {
        Intrinsics.checkNotNullParameter((Object)$this$needsMfvcFlattening, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$needsMfvcFlattening.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            KotlinType kotlinType;
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            return InlineClassesUtilsKt.isMultiFieldValueClass(classifierDescriptor) && !SimpleClassicTypeSystemContext.INSTANCE.isNullableType(kotlinType);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final KotlinType substitutedUnderlyingType(KotlinType $this$substitutedUnderlyingType) {
        Intrinsics.checkNotNullParameter((Object)$this$substitutedUnderlyingType, (String)"<this>");
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType($this$substitutedUnderlyingType);
        if (kotlinType != null) {
            void var1_1;
            KotlinType kotlinType2;
            KotlinType it = kotlinType;
            return TypeSubstitutor.create(kotlinType2).substitute((KotlinType)var1_1, Variance.INVARIANT);
        }
        return null;
    }

    public static final boolean isGetterOfUnderlyingPropertyOfValueClass(CallableDescriptor $this$isGetterOfUnderlyingPropertyOfValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isGetterOfUnderlyingPropertyOfValueClass, (String)"<this>");
        if ($this$isGetterOfUnderlyingPropertyOfValueClass instanceof PropertyGetterDescriptor) {
            CallableDescriptor callableDescriptor;
            PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)callableDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
            if (InlineClassesUtilsKt.isUnderlyingPropertyOfValueClass(propertyDescriptor)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isUnderlyingPropertyOfInlineClass(VariableDescriptor $this$isUnderlyingPropertyOfInlineClass) {
        VariableDescriptor variableDescriptor;
        DeclarationDescriptor declarationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfInlineClass, (String)"<this>");
        return $this$isUnderlyingPropertyOfInlineClass.getExtensionReceiverParameter() == null && Intrinsics.areEqual((Object)((object = (declarationDescriptor = $this$isUnderlyingPropertyOfInlineClass.getContainingDeclaration()) instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? ((InlineClassRepresentation)object).getUnderlyingPropertyName() : null), (Object)variableDescriptor.getName());
    }

    public static final boolean isUnderlyingPropertyOfValueClass(VariableDescriptor $this$isUnderlyingPropertyOfValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnderlyingPropertyOfValueClass, (String)"<this>");
        if ($this$isUnderlyingPropertyOfValueClass.getExtensionReceiverParameter() == null) {
            boolean bl;
            DeclarationDescriptor declarationDescriptor = $this$isUnderlyingPropertyOfValueClass.getContainingDeclaration();
            Object object = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (object != null && (object = object.getValueClassRepresentation()) != null) {
                VariableDescriptor variableDescriptor;
                Name name = variableDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                bl = ((ValueClassRepresentation)object).containsPropertyWithName(name);
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }
}

