/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class DescriptorUtils {
    public static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");

    private DescriptorUtils() {
    }

    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            DescriptorUtils.$$$reportNull$$$0(0);
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor;
            declarationDescriptor = (ClassDescriptor)declarationDescriptor;
            return declarationDescriptor.getThisAsReceiverParameter();
        }
        return null;
    }

    public static boolean isLocal(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor current;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(1);
        }
        while (current != null) {
            if (DescriptorUtils.isAnonymousObject(current) || DescriptorUtils.isDescriptorWithLocalVisibility(current)) {
                return true;
            }
            current = current.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isDescriptorWithLocalVisibility(DeclarationDescriptor current) {
        DeclarationDescriptor declarationDescriptor;
        return current instanceof DeclarationDescriptorWithVisibility && ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility() == DescriptorVisibilities.LOCAL;
    }

    /*
     * WARNING - void declaration
     */
    public static FqNameUnsafe getFqName(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        FqName safe;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(2);
        }
        if ((safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2)) != null) {
            void var1_1;
            return var1_1.toUnsafe();
        }
        return DescriptorUtils.getFqNameUnsafe(declarationDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public static FqName getFqNameSafe(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        void var1_1;
        FqName safe;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(3);
        }
        Object object = (safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor2)) != null ? var1_1 : DescriptorUtils.getFqNameUnsafe(declarationDescriptor).toSafe();
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(4);
        }
        return object;
    }

    private static FqName getFqNameSafeIfPossible(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(5);
        }
        if (descriptor2 instanceof ModuleDescriptor || ErrorUtils.isError(descriptor2)) {
            return FqName.ROOT;
        }
        if (descriptor2 instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor2).getFqName();
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            DeclarationDescriptor declarationDescriptor;
            return ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        void var1_1;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration != null) : "Not package/module descriptor doesn't have containing declaration: " + descriptor2;
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)var1_1).child(declarationDescriptor.getName());
        if (fqNameUnsafe == null) {
            DescriptorUtils.$$$reportNull$$$0(7);
        }
        return fqNameUnsafe;
    }

    public static boolean isTopLevelDeclaration(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        return descriptor2 != null && declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areInSameModule(DeclarationDescriptor first, DeclarationDescriptor second) {
        void var1_1;
        DeclarationDescriptor declarationDescriptor;
        if (first == null) {
            DescriptorUtils.$$$reportNull$$$0(16);
        }
        if (second == null) {
            DescriptorUtils.$$$reportNull$$$0(17);
        }
        return DescriptorUtils.getContainingModule(declarationDescriptor).equals(DescriptorUtils.getContainingModule((DeclarationDescriptor)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <D extends DeclarationDescriptor> D getParentOfType(DeclarationDescriptor descriptor2, Class<D> aClass) {
        void var1_1;
        DeclarationDescriptor declarationDescriptor;
        if (aClass == null) {
            DescriptorUtils.$$$reportNull$$$0(18);
        }
        return DescriptorUtils.getParentOfType(declarationDescriptor, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <D extends DeclarationDescriptor> D getParentOfType(DeclarationDescriptor descriptor2, Class<D> aClass, boolean strict) {
        void var2_2;
        if (aClass == null) {
            DescriptorUtils.$$$reportNull$$$0(19);
        }
        if (descriptor2 == null) {
            return null;
        }
        if (var2_2 != false) {
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        while (descriptor2 != null) {
            if (aClass.isInstance(descriptor2)) {
                return (D)descriptor2;
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return null;
    }

    public static ModuleDescriptor getContainingModuleOrNull(KotlinType kotlinType) {
        Annotated annotated;
        Annotated descriptor2;
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(20);
        }
        if ((descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        return DescriptorUtils.getContainingModuleOrNull((DeclarationDescriptor)annotated);
    }

    /*
     * WARNING - void declaration
     */
    public static ModuleDescriptor getContainingModule(DeclarationDescriptor descriptor2) {
        void var1_1;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(21);
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        if (!$assertionsDisabled && module == null) {
            DeclarationDescriptor declarationDescriptor;
            throw new AssertionError((Object)("Descriptor without a containing module: " + declarationDescriptor));
        }
        void v0 = var1_1;
        if (v0 == null) {
            DescriptorUtils.$$$reportNull$$$0(22);
        }
        return v0;
    }

    public static ModuleDescriptor getContainingModuleOrNull(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(23);
        }
        while (descriptor2 != null) {
            if (descriptor2 instanceof ModuleDescriptor) {
                return (ModuleDescriptor)descriptor2;
            }
            if (descriptor2 instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)descriptor2).getModule();
            }
            descriptor2 = descriptor2.getContainingDeclaration();
        }
        return null;
    }

    public static boolean isDirectSubclass(ClassDescriptor subClass, ClassDescriptor superClass) {
        Object object;
        if (subClass == null) {
            DescriptorUtils.$$$reportNull$$$0(26);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(27);
        }
        for (KotlinType kotlinType : object.getTypeConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSameClass(kotlinType, superClass.getOriginal())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSubclass(ClassDescriptor subClass, ClassDescriptor superClass) {
        void var1_1;
        ClassDescriptor classDescriptor;
        if (subClass == null) {
            DescriptorUtils.$$$reportNull$$$0(28);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(29);
        }
        return DescriptorUtils.isSubtypeOfClass(classDescriptor.getDefaultType(), var1_1.getOriginal());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isSameClass(KotlinType type, DeclarationDescriptor other) {
        Annotated annotated;
        void var1_1;
        Annotated originalDescriptor;
        Annotated descriptor2;
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(30);
        }
        if (other == null) {
            DescriptorUtils.$$$reportNull$$$0(31);
        }
        return (descriptor2 = type.getConstructor().getDeclarationDescriptor()) != null && (originalDescriptor = descriptor2.getOriginal()) instanceof ClassifierDescriptor && other instanceof ClassifierDescriptor && ((ClassifierDescriptor)var1_1).getTypeConstructor().equals(((ClassifierDescriptor)annotated).getTypeConstructor());
    }

    public static boolean isSubtypeOfClass(KotlinType type, DeclarationDescriptor superClass) {
        Object object;
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(32);
        }
        if (superClass == null) {
            DescriptorUtils.$$$reportNull$$$0(33);
        }
        if (DescriptorUtils.isSameClass(type, superClass)) {
            return true;
        }
        for (KotlinType kotlinType : ((KotlinType)object).getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(kotlinType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompanionObject(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.OBJECT) && ((ClassDescriptor)declarationDescriptor).isCompanionObject();
    }

    public static boolean isSealedClass(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        return (DescriptorUtils.isKindOf(descriptor2, ClassKind.CLASS) || DescriptorUtils.isKindOf(descriptor2, ClassKind.INTERFACE)) && ((ClassDescriptor)declarationDescriptor).getModality() == Modality.SEALED;
    }

    public static boolean isAnonymousObject(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(34);
        }
        return DescriptorUtils.isClass(descriptor2) && declarationDescriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isEnumEntry(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(36);
        }
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isEnumClass(DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isInterface(DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.INTERFACE);
    }

    public static boolean isClass(DeclarationDescriptor descriptor2) {
        return DescriptorUtils.isKindOf(descriptor2, ClassKind.CLASS);
    }

    public static boolean isClassOrEnumClass(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        return DescriptorUtils.isClass(descriptor2) || DescriptorUtils.isEnumClass(declarationDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isKindOf(DeclarationDescriptor descriptor2, ClassKind classKind) {
        void var1_1;
        DeclarationDescriptor declarationDescriptor;
        if (classKind == null) {
            DescriptorUtils.$$$reportNull$$$0(37);
        }
        return descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getKind() == var1_1;
    }

    public static ClassDescriptor getSuperClassDescriptor(ClassDescriptor classDescriptor) {
        Iterator<KotlinType> iterator2;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(44);
        }
        iterator2 = iterator2.getTypeConstructor().getSupertypes();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            KotlinType kotlinType = iterator2.next();
            ClassDescriptor superClassDescriptor = DescriptorUtils.getClassDescriptorForType(kotlinType);
            if (superClassDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return kotlinType;
        }
        return null;
    }

    public static ClassDescriptor getClassDescriptorForType(KotlinType type) {
        KotlinType kotlinType;
        if (type == null) {
            DescriptorUtils.$$$reportNull$$$0(45);
        }
        return DescriptorUtils.getClassDescriptorForTypeConstructor(kotlinType.getConstructor());
    }

    /*
     * WARNING - void declaration
     */
    public static ClassDescriptor getClassDescriptorForTypeConstructor(TypeConstructor typeConstructor2) {
        void var1_1;
        if (typeConstructor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(46);
        }
        ClassifierDescriptor descriptor2 = typeConstructor2.getDeclarationDescriptor();
        if (!$assertionsDisabled && !(descriptor2 instanceof ClassDescriptor)) {
            TypeConstructor typeConstructor3;
            throw new AssertionError((Object)("Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor3));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)var1_1;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(47);
        }
        return classDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public static DescriptorVisibility getDefaultConstructorVisibility(ClassDescriptor classDescriptor, boolean freedomForSealedInterfacesSupported) {
        void var2_2;
        ClassDescriptor classDescriptor2;
        ClassKind classKind;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(48);
        }
        if ((classKind = classDescriptor.getKind()) == ClassKind.ENUM_CLASS || classKind.isSingleton()) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(49);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isSealedClass(classDescriptor)) {
            void var1_1;
            if (var1_1 != false) {
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                if (descriptorVisibility == null) {
                    DescriptorUtils.$$$reportNull$$$0(50);
                }
                return descriptorVisibility;
            }
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(51);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor2)) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.DEFAULT_VISIBILITY;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(52);
            }
            return descriptorVisibility;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.INTERFACE || var2_2 == ClassKind.ANNOTATION_CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        if (descriptorVisibility == null) {
            DescriptorUtils.$$$reportNull$$$0(53);
        }
        return descriptorVisibility;
    }

    /*
     * WARNING - void declaration
     */
    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(D descriptor2) {
        D d;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(59);
        }
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            void var1_1;
            Collection<? extends CallableMemberDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            descriptor2 = (CallableMemberDescriptor)var1_1.iterator().next();
        }
        D d2 = d;
        if (d2 == null) {
            DescriptorUtils.$$$reportNull$$$0(60);
        }
        return d2;
    }

    public static <D extends DeclarationDescriptorWithVisibility> D unwrapFakeOverrideToAnyDeclaration(D descriptor2) {
        D d;
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(64);
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            return (D)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
        }
        D d2 = d;
        if (d2 == null) {
            DescriptorUtils.$$$reportNull$$$0(65);
        }
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean shouldRecordInitializerForProperty(VariableDescriptor variable, KotlinType type) {
        block8: {
            block7: {
                void var1_1;
                KotlinBuiltIns kotlinBuiltIns;
                if (variable == null) {
                    DescriptorUtils.$$$reportNull$$$0(66);
                }
                if (type == null) {
                    DescriptorUtils.$$$reportNull$$$0(67);
                }
                if (variable.isVar() || KotlinTypeKt.isError(type)) {
                    return false;
                }
                if (TypeUtils.acceptsNullable(type)) {
                    return true;
                }
                KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(variable);
                if (KotlinBuiltIns.isPrimitiveType(type) || KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getStringType(), type) || KotlinTypeChecker.DEFAULT.equalTypes(builtIns.getNumber().getDefaultType(), type) || KotlinTypeChecker.DEFAULT.equalTypes(kotlinBuiltIns.getAnyType(), type)) break block7;
                if (!UnsignedTypes.isUnsignedType((KotlinType)var1_1)) break block8;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(D f) {
        void var1_1;
        D d;
        if (f == null) {
            DescriptorUtils.$$$reportNull$$$0(71);
        }
        LinkedHashSet result = new LinkedHashSet();
        DescriptorUtils.collectAllOverriddenDescriptors(d.getOriginal(), result);
        return var1_1;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(D current, Set<D> result) {
        Object object;
        if (current == null) {
            DescriptorUtils.$$$reportNull$$$0(73);
        }
        if (result == null) {
            DescriptorUtils.$$$reportNull$$$0(74);
        }
        if (result.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : object.getOriginal().getOverriddenDescriptors()) {
            CallableDescriptor callableDescriptor2 = callableDescriptor.getOriginal();
            DescriptorUtils.collectAllOverriddenDescriptors(callableDescriptor2, result);
            result.add(callableDescriptor2);
        }
    }

    public static SourceFile getContainingSourceFile(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(82);
        }
        if (descriptor2 instanceof PropertySetterDescriptor) {
            descriptor2 = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
        }
        if (descriptor2 instanceof DeclarationDescriptorWithSource) {
            DeclarationDescriptor declarationDescriptor;
            SourceFile sourceFile = ((DeclarationDescriptorWithSource)declarationDescriptor).getSource().getContainingFile();
            if (sourceFile == null) {
                DescriptorUtils.$$$reportNull$$$0(83);
            }
            return sourceFile;
        }
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        if (sourceFile == null) {
            DescriptorUtils.$$$reportNull$$$0(84);
        }
        return sourceFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 64: 
            case 82: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 30: 
            case 32: 
            case 45: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKind";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 68: 
            case 69: 
            case 70: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 85: 
            case 87: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 88: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameSafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameUnsafe";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameFromTopLevelClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassIdForNonLocalClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingModule";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassDescriptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructorVisibility";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverride";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSubstitutionOverride";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDescriptors";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDeclarations";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingSourceFile";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionByName";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByName";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMember";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFqName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafe";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafeIfPossible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameUnsafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameFromTopLevelClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassIdForNonLocalClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOverride";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStaticDeclaration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "areInSameModule";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModuleOrNull";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDirectSubclass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSameClass";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfClass";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousObject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousFunction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEnumEntry";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasAbstractMembers";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassDescriptors";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassDescriptor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructorVisibility";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassByName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isStaticNestedClass";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelOrInnerClass";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverride";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSubstitutionOverride";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordInitializerForProperty";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractFakeOverride";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractDeclaration";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveOpenMembers";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDescriptors";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "collectAllOverriddenDescriptors";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDeclarations";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isSingletonOrAnonymousObject";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDeclaredConstructors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getJvmName";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findJvmNameAnnotation";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "hasJvmNameAnnotation";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getContainingSourceFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getAllDescriptors";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByName";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByNameOrNull";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByName";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMember";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isMethodOfAny";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

