/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorNonRoot;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FieldDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$$Lambda$5;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.PropertyAccessorRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nDescriptorRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DescriptorRendererImpl.kt\norg/jetbrains/kotlin/renderer/DescriptorRendererImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1225:1\n152#1,10:1226\n152#1,10:1236\n2632#2,3:1246\n774#2:1249\n865#2,2:1250\n1557#2:1252\n1628#2,3:1253\n774#2:1256\n865#2,2:1257\n1557#2:1259\n1628#2,3:1260\n1557#2:1263\n1628#2,3:1264\n1611#2,9:1268\n1863#2:1277\n1864#2:1279\n1620#2:1280\n2632#2,3:1281\n2632#2,3:1284\n774#2:1287\n865#2,2:1288\n1628#2,3:1290\n1#3:1267\n1#3:1278\n*S KotlinDebug\n*F\n+ 1 DescriptorRendererImpl.kt\norg/jetbrains/kotlin/renderer/DescriptorRendererImpl\n*L\n138#1:1226,10\n145#1:1236,10\n200#1:1246,3\n501#1:1249\n501#1:1250,2\n502#1:1252\n502#1:1253,3\n504#1:1256\n504#1:1257,2\n504#1:1259\n504#1:1260,3\n506#1:1263\n506#1:1264,3\n515#1:1268,9\n515#1:1277\n515#1:1279\n515#1:1280\n606#1:1281,3\n608#1:1284,3\n824#1:1287\n824#1:1288,2\n847#1:1290,3\n515#1:1278\n*E\n"})
public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    private final DescriptorRendererOptionsImpl options;
    private final Lazy functionTypeAnnotationsRenderer$delegate;

    /*
     * WARNING - void declaration
     */
    public DescriptorRendererImpl(DescriptorRendererOptionsImpl options) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = var1_1;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DescriptorRendererImpl descriptorRendererImpl = this;
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)new DescriptorRendererImpl$$Lambda$0(descriptorRendererImpl));
    }

    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public final boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setRenderCompanionObjectName(boolean bl) {
        void var1_1;
        this.options.setRenderCompanionObjectName((boolean)var1_1);
    }

    public final ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setClassifierNamePolicy(ClassifierNamePolicy classifierNamePolicy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)classifierNamePolicy, (String)"<set-?>");
        this.options.setClassifierNamePolicy((ClassifierNamePolicy)var1_1);
    }

    public final boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setWithDefinedIn(boolean bl) {
        void var1_1;
        this.options.setWithDefinedIn((boolean)var1_1);
    }

    public final boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public final Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setModifiers(Set<? extends DescriptorRendererModifier> set) {
        void var1_1;
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.options.setModifiers((Set<? extends DescriptorRendererModifier>)var1_1);
    }

    public final boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setStartFromName(boolean bl) {
        void var1_1;
        this.options.setStartFromName((boolean)var1_1);
    }

    public final boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    @Override
    public final boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setDebugMode(boolean bl) {
        void var1_1;
        this.options.setDebugMode((boolean)var1_1);
    }

    public final boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    public final boolean getVerbose() {
        return this.options.getVerbose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setVerbose(boolean bl) {
        void var1_1;
        this.options.setVerbose((boolean)var1_1);
    }

    public final boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public final boolean getEnhancedTypes() {
        return this.options.getEnhancedTypes();
    }

    public final boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public final boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    public final boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public final boolean getRenderDefaultModality() {
        return this.options.getRenderDefaultModality();
    }

    public final boolean getRenderConstructorDelegation() {
        return this.options.getRenderConstructorDelegation();
    }

    public final boolean getRenderPrimaryConstructorParametersAsProperties() {
        return this.options.getRenderPrimaryConstructorParametersAsProperties();
    }

    public final boolean getActualPropertiesInPrimaryConstructor() {
        return this.options.getActualPropertiesInPrimaryConstructor();
    }

    public final boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public final OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    public final DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public final RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTextFormat(RenderingFormat renderingFormat) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)renderingFormat), (String)"<set-?>");
        this.options.setTextFormat((RenderingFormat)var1_1);
    }

    public final Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public final Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setExcludedTypeAnnotationClasses(Set<FqName> set) {
        void var1_1;
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.options.setExcludedTypeAnnotationClasses((Set<FqName>)var1_1);
    }

    public final Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public final boolean getEachAnnotationOnNewLine() {
        return this.options.getEachAnnotationOnNewLine();
    }

    @Override
    public final AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)annotationArgumentsRenderingPolicy), (String)"<set-?>");
        this.options.setAnnotationArgumentsRenderingPolicy((AnnotationArgumentsRenderingPolicy)var1_1);
    }

    @Override
    public final boolean getIncludeAnnotationArguments() {
        return ((DescriptorRendererOptions)this.options).getIncludeAnnotationArguments();
    }

    @Override
    public final boolean getIncludeEmptyAnnotationArguments() {
        return ((DescriptorRendererOptions)this.options).getIncludeEmptyAnnotationArguments();
    }

    public final boolean getBoldOnlyForNamesInHtml() {
        return this.options.getBoldOnlyForNamesInHtml();
    }

    public final boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    public final ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setParameterNameRenderingPolicy(ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)parameterNameRenderingPolicy), (String)"<set-?>");
        this.options.setParameterNameRenderingPolicy((ParameterNameRenderingPolicy)var1_1);
    }

    public final boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setWithoutTypeParameters(boolean bl) {
        void var1_1;
        this.options.setWithoutTypeParameters((boolean)var1_1);
    }

    public final boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setReceiverAfterName(boolean bl) {
        void var1_1;
        this.options.setReceiverAfterName((boolean)var1_1);
    }

    public final boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setWithoutSuperTypes(boolean bl) {
        void var1_1;
        this.options.setWithoutSuperTypes((boolean)var1_1);
    }

    public final Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public final Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    public final boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public final PropertyAccessorRenderingPolicy getPropertyAccessorRenderingPolicy() {
        return this.options.getPropertyAccessorRenderingPolicy();
    }

    public final boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public final boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    public final boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public final boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public final boolean getRenderTypeExpansions() {
        return this.options.getRenderTypeExpansions();
    }

    public final boolean getRenderAbbreviatedTypeComments() {
        return this.options.getRenderAbbreviatedTypeComments();
    }

    public final boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public final boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public final boolean getPresentableUnresolvedTypes() {
        return this.options.getPresentableUnresolvedTypes();
    }

    public final boolean getInformativeErrorType() {
        return this.options.getInformativeErrorType();
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        return (DescriptorRendererImpl)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String renderKeyword(String keyword) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                void var1_1;
                if (this.getBoldOnlyForNamesInHtml()) {
                    return keyword;
                }
                return "<b>" + (String)var1_1 + "</b>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final String renderError(String keyword) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                void var1_1;
                return "<font color=red><b>" + (String)var1_1 + "</b></font>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final String escape(String string) {
        void var1_1;
        return this.getTextFormat().escape((String)var1_1);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return this.escape("->");
            }
            case 2: {
                return "&rarr;";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final String renderMessage(String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return message;
            }
            case 2: {
                void var1_1;
                return "<i>" + (String)var1_1 + "</i>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderName(Name name, boolean rootRenderedElement) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String escaped = this.escape(RenderingUtilsKt.render(name));
        if (this.getBoldOnlyForNamesInHtml() && this.getTextFormat() == RenderingFormat.HTML && var2_2 != false) {
            return "<b>" + escaped + "</b>";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder, boolean rootRenderedElement) {
        void var3_3;
        void var1_1;
        Name name = var1_1.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        builder.append(((DescriptorRenderer)this).renderName(name, (boolean)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                void var3_3;
                builder.append("of ");
                Name name = var3_3.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                builder.append(((DescriptorRenderer)this).renderName(name, false));
            }
        }
        if (this.getVerbose() || !Intrinsics.areEqual((Object)descriptor2.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            void var2_2;
            void var1_1;
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = var1_1.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
            var2_2.append(((DescriptorRenderer)this).renderName(name, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderFqName(FqNameUnsafe fqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        List<Name> list = var1_1.pathSegments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"pathSegments(...)");
        return this.renderFqName(list);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFqName(List<Name> pathSegments) {
        void var1_1;
        return this.escape(RenderingUtilsKt.renderFqName((List<Name>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final String renderClassifierName(ClassifierDescriptor klass) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        return this.getClassifierNamePolicy().renderClassifier((ClassifierDescriptor)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderType(KotlinType type) {
        void var1_1;
        void var3_3;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        StringBuilder $this$renderType_u24lambda_u242 = stringBuilder = new StringBuilder();
        this.renderNormalizedType((StringBuilder)var3_3, (KotlinType)this.getTypeNormalizer().invoke((Object)var1_1));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNormalizedType(StringBuilder $this$renderNormalizedType, KotlinType type) {
        void var2_2;
        void var1_1;
        UnwrappedType unwrappedType = type.unwrap();
        AbbreviatedType abbreviated = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null;
        if (abbreviated != null) {
            if (this.getRenderTypeExpansions()) {
                this.renderNormalizedTypeAsIs($this$renderNormalizedType, abbreviated.getExpandedType());
                if (this.getRenderAbbreviatedTypeComments()) {
                    this.renderAbbreviatedTypeComment($this$renderNormalizedType, abbreviated);
                    return;
                }
            } else {
                this.renderNormalizedTypeAsIs($this$renderNormalizedType, abbreviated.getAbbreviation());
                if (this.getRenderUnabbreviatedType()) {
                    this.renderExpandedTypeComment($this$renderNormalizedType, (AbbreviatedType)unwrappedType);
                }
            }
            return;
        }
        this.renderNormalizedTypeAsIs((StringBuilder)var1_1, (KotlinType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAbbreviatedTypeComment(StringBuilder $this$renderAbbreviatedTypeComment, AbbreviatedType abbreviated) {
        void var2_2;
        void var1_1;
        void this_$iv;
        DescriptorRendererImpl descriptorRendererImpl = this;
        StringBuilder $this$renderInBlockComment$iv = $this$renderAbbreviatedTypeComment;
        if (this_$iv.getTextFormat() == RenderingFormat.HTML) {
            $this$renderInBlockComment$iv.append("<font color=\"808080\"><i>");
        }
        $this$renderInBlockComment$iv.append(" /* ");
        $this$renderAbbreviatedTypeComment.append("from: ");
        this.renderNormalizedTypeAsIs((StringBuilder)var1_1, var2_2.getAbbreviation());
        $this$renderInBlockComment$iv.append(" */");
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            $this$renderInBlockComment$iv.append("</i></font>");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderExpandedTypeComment(StringBuilder $this$renderExpandedTypeComment, AbbreviatedType abbreviated) {
        void var2_2;
        void var1_1;
        void this_$iv;
        DescriptorRendererImpl descriptorRendererImpl = this;
        StringBuilder $this$renderInBlockComment$iv = $this$renderExpandedTypeComment;
        if (this_$iv.getTextFormat() == RenderingFormat.HTML) {
            $this$renderInBlockComment$iv.append("<font color=\"808080\"><i>");
        }
        $this$renderInBlockComment$iv.append(" /* ");
        $this$renderExpandedTypeComment.append("= ");
        this.renderNormalizedTypeAsIs((StringBuilder)var1_1, var2_2.getExpandedType());
        $this$renderInBlockComment$iv.append(" */");
        if (descriptorRendererImpl.getTextFormat() == RenderingFormat.HTML) {
            $this$renderInBlockComment$iv.append("</i></font>");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNormalizedTypeAsIs(StringBuilder $this$renderNormalizedTypeAsIs, KotlinType type) {
        if (type instanceof WrappedType && this.getDebugMode() && !((WrappedType)type).isComputed()) {
            $this$renderNormalizedTypeAsIs.append("<Not computed yet>");
            return;
        }
        UnwrappedType unwrappedType = type.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            $this$renderNormalizedTypeAsIs.append(((FlexibleType)unwrappedType).render(this, this));
            return;
        }
        if (unwrappedType instanceof SimpleType) {
            void var2_2;
            void var1_1;
            this.renderSimpleType((StringBuilder)var1_1, (SimpleType)var2_2);
            return;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSimpleType(StringBuilder $this$renderSimpleType, SimpleType type) {
        void var2_2;
        void var1_1;
        if (Intrinsics.areEqual((Object)type, (Object)TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type)) {
            $this$renderSimpleType.append("???");
            return;
        }
        if (ErrorUtils.isUninferredTypeVariable(type)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type.getConstructor();
                Intrinsics.checkNotNull((Object)typeConstructor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
                $this$renderSimpleType.append(this.renderError(((ErrorTypeConstructor)typeConstructor2).getParam(0)));
                return;
            }
            $this$renderSimpleType.append("???");
            return;
        }
        if (KotlinTypeKt.isError(type)) {
            this.renderDefaultType($this$renderSimpleType, type);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(type)) {
            this.renderFunctionType($this$renderSimpleType, type);
            return;
        }
        this.renderDefaultType((StringBuilder)var1_1, (KotlinType)var2_2);
    }

    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type) {
        if (FunctionTypesKt.isBuiltinFunctionalType(type)) {
            boolean bl;
            Iterable $this$none$iv = type.getArguments();
            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) {
                Iterator iterator2;
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    Object object = iterator2.next();
                    if (!(object = (TypeProjection)object).isStarProjection()) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderFlexibleType(String lowerRendered, String upperRendered, KotlinBuiltIns builtIns) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)lowerRendered, (String)"lowerRendered");
        Intrinsics.checkNotNullParameter((Object)upperRendered, (String)"upperRendered");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return "(" + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = builtIns.getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getCollection(...)");
        String kotlinCollectionsPrefix = StringsKt.substringBefore$default((String)classifierNamePolicy.renderClassifier(classDescriptor, this), (String)"Collection", null, (int)2, null);
        String mutablePrefix = "Mutable";
        String string2 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string2 != null) {
            return string2;
        }
        String string3 = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string3 != null) {
            return string3;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = builtIns.getArray();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"getArray(...)");
        String kotlinPrefix = StringsKt.substringBefore$default((String)classifierNamePolicy2.renderClassifier(classDescriptor2, this), (String)"Array", null, (int)2, null);
        string = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), string + this.escape("Array<(out) "));
        if (string != null) {
            return string;
        }
        return "(" + (String)var1_1 + ".." + (String)var2_2 + ')';
    }

    /*
     * WARNING - void declaration
     */
    public final String renderTypeArguments(List<? extends TypeProjection> typeArguments) {
        void var3_3;
        void var1_1;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $this$renderTypeArguments_u24lambda_u246 = stringBuilder = new StringBuilder();
        stringBuilder.append(this.lt());
        this.appendTypeProjections($this$renderTypeArguments_u24lambda_u246, (List<? extends TypeProjection>)var1_1);
        var3_3.append(this.gt());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderDefaultType(StringBuilder $this$renderDefaultType, KotlinType type) {
        void var2_2;
        SimpleType originalTypeOfDefNotNullType;
        DescriptorRendererImpl.renderAnnotations$default(this, $this$renderDefaultType, type, null, 2, null);
        DefinitelyNotNullType definitelyNotNullType = type instanceof DefinitelyNotNullType ? (DefinitelyNotNullType)type : null;
        SimpleType simpleType = originalTypeOfDefNotNullType = definitelyNotNullType != null ? definitelyNotNullType.getOriginal() : null;
        if (KotlinTypeKt.isError(type)) {
            if (TypeUtilsKt.isUnresolvedType(type) && this.getPresentableUnresolvedTypes()) {
                $this$renderDefaultType.append(this.renderError(ErrorUtils.INSTANCE.unresolvedTypeAsItIs(type)));
            } else {
                if (type instanceof ErrorType && !this.getInformativeErrorType()) {
                    $this$renderDefaultType.append(((ErrorType)type).getDebugMessage());
                } else {
                    $this$renderDefaultType.append(type.getConstructor().toString());
                }
                $this$renderDefaultType.append(this.renderTypeArguments(type.getArguments()));
            }
        } else if (type instanceof StubTypeForBuilderInference) {
            $this$renderDefaultType.append(((StubTypeForBuilderInference)type).getOriginalTypeVariable().toString());
        } else if (originalTypeOfDefNotNullType instanceof StubTypeForBuilderInference) {
            void var3_3;
            $this$renderDefaultType.append(((StubTypeForBuilderInference)var3_3).getOriginalTypeVariable().toString());
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, $this$renderDefaultType, type, null, 2, null);
        }
        if (type.isMarkedNullable()) {
            $this$renderDefaultType.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType((KotlinType)var2_2)) {
            void var1_1;
            var1_1.append(" & Any");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeConstructorAndArguments(StringBuilder $this$renderTypeConstructorAndArguments, KotlinType type, TypeConstructor typeConstructor2) {
        void var1_1;
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type);
        if (possiblyInnerType == null) {
            void var2_2;
            void var3_3;
            $this$renderTypeConstructorAndArguments.append(this.renderTypeConstructor((TypeConstructor)var3_3));
            $this$renderTypeConstructorAndArguments.append(this.renderTypeArguments(var2_2.getArguments()));
            return;
        }
        this.renderPossiblyInnerType((StringBuilder)var1_1, possiblyInnerType);
    }

    static /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPossiblyInnerType(StringBuilder $this$renderPossiblyInnerType, PossiblyInnerType possiblyInnerType) {
        void var2_2;
        void var1_1;
        block3: {
            Object object;
            block2: {
                void var3_3;
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType it = object;
                this.renderPossiblyInnerType($this$renderPossiblyInnerType, (PossiblyInnerType)var3_3);
                $this$renderPossiblyInnerType.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                object = $this$renderPossiblyInnerType.append(((DescriptorRenderer)this).renderName(name, false));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
            object = $this$renderPossiblyInnerType.append(this.renderTypeConstructor(typeConstructor2));
        }
        var1_1.append(this.renderTypeArguments(var2_2.getArguments()));
    }

    /*
     * WARNING - void declaration
     */
    public final String renderTypeConstructor(TypeConstructor typeConstructor2) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        ClassifierDescriptor cd = typeConstructor2.getDeclarationDescriptor();
        if (cd instanceof TypeParameterDescriptor || cd instanceof ClassDescriptor || cd instanceof TypeAliasDescriptor) {
            return this.renderClassifierName(cd);
        }
        if (cd == null) {
            void var1_1;
            if (typeConstructor2 instanceof IntersectionTypeConstructor) {
                return ((IntersectionTypeConstructor)typeConstructor2).makeDebugNameForIntersectionType(DescriptorRendererImpl$$Lambda$1.INSTANCE);
            }
            return var1_1.toString();
        }
        throw new IllegalStateException(("Unexpected classifier: " + var2_2.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderTypeProjection(TypeProjection typeProjection) {
        void var1_1;
        void var3_3;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)typeProjection, (String)"typeProjection");
        StringBuilder $this$renderTypeProjection_u24lambda_u249 = stringBuilder = new StringBuilder();
        this.appendTypeProjections((StringBuilder)var3_3, CollectionsKt.listOf((Object)var1_1));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendTypeProjections(StringBuilder $this$appendTypeProjections, List<? extends TypeProjection> typeProjections) {
        DescriptorRendererImpl descriptorRendererImpl;
        Appendable appendable = (Appendable)((Object)descriptorRendererImpl);
        descriptorRendererImpl = this;
        CollectionsKt.joinTo$default((Iterable)typeProjections, (Appendable)appendable, (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$$Lambda$2(descriptorRendererImpl), (int)60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFunctionType(StringBuilder $this$renderFunctionType, KotlinType type) {
        void var2_2;
        int lengthBefore2 = $this$renderFunctionType.length();
        DescriptorRendererImpl descriptorRendererImpl = this.getFunctionTypeAnnotationsRenderer();
        DescriptorRendererImpl.renderAnnotations$default(descriptorRendererImpl, $this$renderFunctionType, type, null, 2, null);
        boolean hasAnnotations = $this$renderFunctionType.length() != lengthBefore2;
        KotlinType receiverType = FunctionTypesKt.getReceiverTypeFromFunctionType(type);
        List<KotlinType> contextReceiversTypes = FunctionTypesKt.getContextReceiverTypesFromFunctionType(type);
        boolean isSuspend = FunctionTypesKt.isSuspendFunctionType(type);
        boolean isNullable = type.isMarkedNullable();
        boolean needParenthesis = isNullable || hasAnnotations && receiverType != null;
        if (needParenthesis) {
            if (isSuspend) {
                $this$renderFunctionType.insert(lengthBefore2, '(');
            } else {
                if (hasAnnotations) {
                    lengthBefore2 = CharsKt.isWhitespace((char)StringsKt.last((CharSequence)$this$renderFunctionType)) ? 1 : 0;
                    if (_Assertions.ENABLED && lengthBefore2 == 0) {
                        String lengthBefore2 = "Assertion failed";
                        throw new AssertionError((Object)lengthBefore2);
                    }
                    StringBuilder stringBuilder = $this$renderFunctionType;
                    if (stringBuilder.charAt(StringsKt.getLastIndex((CharSequence)stringBuilder) - 1) != ')') {
                        StringBuilder stringBuilder2 = $this$renderFunctionType;
                        stringBuilder2.insert(StringsKt.getLastIndex((CharSequence)stringBuilder2), "()");
                    }
                }
                $this$renderFunctionType.append("(");
            }
        }
        if (!((Collection)contextReceiversTypes).isEmpty()) {
            $this$renderFunctionType.append("context(");
            Object lengthBefore2 = contextReceiversTypes.subList(0, CollectionsKt.getLastIndex(contextReceiversTypes));
            lengthBefore2 = lengthBefore2.iterator();
            while (lengthBefore2.hasNext()) {
                KotlinType contextReceiverType = (KotlinType)lengthBefore2.next();
                this.renderNormalizedType($this$renderFunctionType, contextReceiverType);
                $this$renderFunctionType.append(", ");
            }
            this.renderNormalizedType($this$renderFunctionType, (KotlinType)CollectionsKt.last(contextReceiversTypes));
            $this$renderFunctionType.append(") ");
        }
        this.renderModifier($this$renderFunctionType, isSuspend, "suspend");
        if (receiverType != null) {
            void var3_6;
            boolean surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable() || this.hasModifiersOrAnnotations(receiverType) || receiverType instanceof DefinitelyNotNullType;
            if (surroundReceiver) {
                $this$renderFunctionType.append("(");
            }
            this.renderNormalizedType($this$renderFunctionType, receiverType);
            if (var3_6 != false) {
                $this$renderFunctionType.append(")");
            }
            $this$renderFunctionType.append(".");
        }
        $this$renderFunctionType.append("(");
        if (FunctionTypesKt.isBuiltinExtensionFunctionalType(type) && type.getArguments().size() <= 1) {
            $this$renderFunctionType.append("???");
        } else {
            Object object = FunctionTypesKt.getValueParameterTypesFromFunctionType(type);
            object = ((Iterable)object).iterator();
            int n = 0;
            while (object.hasNext()) {
                Name name;
                Name name2;
                int index = n++;
                TypeProjection typeProjection = (TypeProjection)object.next();
                if (index > 0) {
                    $this$renderFunctionType.append(", ");
                }
                if (this.getParameterNamesInFunctionalTypes()) {
                    KotlinType kotlinType = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    name2 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType);
                } else {
                    name2 = name = null;
                }
                if (name2 != null) {
                    $this$renderFunctionType.append(((DescriptorRenderer)this).renderName(name, false));
                    $this$renderFunctionType.append(": ");
                }
                $this$renderFunctionType.append(((DescriptorRenderer)this).renderTypeProjection(typeProjection));
            }
        }
        $this$renderFunctionType.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType($this$renderFunctionType, FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)var2_2));
        if (needParenthesis) {
            $this$renderFunctionType.append(")");
        }
        if (isNullable) {
            void var1_1;
            var1_1.append("?");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasModifiersOrAnnotations(KotlinType $this$hasModifiersOrAnnotations) {
        void var1_1;
        return FunctionTypesKt.isSuspendFunctionType($this$hasModifiersOrAnnotations) || !var1_1.getAnnotations().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendDefinedIn(StringBuilder $this$appendDefinedIn, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ModuleDescriptor)) {
            void var3_3;
            $this$appendDefinedIn.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
            FqNameUnsafe fqName = fqNameUnsafe;
            $this$appendDefinedIn.append(fqName.isRoot() ? "root package" : ((DescriptorRenderer)this).renderFqName(fqName));
            if (this.getWithSourceFileForTopLevel() && var3_3 instanceof PackageFragmentDescriptor && descriptor2 instanceof DeclarationDescriptorWithSource) {
                String string = ((DeclarationDescriptorWithSource)descriptor2).getSource().getContainingFile().getName();
                if (string != null) {
                    void var2_2;
                    void var1_1;
                    String sourceFileName = string;
                    var1_1.append(" ").append(this.renderMessage("in file")).append(" ").append((String)var2_2);
                    return;
                }
            }
        }
    }

    private final void renderAnnotations(StringBuilder $this$renderAnnotations, Annotated annotated, AnnotationUseSiteTarget target) {
        Iterator iterator2;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> annotationFilter = this.getAnnotationFilter();
        for (AnnotationDescriptor annotation : iterator2.getAnnotations()) {
            if (CollectionsKt.contains((Iterable)excluded, (Object)annotation.getFqName()) || this.isParameterName(annotation) || annotationFilter != null && !((Boolean)annotationFilter.invoke((Object)annotation)).booleanValue()) continue;
            $this$renderAnnotations.append(((DescriptorRenderer)this).renderAnnotation(annotation, target));
            if (this.getEachAnnotationOnNewLine()) {
                Intrinsics.checkNotNullExpressionValue((Object)$this$renderAnnotations.append('\n'), (String)"append(...)");
                continue;
            }
            $this$renderAnnotations.append(" ");
        }
    }

    static /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, Annotated annotated, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            annotationUseSiteTarget = null;
        }
        descriptorRendererImpl.renderAnnotations(stringBuilder, annotated, annotationUseSiteTarget);
    }

    private final boolean isParameterName(AnnotationDescriptor $this$isParameterName) {
        return Intrinsics.areEqual((Object)$this$isParameterName.getFqName(), (Object)StandardNames.FqNames.parameterName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String renderAnnotation(AnnotationDescriptor annotation, AnnotationUseSiteTarget target) {
        void var2_2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        StringBuilder $this$renderAnnotation_u24lambda_u2413 = stringBuilder = new StringBuilder();
        stringBuilder.append('@');
        if (target != null) {
            $this$renderAnnotation_u24lambda_u2413.append(target.getRenderName() + ':');
        }
        KotlinType annotationType = annotation.getType();
        $this$renderAnnotation_u24lambda_u2413.append(((DescriptorRenderer)this).renderType(annotationType));
        if (this.getIncludeAnnotationArguments()) {
            List<String> arguments = this.renderAndSortAnnotationArguments(annotation);
            if (this.getIncludeEmptyAnnotationArguments() || !((Collection)arguments).isEmpty()) {
                void var1_1;
                CollectionsKt.joinTo$default((Iterable)((Iterable)var1_1), (Appendable)$this$renderAnnotation_u24lambda_u2413, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError(annotationType) || var2_2.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor)) {
            $this$renderAnnotation_u24lambda_u2413.append(" /* annotation class not found */");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        Map.Entry $this$mapTo$iv$iv;
        Iterator $this$mapTo$iv$iv2;
        Name it;
        Object $this$filterTo$iv$iv;
        List list;
        List list2;
        Iterable<String> iterable;
        Iterable item$iv$iv2;
        Iterable destination$iv$iv;
        List<ValueParameterDescriptor> list3;
        Object object;
        Map<Name, ConstantValue<?>> allValueArguments = descriptor2.getAllValueArguments();
        DeclarationDescriptorNonRoot classDescriptor = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass(descriptor2) : null;
        if (classDescriptor != null && (object = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null && (list3 = object.getValueParameters()) != null) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv;
            Iterable $this$filterTo$iv$iv2;
            object = list3;
            Iterable iterable2 = object;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                classDescriptor = (ValueParameterDescriptor)element$iv$iv;
                if (!classDescriptor.declaresDefaultValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterTo$iv$iv2 = $this$map$iv = (Iterable)((List)destination$iv$iv);
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Iterable item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it2;
                classDescriptor = (ValueParameterDescriptor)((Object)item$iv$iv2);
                iterable = destination$iv$iv;
                iterable.add(it2.getName());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        destination$iv$iv = item$iv$iv2 = (Iterable)list;
        Iterable destination$iv$iv2 = new ArrayList();
        $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv$iv = $this$filterTo$iv$iv.next();
            it = (Name)element$iv$iv;
            if (!(!allValueArguments.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv2;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $this$mapTo$iv$iv2 = $this$mapTo$iv$iv2.iterator();
        while ($this$mapTo$iv$iv2.hasNext()) {
            Object item$iv$iv3 = $this$mapTo$iv$iv2.next();
            it = (Name)item$iv$iv3;
            iterable = destination$iv$iv2;
            iterable.add((String)(it.asString() + " = ..."));
        }
        List defaultList = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = allValueArguments.entrySet();
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            Object item$iv$iv4 = iterator2.next();
            $this$mapTo$iv$iv = (Map.Entry)item$iv$iv4;
            iterable = destination$iv$iv3;
            Name name = (Name)$this$mapTo$iv$iv.getKey();
            ConstantValue value = (ConstantValue)$this$mapTo$iv$iv.getValue();
            iterable.add((String)(name.asString() + " = " + (!parameterDescriptorsWithDefaultValue.contains(var2_2) ? this.renderConstant(value) : "...")));
        }
        List argumentList = (List)destination$iv$iv3;
        return CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)((Collection)object), (Iterable)argumentList));
    }

    /*
     * WARNING - void declaration
     */
    private final String renderConstant(ConstantValue<?> value) {
        void var1_1;
        String it$iv$iv;
        Iterator $this$mapNotNullTo$iv$iv;
        Object object = this.options.getPropertyConstantRenderer();
        if (object != null) {
            return (String)object.invoke(value);
        }
        object = value;
        if (object instanceof ArrayValue) {
            void var3_4;
            value = (Iterable)((ArrayValue)value).getValue();
            Collection destination$iv$iv = new ArrayList();
            $this$mapNotNullTo$iv$iv = $this$mapNotNullTo$iv$iv.iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                Object t = $this$mapNotNullTo$iv$iv.next();
                object = t;
                object = t;
                ConstantValue it = (ConstantValue)t;
                if (this.renderConstant(it) == null) continue;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)var3_4), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, null, (int)56, null);
        }
        if (it$iv$iv instanceof AnnotationValue) {
            return StringsKt.removePrefix((String)DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)((Object)$this$mapNotNullTo$iv$iv)).getValue(), null, 2, null), (CharSequence)"@");
        }
        if (it$iv$iv instanceof KClassValue) {
            KClassValue.Value classValue = (KClassValue.Value)((KClassValue)((Object)$this$mapNotNullTo$iv$iv)).getValue();
            if (classValue instanceof KClassValue.Value.LocalClass) {
                return ((KClassValue.Value.LocalClass)classValue).getType() + "::class";
            }
            if (classValue instanceof KClassValue.Value.NormalClass) {
                String string = ((KClassValue.Value.NormalClass)classValue).getClassId().asSingleFqName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String type = string;
                int n = ((KClassValue.Value.NormalClass)var1_1).getArrayDimensions();
                for (int i = 0; i < n; ++i) {
                    type = "kotlin.Array<" + type + '>';
                }
                return object + "::class";
            }
            throw new NoWhenBranchMatchedException();
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean renderVisibility(DescriptorVisibility visibility, StringBuilder builder) {
        void var1_1;
        void var2_2;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return false;
        }
        if (this.getNormalizedVisibilities()) {
            visibility = visibility.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual((Object)visibility, (Object)DescriptorVisibilities.DEFAULT_VISIBILITY)) {
            return false;
        }
        var2_2.append(this.renderKeyword(var1_1.getInternalDisplayName())).append(" ");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderModality(Modality modality, StringBuilder builder, Modality defaultModality) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (!this.getRenderDefaultModality() && modality == var3_3) {
            return;
        }
        this.renderModifier((StringBuilder)var2_2, this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(var1_1.name()));
    }

    /*
     * WARNING - void declaration
     */
    private final Modality implicitModalityWithoutExtensions(MemberDescriptor $this$implicitModalityWithoutExtensions) {
        if ($this$implicitModalityWithoutExtensions instanceof ClassDescriptor) {
            if (((ClassDescriptor)$this$implicitModalityWithoutExtensions).getKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        DeclarationDescriptor declarationDescriptor = $this$implicitModalityWithoutExtensions.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return Modality.FINAL;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        if (!($this$implicitModalityWithoutExtensions instanceof CallableMemberDescriptor)) {
            return Modality.FINAL;
        }
        Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)$this$implicitModalityWithoutExtensions).getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
        if (!collection.isEmpty() && containingClassDescriptor.getModality() != Modality.FINAL) {
            return Modality.OPEN;
        }
        if (declarationDescriptor.getKind() == ClassKind.INTERFACE && !Intrinsics.areEqual((Object)((CallableMemberDescriptor)$this$implicitModalityWithoutExtensions).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            void var1_1;
            if (((CallableMemberDescriptor)var1_1).getModality() == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        return Modality.FINAL;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            void var1_1;
            void var2_2;
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN && this.overridesSomething(callable)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"getModality(...)");
            this.renderModality(modality, (StringBuilder)var2_2, this.implicitModalityWithoutExtensions((MemberDescriptor)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(builder, true, "override");
            if (this.getVerbose()) {
                void var1_1;
                void var2_2;
                var2_2.append("/*").append(var1_1.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            void var1_1;
            void var2_2;
            var2_2.append("/*").append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(var1_1.getKind().name())).append("*/ ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderModifier(StringBuilder builder, boolean value, String modifier) {
        if (value) {
            void var1_1;
            void var3_3;
            builder.append(this.renderKeyword((String)var3_3));
            var1_1.append(" ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderMemberModifiers(MemberDescriptor descriptor2, StringBuilder builder) {
        void var1_1;
        void var2_2;
        this.renderModifier(builder, descriptor2.isExternal(), "external");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && descriptor2.isExpect(), "expect");
        this.renderModifier((StringBuilder)var2_2, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && var1_1.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        if (!functionDescriptor.isOperator()) ** GOTO lbl-1000
        v0 = functionDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(v0, (String)"getOverriddenDescriptors(...)");
        $this$none$iv = v0;
        if (!((Collection)$this$none$iv).isEmpty()) {
            var3_5 = $this$none$iv.iterator();
            while (var3_5.hasNext()) {
                $this$none$iv = var3_5.next();
                var5_7 /* !! */  = (FunctionDescriptor)$this$none$iv;
                if (!var5_7 /* !! */ .isOperator()) continue;
                v1 = false;
                break;
            }
        } else {
            v1 = true;
        }
        if (v1 || this.getAlwaysRenderModifiers()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isOperator = false;
        }
        if (!functionDescriptor.isInfix()) ** GOTO lbl-1000
        v3 = functionDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(v3, (String)"getOverriddenDescriptors(...)");
        $this$none$iv = v3;
        if (!((Collection)$this$none$iv).isEmpty()) {
            $this$none$iv = $this$none$iv.iterator();
            while ($this$none$iv.hasNext()) {
                var5_7 /* !! */  = $this$none$iv.next();
                if (!(var5_7 /* !! */  = (FunctionDescriptor)var5_7 /* !! */ ).isInfix()) continue;
                v4 = false;
                break;
            }
        } else {
            v4 = true;
        }
        if (v4 || this.getAlwaysRenderModifiers()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        isInfix = v5;
        this.renderModifier(builder, functionDescriptor.isTailrec(), "tailrec");
        this.renderSuspendModifier(functionDescriptor, builder);
        this.renderModifier(builder, var1_1.isInline(), "inline");
        this.renderModifier(builder, isInfix, "infix");
        this.renderModifier((StringBuilder)var2_2, (boolean)var3_6, "operator");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        void var1_1;
        void var2_2;
        this.renderModifier((StringBuilder)var2_2, var1_1.isSuspend(), "suspend");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String render(DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"declarationDescriptor");
        StringBuilder $this$render_u24lambda_u2424 = stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(this), $this$render_u24lambda_u2424);
        if (this.getWithDefinedIn()) {
            void var1_1;
            void var3_3;
            this.appendDefinedIn((StringBuilder)var3_3, (DeclarationDescriptor)var1_1);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        void var3_3;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        this.renderModifier(builder, typeParameter.isReified(), "reified");
        String variance = typeParameter.getVariance().getLabel();
        this.renderModifier(builder, ((CharSequence)variance).length() > 0, variance);
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeParameter, null, 2, null);
        this.renderName(typeParameter, builder, topLevel);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder = builder.append(" : ");
                Intrinsics.checkNotNull((Object)upperBound);
                stringBuilder.append(((DescriptorRenderer)this).renderType(upperBound));
            }
        } else if (topLevel) {
            Iterator<KotlinType> iterator2;
            boolean first = true;
            for (KotlinType upperBound : iterator2.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                Intrinsics.checkNotNull((Object)upperBound);
                builder.append(((DescriptorRenderer)this).renderType(upperBound));
                first = false;
            }
        }
        if (var3_3 != false) {
            void var2_2;
            var2_2.append(this.gt());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!((Collection)typeParameters).isEmpty()) {
            void var3_3;
            void var1_1;
            builder.append(this.lt());
            this.renderTypeParameterList(builder, (List<? extends TypeParameterDescriptor>)var1_1);
            builder.append(this.gt());
            if (var3_3 != false) {
                void var2_2;
                var2_2.append(" ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter((TypeParameterDescriptor)var3_3, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        void var2_2;
        void var1_1;
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                List<ReceiverParameterDescriptor> list = function.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceiverParameters(...)");
                this.renderContextReceivers(list, builder);
                DescriptorRendererImpl.renderAnnotations$default(this, builder, function, null, 2, null);
                DescriptorVisibility descriptorVisibility = function.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
                this.renderVisibility(descriptorVisibility, builder);
                this.renderModalityForCallable(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(function, builder);
                }
                this.renderOverride(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(function, builder);
                } else {
                    this.renderSuspendModifier(function, builder);
                }
                this.renderMemberKind(function, builder);
                if (this.getVerbose()) {
                    if (function.isHiddenToOvercomeSignatureClash()) {
                        builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (function.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        builder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder, true);
        List<ValueParameterDescriptor> list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType != null && KotlinBuiltIns.isUnit(returnType))) {
            void var3_3;
            void v4 = var3_3;
            builder.append(": ").append(v4 == null ? "[NULL]" : ((DescriptorRenderer)this).renderType((KotlinType)v4));
        }
        List<TypeParameterDescriptor> list2 = var1_1.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        this.renderWhereSuffix(list2, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            void var1_1;
            void var2_2;
            StringBuilder stringBuilder = var2_2.append(" on ");
            KotlinType kotlinType = var1_1.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            stringBuilder.append(((DescriptorRenderer)this).renderType(kotlinType));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String renderForReceiver(KotlinType $this$renderForReceiver) {
        void var2_2;
        void var1_1;
        String result = ((DescriptorRenderer)this).renderType($this$renderForReceiver);
        if (this.shouldRenderAsPrettyFunctionType($this$renderForReceiver) && !TypeUtils.isNullableType($this$renderForReceiver) || var1_1 instanceof DefinitelyNotNullType) {
            result = "(" + result + ')';
        }
        return var2_2;
    }

    private final void renderContextReceivers(List<? extends ReceiverParameterDescriptor> contextReceivers, StringBuilder builder) {
        if (!(!((Collection)contextReceivers).isEmpty())) {
            return;
        }
        builder.append("context(");
        Iterator iterator2 = ((Iterable)contextReceivers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            ReceiverParameterDescriptor contextReceiver = (ReceiverParameterDescriptor)iterator2.next();
            this.renderAnnotations(builder, contextReceiver, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = contextReceiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            String typeString = this.renderForReceiver(kotlinType);
            builder.append(typeString);
            if (i == CollectionsKt.getLastIndex(contextReceivers)) {
                builder.append(") ");
                continue;
            }
            builder.append(", ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            void var1_1;
            void var2_2;
            this.renderAnnotations(builder, receiver, AnnotationUseSiteTarget.RECEIVER);
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            String typeString = this.renderForReceiver(kotlinType);
            var2_2.append((String)var1_1).append(".");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, builder, constructor, null, 2, null);
        if (!this.options.getRenderDefaultVisibility() && constructor.getConstructedClass().getModality() == Modality.SEALED) ** GOTO lbl-1000
        v0 = constructor.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getVisibility(...)");
        if (this.renderVisibility(v0, builder)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        visibilityRendered = v1;
        this.renderMemberKind(constructor, builder);
        constructorKeywordRendered = this.getRenderConstructorKeyword() != false || constructor.isPrimary() == false || visibilityRendered != false;
        if (constructorKeywordRendered) {
            builder.append(this.renderKeyword("constructor"));
        }
        v2 = constructor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getContainingDeclaration(...)");
        classDescriptor = v2;
        if (this.getSecondaryConstructorsAsPrimary()) {
            if (constructorKeywordRendered) {
                builder.append(" ");
            }
            this.renderName(classDescriptor, builder, true);
            v3 = constructor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v3, (String)"getTypeParameters(...)");
            this.renderTypeParameters(v3, builder, false);
        }
        v4 = constructor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(v4, (String)"getValueParameters(...)");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)v4, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getRenderConstructorDelegation() && !constructor.isPrimary() && classDescriptor instanceof ClassDescriptor && (primaryConstructor = ((ClassDescriptor)classDescriptor).getUnsubstitutedPrimaryConstructor()) != null) {
            v5 = primaryConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v5, (String)"getValueParameters(...)");
            primaryConstructor = v5;
            destination$iv$iv = new ArrayList<E>();
            $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv$iv = $this$filterTo$iv$iv.next();
                it = (ValueParameterDescriptor)element$iv$iv;
                if (!(it.declaresDefaultValue() == false && it.getVarargElementType() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            parametersWithoutDefault = (List)destination$iv$iv;
            if (((Collection)parametersWithoutDefault).isEmpty() == false) {
                builder.append(" : ").append(this.renderKeyword("this"));
                builder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)var3_4), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)DescriptorRendererImpl$$Lambda$3.INSTANCE, (int)24, null));
            }
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            v6 = var1_1.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(v6, (String)"getTypeParameters(...)");
            this.renderWhereSuffix(v6, (StringBuilder)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder) {
        Iterator iterator2;
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)iterator2.next();
            List<KotlinType> list = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
            Object object = CollectionsKt.drop((Iterable)list, (int)1);
            object = object.iterator();
            while (object.hasNext()) {
                void it;
                Object item$iv = object.next();
                item$iv = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameter.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                StringBuilder stringBuilder2 = stringBuilder.append(((DescriptorRenderer)this).renderName(name, false)).append(" : ");
                Intrinsics.checkNotNull((Object)it);
                collection.add(stringBuilder2.append(((DescriptorRenderer)this).renderType((KotlinType)it)).toString());
            }
        }
        if (!((Collection)upperBoundStrings).isEmpty()) {
            void var2_2;
            void var3_3;
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)((Iterable)var3_3), (Appendable)((Appendable)var2_2), (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters, boolean synthesizedParameterNames, StringBuilder builder) {
        void var3_3;
        Iterator iterator2;
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        iterator2 = ((Iterable)((Object)iterator2)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)iterator2.next();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (WhenMappings.$EnumSwitchMapping$1[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                void var1_1;
                return var1_1 == false;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Unable to fully structure code
     */
    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, builder, valueParameter, null, 2, null);
        this.renderModifier(builder, valueParameter.isCrossinline(), "crossinline");
        this.renderModifier(builder, valueParameter.isNoinline(), "noinline");
        if (!this.getRenderPrimaryConstructorParametersAsProperties()) ** GOTO lbl-1000
        var5_5 = valueParameter.getContainingDeclaration();
        v0 = var5_5 instanceof ClassConstructorDescriptor != false ? (ClassConstructorDescriptor)var5_5 : null;
        v1 = v0 != null ? v0.isPrimary() : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isPrimaryConstructor = false;
        }
        if (v2) {
            this.renderModifier(builder, this.getActualPropertiesInPrimaryConstructor(), "actual");
        }
        this.renderVariable(valueParameter, var2_2, builder, topLevel, isPrimaryConstructor);
        if (this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() != false ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameter)) != false ? true : (var2_2 = false)) {
            v3 = new StringBuilder(" = ");
            v4 = this.getDefaultParameterValueRenderer();
            Intrinsics.checkNotNull(v4);
            var3_3.append(v3.append((String)v4.invoke((Object)var1_1)).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder, boolean isInPrimaryConstructor) {
        if (isInPrimaryConstructor || !(variable instanceof ValueParameterDescriptor)) {
            void var1_1;
            void var2_2;
            var2_2.append(this.renderKeyword(var1_1.isVar() ? "var" : "val")).append(" ");
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(DescriptorRendererImpl descriptorRendererImpl, VariableDescriptor variableDescriptor, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderValVarPrefix(variableDescriptor, stringBuilder, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel, boolean isInPrimaryConstructor) {
        void var1_1;
        void var2_2;
        KotlinType kotlinType = variable.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType realType = kotlinType;
        ValueParameterDescriptor valueParameterDescriptor = variable instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)variable : null;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType2 = varargElementType;
        if (varargElementType == null) {
            kotlinType2 = realType;
        }
        KotlinType typeToRender = kotlinType2;
        this.renderModifier(builder, varargElementType != null, "vararg");
        if (isInPrimaryConstructor || topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder, isInPrimaryConstructor);
        }
        if (var2_2 != false) {
            this.renderName(variable, builder, topLevel);
            builder.append(": ");
        }
        builder.append(((DescriptorRenderer)this).renderType(typeToRender));
        this.renderInitializer((VariableDescriptor)var1_1, builder);
        if (this.getVerbose() && varargElementType != null) {
            void var3_3;
            var3_3.append(" /*").append(((DescriptorRenderer)this).renderType(realType)).append("*/");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        void var2_2;
        void var1_1;
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                List<ReceiverParameterDescriptor> list = property.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceiverParameters(...)");
                this.renderContextReceivers(list, builder);
                this.renderPropertyAnnotations(property, builder);
                DescriptorVisibility descriptorVisibility = property.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
                this.renderVisibility(descriptorVisibility, builder);
                this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.CONST) && property.isConst(), "const");
                this.renderMemberModifiers(property, builder);
                this.renderModalityForCallable(property, builder);
                this.renderOverride(property, builder);
                this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.LATEINIT) && property.isLateInit(), "lateinit");
                this.renderMemberKind(property, builder);
            }
            DescriptorRendererImpl.renderValVarPrefix$default(this, property, builder, false, 4, null);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder, true);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        stringBuilder.append(((DescriptorRenderer)this).renderType(kotlinType));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = var1_1.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
        this.renderWhereSuffix(list, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPropertyAnnotations(PropertyDescriptor property, StringBuilder builder) {
        Annotated it;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        DescriptorRendererImpl.renderAnnotations$default(this, builder, property, null, 2, null);
        FieldDescriptor fieldDescriptor = property.getBackingField();
        if (fieldDescriptor != null) {
            it = fieldDescriptor;
            this.renderAnnotations(builder, it, AnnotationUseSiteTarget.FIELD);
        }
        FieldDescriptor fieldDescriptor2 = property.getDelegateField();
        if (fieldDescriptor2 != null) {
            it = fieldDescriptor2;
            this.renderAnnotations(builder, it, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
        }
        if (this.getPropertyAccessorRenderingPolicy() == PropertyAccessorRenderingPolicy.NONE) {
            PropertyGetterDescriptor propertyGetterDescriptor = property.getGetter();
            if (propertyGetterDescriptor != null) {
                it = propertyGetterDescriptor;
                this.renderAnnotations(builder, it, AnnotationUseSiteTarget.PROPERTY_GETTER);
            }
            PropertySetterDescriptor propertySetterDescriptor = property.getSetter();
            if (propertySetterDescriptor != null) {
                void var1_1;
                void var2_2;
                void var3_3;
                PropertySetterDescriptor setter = propertySetterDescriptor;
                CallableDescriptor it2 = propertySetterDescriptor;
                this.renderAnnotations(builder, it2, AnnotationUseSiteTarget.PROPERTY_SETTER);
                List<ValueParameterDescriptor> list = var3_3.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
                it2 = (ValueParameterDescriptor)CollectionsKt.single(list);
                Intrinsics.checkNotNull((Object)it2);
                this.renderAnnotations((StringBuilder)var2_2, (Annotated)var1_1, AnnotationUseSiteTarget.SETTER_PARAMETER);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        if (this.getIncludePropertyConstant()) {
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constant = constantValue;
                String renderedConstant = this.renderConstant(constant);
                if (renderedConstant != null) {
                    void var1_1;
                    void var2_2;
                    var2_2.append(" = ").append(this.escape((String)var1_1));
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeAlias(TypeAliasDescriptor typeAlias, StringBuilder builder) {
        void var1_1;
        void var2_2;
        DescriptorRendererImpl.renderAnnotations$default(this, builder, typeAlias, null, 2, null);
        DescriptorVisibility descriptorVisibility = typeAlias.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
        this.renderVisibility(descriptorVisibility, builder);
        this.renderMemberModifiers(typeAlias, builder);
        builder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAlias, builder, true);
        List<TypeParameterDescriptor> list = typeAlias.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclaredTypeParameters(...)");
        this.renderTypeParameters(list, builder, false);
        this.renderCapturedTypeParametersIfRequired(typeAlias, builder);
        var2_2.append(" = ").append(((DescriptorRenderer)this).renderType(var1_1.getUnderlyingType()));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifier, StringBuilder builder) {
        void var1_1;
        List<TypeParameterDescriptor> list = classifier.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclaredTypeParameters(...)");
        List<TypeParameterDescriptor> typeParameters = list;
        List<TypeParameterDescriptor> list2 = classifier.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
        List<TypeParameterDescriptor> typeConstructorParameters = list2;
        if (this.getVerbose() && var1_1.isInner() && typeConstructorParameters.size() > typeParameters.size()) {
            void var2_2;
            void var3_3;
            builder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(builder, typeConstructorParameters.subList(var3_3.size(), typeConstructorParameters.size()));
            var2_2.append("*/");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        void var2_2;
        void var3_4;
        void var1_1;
        ClassConstructorDescriptor primaryConstructor;
        boolean isEnumEntry;
        boolean bl = isEnumEntry = klass.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            List<ReceiverParameterDescriptor> list = klass.getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContextReceivers(...)");
            this.renderContextReceivers(list, builder);
            DescriptorRendererImpl.renderAnnotations$default(this, builder, klass, null, 2, null);
            if (!isEnumEntry) {
                DescriptorVisibility descriptorVisibility = klass.getVisibility();
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
                this.renderVisibility(descriptorVisibility, builder);
            }
            if (!(klass.getKind() == ClassKind.INTERFACE && klass.getModality() == Modality.ABSTRACT || klass.getKind().isSingleton() && klass.getModality() == Modality.FINAL)) {
                Modality modality = klass.getModality();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)modality), (String)"getModality(...)");
                this.renderModality(modality, builder, this.implicitModalityWithoutExtensions(klass));
            }
            this.renderMemberModifiers(klass, builder);
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && klass.isInner(), "inner");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && klass.isData(), "data");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && klass.isInline(), "inline");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.VALUE) && klass.isValue(), "value");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.FUN) && klass.isFun(), "fun");
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder, true);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = klass.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDeclaredTypeParameters(...)");
        List<TypeParameterDescriptor> typeParameters = list;
        this.renderTypeParameters(typeParameters, builder, false);
        this.renderCapturedTypeParametersIfRequired(klass, builder);
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            DescriptorRendererImpl.renderAnnotations$default(this, builder, primaryConstructor, null, 2, null);
            DescriptorVisibility descriptorVisibility = primaryConstructor.getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
            this.renderVisibility(descriptorVisibility, builder);
            builder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list2 = primaryConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list2, primaryConstructor.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes((ClassDescriptor)var1_1, builder);
        this.renderWhereSuffix((List<? extends TypeParameterDescriptor>)var3_4, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        void var2_2;
        DescriptorRendererImpl descriptorRendererImpl;
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
            return;
        }
        Collection<KotlinType> collection = klass.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
        Collection<KotlinType> supertypes = collection;
        if (collection.isEmpty() || supertypes.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        Iterable iterable = (Iterable)((Object)descriptorRendererImpl);
        descriptorRendererImpl = this;
        CollectionsKt.joinTo$default((Iterable)iterable, (Appendable)((Appendable)var2_2), (CharSequence)", ", null, null, (int)0, null, (Function1)new DescriptorRendererImpl$$Lambda$4(descriptorRendererImpl), (int)60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        void var1_1;
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix((ClassifierDescriptorWithTypeParameters)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        this.renderPackageHeader(packageView.getFqName(), "package", builder);
        if (this.getDebugMode()) {
            void var2_2;
            void var1_1;
            builder.append(" in context of ");
            this.renderName(var1_1.getModule(), (StringBuilder)var2_2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        this.renderPackageHeader(fragment.getFqName(), "package-fragment", builder);
        if (this.getDebugMode()) {
            void var2_2;
            void var1_1;
            builder.append(" in ");
            this.renderName(var1_1.getContainingDeclaration(), (StringBuilder)var2_2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderPackageHeader(FqName fqName, String fragmentOrView, StringBuilder builder) {
        void var2_2;
        builder.append(this.renderKeyword((String)var2_2));
        FqNameUnsafe fqNameUnsafe = fqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
        String fqNameString = ((DescriptorRenderer)this).renderFqName(fqNameUnsafe);
        if (((CharSequence)fqNameString).length() > 0) {
            void var1_1;
            void var3_3;
            builder.append(" ");
            var3_3.append((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        void var2_2;
        void var1_1;
        this.renderMemberModifiers((MemberDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSpaceIfNeeded(StringBuilder builder) {
        void var2_2;
        int length = builder.length();
        if (length == 0 || builder.charAt((int)(var2_2 - true)) != ' ') {
            void var1_1;
            var1_1.append(' ');
        }
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    private static final Unit functionTypeAnnotationsRenderer_delegate$lambda$1$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
        Set<FqName> set = objectArray.getExcludedTypeAnnotationClasses();
        Object[] objectArray2 = new FqName[2];
        objectArray = objectArray2;
        objectArray2[0] = StandardNames.FqNames.extensionFunctionType;
        objectArray[1] = StandardNames.FqNames.contextFunctionTypeParams;
        objectArray.setExcludedTypeAnnotationClasses(SetsKt.plus(set, (Iterable)CollectionsKt.listOf((Object[])objectArray)));
        return Unit.INSTANCE;
    }

    private static final DescriptorRendererImpl functionTypeAnnotationsRenderer_delegate$lambda$1(DescriptorRendererImpl this$0) {
        DescriptorRenderer descriptorRenderer = this$0.withOptions(DescriptorRendererImpl$$Lambda$5.INSTANCE);
        Intrinsics.checkNotNull((Object)descriptorRenderer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.renderer.DescriptorRendererImpl");
        return (DescriptorRendererImpl)descriptorRenderer;
    }

    private static final Object renderTypeConstructor$lambda$8(KotlinType it) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof StubTypeForBuilderInference) {
            return ((StubTypeForBuilderInference)it).getOriginalTypeVariable();
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence appendTypeProjections$lambda$10(DescriptorRendererImpl this$0, TypeProjection it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isStarProjection()) {
            object = "*";
        } else {
            String string;
            void var1_1;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            String type = ((DescriptorRenderer)this$0).renderType(kotlinType);
            object = it.getProjectionKind() == Variance.INVARIANT ? type : (Object)((Object)var1_1.getProjectionKind()) + ' ' + (String)string;
        }
        return (CharSequence)object;
    }

    private static final CharSequence renderConstructor$lambda$26(ValueParameterDescriptor it) {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence renderSuperTypes$lambda$36(DescriptorRendererImpl this$0, KotlinType it) {
        void var1_1;
        Intrinsics.checkNotNull((Object)it);
        return ((DescriptorRenderer)this$0).renderType((KotlinType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderValueParameter(DescriptorRendererImpl $this, ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.renderValueParameter((ValueParameterDescriptor)var1_1, (boolean)var2_2, (StringBuilder)var3_3, topLevel);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderProperty(DescriptorRendererImpl $this, PropertyDescriptor property, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderProperty((PropertyDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderAccessorModifiers(DescriptorRendererImpl $this, PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderAccessorModifiers((PropertyAccessorDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderFunction(DescriptorRendererImpl $this, FunctionDescriptor function, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderFunction((FunctionDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderConstructor(DescriptorRendererImpl $this, ConstructorDescriptor constructor, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderConstructor((ConstructorDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderTypeParameter(DescriptorRendererImpl $this, TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.renderTypeParameter((TypeParameterDescriptor)var1_1, (StringBuilder)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderPackageFragment(DescriptorRendererImpl $this, PackageFragmentDescriptor fragment, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderPackageFragment((PackageFragmentDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderPackageView(DescriptorRendererImpl $this, PackageViewDescriptor packageView, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderPackageView((PackageViewDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderName(DescriptorRendererImpl $this, DeclarationDescriptor descriptor2, StringBuilder builder, boolean rootRenderedElement) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.renderName((DeclarationDescriptor)var1_1, (StringBuilder)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderClass(DescriptorRendererImpl $this, ClassDescriptor klass, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderClass((ClassDescriptor)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$renderTypeAlias(DescriptorRendererImpl $this, TypeAliasDescriptor typeAlias, StringBuilder builder) {
        void var2_2;
        void var1_1;
        $this.renderTypeAlias((TypeAliasDescriptor)var1_1, (StringBuilder)var2_2);
    }

    static /* synthetic */ DescriptorRendererImpl accessor$DescriptorRendererImpl$lambda0(DescriptorRendererImpl descriptorRendererImpl) {
        return DescriptorRendererImpl.functionTypeAnnotationsRenderer_delegate$lambda$1(descriptorRendererImpl);
    }

    static /* synthetic */ Object accessor$DescriptorRendererImpl$lambda1(KotlinType kotlinType) {
        return DescriptorRendererImpl.renderTypeConstructor$lambda$8(kotlinType);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda2(DescriptorRendererImpl descriptorRendererImpl, TypeProjection typeProjection) {
        return DescriptorRendererImpl.appendTypeProjections$lambda$10(descriptorRendererImpl, typeProjection);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda3(ValueParameterDescriptor valueParameterDescriptor) {
        return DescriptorRendererImpl.renderConstructor$lambda$26(valueParameterDescriptor);
    }

    static /* synthetic */ CharSequence accessor$DescriptorRendererImpl$lambda4(DescriptorRendererImpl descriptorRendererImpl, KotlinType kotlinType) {
        return DescriptorRendererImpl.renderSuperTypes$lambda$36(descriptorRendererImpl, kotlinType);
    }

    static /* synthetic */ Unit accessor$DescriptorRendererImpl$lambda5(DescriptorRendererOptions descriptorRendererOptions) {
        return DescriptorRendererImpl.functionTypeAnnotationsRenderer_delegate$lambda$1$lambda$0(descriptorRendererOptions);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        final /* synthetic */ DescriptorRendererImpl this$0;

        /*
         * WARNING - void declaration
         */
        public RenderDeclarationDescriptorVisitor(DescriptorRendererImpl this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitValueParameterDescriptor(ValueParameterDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderValueParameter(this.this$0, (ValueParameterDescriptor)var1_1, true, (StringBuilder)var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitPropertyDescriptor(PropertyDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderProperty(this.this$0, (PropertyDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitPropertyGetterDescriptor(PropertyGetterDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.visitPropertyAccessorDescriptor((PropertyAccessorDescriptor)var1_1, (StringBuilder)var2_2, "getter");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitPropertySetterDescriptor(PropertySetterDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.visitPropertyAccessorDescriptor((PropertyAccessorDescriptor)var1_1, (StringBuilder)var2_2, "setter");
        }

        /*
         * WARNING - void declaration
         */
        private final void visitPropertyAccessorDescriptor(PropertyAccessorDescriptor descriptor2, StringBuilder builder, String kind) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.this$0.getPropertyAccessorRenderingPolicy().ordinal()]) {
                case 1: {
                    void var3_3;
                    DescriptorRendererImpl.access$renderAccessorModifiers(this.this$0, descriptor2, builder);
                    builder.append((String)var3_3 + " for ");
                    PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                    DescriptorRendererImpl.access$renderProperty(this.this$0, propertyDescriptor, builder);
                    return;
                }
                case 2: {
                    void var2_2;
                    void var1_1;
                    this.visitFunctionDescriptor((FunctionDescriptor)var1_1, (StringBuilder)var2_2);
                    return;
                }
                case 3: {
                    return;
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitFunctionDescriptor(FunctionDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderFunction(this.this$0, (FunctionDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2, StringBuilder builder) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            var2_2.append(var1_1.getName());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)constructorDescriptor, (String)"constructorDescriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderConstructor(this.this$0, (ConstructorDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderTypeParameter(this.this$0, (TypeParameterDescriptor)var1_1, (StringBuilder)var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderPackageFragment(this.this$0, (PackageFragmentDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitPackageViewDescriptor(PackageViewDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderPackageView(this.this$0, (PackageViewDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitModuleDeclaration(ModuleDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderName(this.this$0, (DeclarationDescriptor)var1_1, (StringBuilder)var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitClassDescriptor(ClassDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderClass(this.this$0, (ClassDescriptor)var1_1, (StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void visitTypeAliasDescriptor(TypeAliasDescriptor descriptor2, StringBuilder builder) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            DescriptorRendererImpl.access$renderTypeAlias(this.this$0, (TypeAliasDescriptor)var1_1, (StringBuilder)var2_2);
        }

        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PropertyAccessorRenderingPolicy.values().length];
                try {
                    nArray[PropertyAccessorRenderingPolicy.PRETTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[PropertyAccessorRenderingPolicy.DEBUG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[PropertyAccessorRenderingPolicy.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenderingFormat.values().length];
            try {
                nArray[RenderingFormat.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[RenderingFormat.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ParameterNameRenderingPolicy.values().length];
            try {
                nArray[ParameterNameRenderingPolicy.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ParameterNameRenderingPolicy.ONLY_NON_SYNTHESIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ParameterNameRenderingPolicy.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

